/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class GenModelAccess {
    public static GenClass getGenClass(EClass cls) {
        return (GenClass)GenModelAccess.getGenClassifier((EClassifier)cls);
    }

    public static GenClassifier getGenClassifier(EClassifier cls) {
        GenPackage genPackage = GenModelAccess.getGenPackage(cls.getEPackage());
        for (GenClassifier genCls : genPackage.getGenClassifiers()) {
            if (!cls.getName().equals(genCls.getEcoreClassifier().getName())) continue;
            return genCls;
        }
        throw new RuntimeException("No GenClassifier named '" + cls.getName() + "' found in GenModel " + genPackage.eResource().getURI());
    }

    public static GenDataType getGenDataType(EDataType dt) {
        return (GenDataType)GenModelAccess.getGenClassifier((EClassifier)dt);
    }

    public static GenEnum getGenEnum(EEnum en) {
        return (GenEnum)GenModelAccess.getGenClassifier((EClassifier)en);
    }

    public static GenFeature getGenFeature(EStructuralFeature feature) {
        GenClass genCls = (GenClass)GenModelAccess.getGenClassifier((EClassifier)feature.getEContainingClass());
        for (GenFeature genFeat : genCls.getGenFeatures()) {
            if (!feature.getName().equals(genFeat.getEcoreFeature().getName())) continue;
            return genFeat;
        }
        throw new RuntimeException("No GenClassifier named '" + feature.getName() + "' found in GenClass '" + genCls + "' from GenModel" + genCls.eResource().getURI());
    }

    public static String getGenIntLiteral(EClass clazz, EStructuralFeature feature) {
        GenFeature genFeature = GenModelAccess.getGenFeature(feature);
        GenClass genClass = GenModelAccess.getGenClass(clazz);
        return String.valueOf(genClass.getGenPackage().getPackageInterfaceName()) + "." + genClass.getFeatureID(genFeature);
    }

    public static String getGenIntLiteral(EClassifier classifier) {
        GenClassifier genClassifier = GenModelAccess.getGenClassifier(classifier);
        return String.valueOf(genClassifier.getGenPackage().getPackageInterfaceName()) + "." + genClassifier.getClassifierID();
    }

    public static GenPackage getGenPackage(EPackage pkg) {
        URI genModelURI = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(pkg.getNsURI());
        if (genModelURI == null) {
            throw new RuntimeException("No GenModel for EPackage '" + pkg.getNsURI() + "' is registered.");
        }
        ResourceSet resourceSet = pkg.eResource().getResourceSet();
        if (resourceSet == null) {
            throw new RuntimeException("There is no ResourceSet for EPackage '" + pkg.getNsURI() + "'. " + "Please make sure the EPackage has been loaded from a .ecore file " + "and not from the generated Java file.");
        }
        Resource genModelResource = resourceSet.getResource(genModelURI, true);
        if (genModelResource == null) {
            throw new RuntimeException("Error loading GenModel " + genModelURI);
        }
        for (EObject model : genModelResource.getContents()) {
            if (!(model instanceof GenModel)) continue;
            for (GenPackage genPkg : ((GenModel)model).getGenPackages()) {
                if (!pkg.getNsURI().equals(genPkg.getEcorePackage().getNsURI())) continue;
                return genPkg;
            }
        }
        throw new RuntimeException("No GenPackage for NsURI " + pkg.getNsURI() + " found in " + genModelURI);
    }

    public static String getGenTypeLiteral(EClassifier classifier) {
        GenClassifier genClassifier = GenModelAccess.getGenClassifier(classifier);
        String pkg = genClassifier.getGenPackage().getPackageInterfaceName();
        String id = genClassifier.getClassifierID();
        return String.valueOf(pkg) + ".Literals." + id;
    }

    public static String getGenTypeLiteral(EPackage pkg) {
        return String.valueOf(GenModelAccess.getGenPackage(pkg).getPackageInterfaceName()) + ".eINSTANCE";
    }

    public static String getGenTypeLiteral(EStructuralFeature feature) {
        GenFeature genFeature = GenModelAccess.getGenFeature(feature);
        String pkg = genFeature.getGenPackage().getPackageInterfaceName();
        String id = genFeature.getGenClass().getFeatureID(genFeature);
        return String.valueOf(pkg) + ".Literals." + id;
    }
}

