/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.serializer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticSequencerUtil {
    @Inject
    protected IGrammarConstraintProvider gcp;

    public Map<IGrammarConstraintProvider.IConstraint, List<EObject>> getGrammarConstraints(Grammar grammar, EClass clazz) {
        HashMap result = Maps.newHashMap();
        for (IGrammarConstraintProvider.IConstraintContext ctx : this.gcp.getConstraints(grammar)) {
            for (IGrammarConstraintProvider.IConstraint c : ctx.getConstraints()) {
                if (c.getType() != clazz) continue;
                List contexts = (List)result.get(c);
                if (contexts == null) {
                    contexts = Lists.newArrayList();
                    result.put(c, contexts);
                }
                contexts.add(ctx.getContext());
            }
        }
        return result;
    }

    public Collection<EObject> getGrammarContexts(Grammar grammar, EClass clazz) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (IGrammarConstraintProvider.IConstraintContext ctx : this.gcp.getConstraints(grammar)) {
            for (IGrammarConstraintProvider.IConstraint c : ctx.getConstraints()) {
                if (c.getType() != clazz) continue;
                result.add(ctx.getContext());
            }
        }
        return result;
    }

    public Collection<EObject> getGrammarContexts(Grammar grammar) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (IGrammarConstraintProvider.IConstraintContext ctx : this.gcp.getConstraints(grammar)) {
            result.add(ctx.getContext());
        }
        return result;
    }

    public List<IGrammarConstraintProvider.IConstraintContext> getGrammarConstraintContexts(Grammar grammar) {
        return this.gcp.getConstraints(grammar);
    }

    public Collection<IGrammarConstraintProvider.IConstraint> getGrammarConstraints(Grammar grammar) {
        TreeSet result = Sets.newTreeSet();
        for (IGrammarConstraintProvider.IConstraintContext ctx : this.gcp.getConstraints(grammar)) {
            result.addAll(ctx.getConstraints());
        }
        return result;
    }

    public boolean canGenerate(IGrammarConstraintProvider.IConstraint constraint) {
        if (constraint.getAssignments().length != constraint.getFeatures().length) {
            return false;
        }
        IGrammarConstraintProvider.IConstraintElement body = constraint.getBody();
        if (body == null) {
            return false;
        }
        if (body.getFeatureInfo() != null && !body.isOptional() && !body.isMany()) {
            return true;
        }
        if (body.getType() == IGrammarConstraintProvider.ConstraintElementType.GROUP) {
            for (IGrammarConstraintProvider.IConstraintElement child : body.getChildren()) {
                if (child.getFeatureInfo() != null && !child.isOptional() && !child.isMany()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toAcceptMethod(IGrammarConstraintProvider.ConstraintElementType type) {
        switch (type) {
            case ASSIGNED_ACTION_CALL: {
                return "acceptAssignedAction";
            }
            case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: {
                return "acceptAssignedCrossRefDatatype";
            }
            case ASSIGNED_CROSSREF_ENUM_RULE_CALL: {
                return "acceptAssignedCrossRefEnum";
            }
            case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: {
                return "acceptAssignedCrossRefTerminal";
            }
            case ASSIGNED_DATATYPE_RULE_CALL: {
                return "acceptAssignedDatatype";
            }
            case ASSIGNED_ENUM_RULE_CALL: {
                return "acceptAssignedEnum";
            }
            case ASSIGNED_KEYWORD: {
                return "acceptAssignedKeyword";
            }
            case ASSIGNED_BOOLEAN_KEYWORD: {
                return "acceptAssignedKeyword";
            }
            case ASSIGNED_PARSER_RULE_CALL: {
                return "acceptAssignedParserRuleCall";
            }
            case ASSIGNED_TERMINAL_RULE_CALL: {
                return "acceptAssignedTerminal";
            }
        }
        return "<error, unknown type +'" + type + "'>";
    }

    public String toNodeType(IGrammarConstraintProvider.ConstraintElementType type) {
        switch (type) {
            case ASSIGNED_ACTION_CALL: 
            case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: 
            case ASSIGNED_CROSSREF_ENUM_RULE_CALL: 
            case ASSIGNED_DATATYPE_RULE_CALL: 
            case ASSIGNED_ENUM_RULE_CALL: 
            case ASSIGNED_PARSER_RULE_CALL: {
                return ICompositeNode.class.getSimpleName();
            }
            case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: 
            case ASSIGNED_KEYWORD: 
            case ASSIGNED_BOOLEAN_KEYWORD: 
            case ASSIGNED_TERMINAL_RULE_CALL: {
                return ILeafNode.class.getSimpleName();
            }
        }
        return "<error, unknown type +'" + type + "'>";
    }
}

