/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.serializer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.internal.Join;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.grammarAccess.GrammarAccess;
import org.eclipse.xtext.generator.grammarAccess.GrammarAccessUtil;
import org.eclipse.xtext.generator.serializer.JavaFile;
import org.eclipse.xtext.serializer.analysis.IContextProvider;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.analysis.NfaToGrammar;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntacticSequencerUtil {
    @Inject
    protected IContextProvider contextProvider;
    @Inject
    protected ISyntacticSequencerPDAProvider pdaProvider;
    @Inject
    protected Grammar grammar;
    protected List<Triple<String, NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>, List<ISyntacticSequencerPDAProvider.ISynTransition>>> ambiguousTransitions;
    @Inject
    protected GrammarAccess grammarAccess;

    protected List<ISyntacticSequencerPDAProvider.ISynAbsorberState> getAllPDAs() {
        ArrayList result = Lists.newArrayList();
        for (EObject context : this.contextProvider.getAllContexts(this.grammar)) {
            for (EClass type : this.contextProvider.getTypesForContext(context)) {
                result.add(this.pdaProvider.getPDA(context, type));
            }
        }
        return result;
    }

    protected void collectAllAmbiguousTransitions(ISyntacticSequencerPDAProvider.ISynFollowerOwner state, Set<ISyntacticSequencerPDAProvider.ISynTransition> result, Set<Object> visited) {
        if (!visited.add(state)) {
            return;
        }
        if (state instanceof ISyntacticSequencerPDAProvider.ISynTransition && ((ISyntacticSequencerPDAProvider.ISynTransition)state).isSyntacticallyAmbiguous()) {
            result.add((ISyntacticSequencerPDAProvider.ISynTransition)state);
        }
        if (state instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
            for (ISyntacticSequencerPDAProvider.ISynTransition trans : ((ISyntacticSequencerPDAProvider.ISynAbsorberState)state).getOutTransitions()) {
                this.collectAllAmbiguousTransitions((ISyntacticSequencerPDAProvider.ISynFollowerOwner)trans, result, visited);
            }
        } else {
            for (ISyntacticSequencerPDAProvider.ISynState follower : state.getFollowers()) {
                this.collectAllAmbiguousTransitions((ISyntacticSequencerPDAProvider.ISynFollowerOwner)follower, result, visited);
            }
        }
    }

    protected Set<ISyntacticSequencerPDAProvider.ISynTransition> getAllAmbiguousTransitions() {
        HashSet result = Sets.newHashSet();
        for (ISyntacticSequencerPDAProvider.ISynAbsorberState start : this.getAllPDAs()) {
            this.collectAllAmbiguousTransitions((ISyntacticSequencerPDAProvider.ISynFollowerOwner)start, result, Sets.newHashSet());
        }
        return result;
    }

    public List<Triple<String, NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>, List<ISyntacticSequencerPDAProvider.ISynTransition>>> getAllAmbiguousTransitionsBySyntax() {
        if (this.ambiguousTransitions != null) {
            return this.ambiguousTransitions;
        }
        HashMap result = Maps.newHashMap();
        for (ISyntacticSequencerPDAProvider.ISynTransition iSynTransition : this.getAllAmbiguousTransitions()) {
            NfaToGrammar.AbstractElementAlias syntax = iSynTransition.getAmbiguousSyntax();
            List list = (List)result.get(syntax);
            if (list == null) {
                list = Lists.newArrayList();
                result.put(syntax, list);
            }
            list.add(iSynTransition);
        }
        this.ambiguousTransitions = Lists.newArrayList();
        for (Map.Entry entry : result.entrySet()) {
            this.ambiguousTransitions.add((Triple<String, NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>, List<ISyntacticSequencerPDAProvider.ISynTransition>>)Tuples.create((Object)this.elementAliasToIdentifyer((NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>)((NfaToGrammar.AbstractElementAlias)entry.getKey())), (Object)((NfaToGrammar.AbstractElementAlias)entry.getKey()), (Object)((List)entry.getValue())));
        }
        Collections.sort(this.ambiguousTransitions, new Comparator<Triple<String, NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>, List<ISyntacticSequencerPDAProvider.ISynTransition>>>(){

            @Override
            public int compare(Triple<String, NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>, List<ISyntacticSequencerPDAProvider.ISynTransition>> o1, Triple<String, NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>, List<ISyntacticSequencerPDAProvider.ISynTransition>> o2) {
                return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
            }
        });
        return this.ambiguousTransitions;
    }

    protected String elementAliasToIdentifyer(NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState> alias, Set<String> rules, boolean isNested) {
        String card = null;
        if (alias.isMany() && alias.isOptional()) {
            card = "a";
        } else if (alias.isMany()) {
            card = "p";
        } else if (alias.isOptional()) {
            card = "q";
        }
        if (alias instanceof NfaToGrammar.ElementAlias) {
            NfaToGrammar.ElementAlias ele = (NfaToGrammar.ElementAlias)alias;
            rules.add(GrammarUtil.containingRule((EObject)((ISyntacticSequencerPDAProvider.ISynState)ele.getElement()).getGrammarElement()).getName());
            card = card == null ? "" : "_" + card;
            return String.valueOf(GrammarAccessUtil.getUniqueElementName(((ISyntacticSequencerPDAProvider.ISynState)ele.getElement()).getGrammarElement())) + card;
        }
        if (alias instanceof NfaToGrammar.GroupAlias) {
            ArrayList children = Lists.newArrayList();
            for (NfaToGrammar.AbstractElementAlias child : ((NfaToGrammar.GroupAlias)alias).getChildren()) {
                children.add(this.elementAliasToIdentifyer((NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>)child, rules, true));
            }
            String body = Join.join((String)"_", (Iterable)children);
            if (isNested || card != null) {
                card = card == null ? "" : card;
                return "__" + body + "__" + card;
            }
            return body;
        }
        if (alias instanceof NfaToGrammar.ALternativeAlias) {
            ArrayList children = Lists.newArrayList();
            for (NfaToGrammar.AbstractElementAlias child : ((NfaToGrammar.ALternativeAlias)alias).getChildren()) {
                children.add(this.elementAliasToIdentifyer((NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>)child, rules, true));
            }
            Collections.sort(children);
            String body = Join.join((String)"_or_", (Iterable)children);
            if (isNested || card != null) {
                card = card == null ? "" : card;
                return "__" + body + "__" + card;
            }
            return body;
        }
        throw new RuntimeException("unknown element");
    }

    public String elementAliasToConstructor(NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState> alias, JavaFile file) {
        String many = String.valueOf(alias.isMany());
        String optional = String.valueOf(alias.isOptional());
        String absEle = file.imported(AbstractElement.class);
        if (alias instanceof NfaToGrammar.ElementAlias) {
            NfaToGrammar.ElementAlias ele = (NfaToGrammar.ElementAlias)alias;
            String eleAlias = file.imported(NfaToGrammar.ElementAlias.class);
            String eleAcc = "grammarAccess." + this.grammarAccess.gaAccessor((EObject)((ISyntacticSequencerPDAProvider.ISynState)ele.getElement()).getGrammarElement());
            return "new " + eleAlias + "<" + absEle + ">(" + optional + ", " + many + ", " + eleAcc + ")";
        }
        if (alias instanceof NfaToGrammar.GroupAlias) {
            ArrayList children = Lists.newArrayList();
            for (NfaToGrammar.AbstractElementAlias child : ((NfaToGrammar.GroupAlias)alias).getChildren()) {
                children.add(this.elementAliasToConstructor((NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>)child, file));
            }
            String body = Join.join((String)", ", (Iterable)children);
            String grpAlias = file.imported(NfaToGrammar.GroupAlias.class);
            return "new " + grpAlias + "<" + absEle + ">(" + optional + ", " + many + ", " + body + ")";
        }
        if (alias instanceof NfaToGrammar.ALternativeAlias) {
            ArrayList children = Lists.newArrayList();
            for (NfaToGrammar.AbstractElementAlias child : ((NfaToGrammar.ALternativeAlias)alias).getChildren()) {
                children.add(this.elementAliasToConstructor((NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState>)child, file));
            }
            Collections.sort(children);
            String body = Join.join((String)", ", (Iterable)children);
            String altAlias = file.imported(NfaToGrammar.ALternativeAlias.class);
            return "new " + altAlias + "<" + absEle + ">(" + optional + ", " + many + ", " + body + ")";
        }
        throw new RuntimeException("unknown element");
    }

    protected String elementAliasToIdentifyer(NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState> alias) {
        HashSet rulesSet = Sets.newHashSet();
        String body = this.elementAliasToIdentifyer(alias, rulesSet, false);
        ArrayList rulesList = Lists.newArrayList((Iterable)rulesSet);
        Collections.sort(rulesList);
        String rule = Join.join((String)"_", (Iterable)rulesList);
        return String.valueOf(rule) + "_" + body;
    }
}

