/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4;

import com.google.common.collect.Maps;
import com.google.inject.Injector;
import java.util.Map;
import org.eclipse.xtext.junit4.IInjectorProvider;
import org.eclipse.xtext.junit4.IRegistryConfigurator;
import org.eclipse.xtext.junit4.InjectWith;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextRunner
extends BlockJUnit4ClassRunner {
    private static Map<Class<?>, IInjectorProvider> injectorProviderClassCache = Maps.newHashMap();

    public XtextRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Object createTest() throws Exception {
        Injector injector;
        Object object = super.createTest();
        IInjectorProvider injectorProvider = this.getOrCreateInjectorProvider();
        if (injectorProvider != null && (injector = injectorProvider.getInjector()) != null) {
            injector.injectMembers(object);
        }
        return object;
    }

    protected Statement methodBlock(FrameworkMethod method) {
        final Statement methodBlock = super.methodBlock(method);
        if (this.getInjectorProvider() instanceof IRegistryConfigurator) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    IRegistryConfigurator registryConfigurator = (IRegistryConfigurator)((Object)XtextRunner.this.getInjectorProvider());
                    registryConfigurator.setupRegistry();
                    try {
                        methodBlock.evaluate();
                    }
                    finally {
                        registryConfigurator.restoreRegistry();
                    }
                }
            };
        }
        return methodBlock;
    }

    protected IInjectorProvider getOrCreateInjectorProvider() throws Exception {
        IInjectorProvider injectorProvider = this.getInjectorProvider();
        if (injectorProvider == null) {
            injectorProvider = this.createInjectorProvider();
            injectorProviderClassCache.put(this.getTestClass().getJavaClass(), injectorProvider);
        }
        return injectorProvider;
    }

    protected IInjectorProvider getInjectorProvider() {
        return injectorProviderClassCache.get(this.getTestClass().getJavaClass());
    }

    protected IInjectorProvider createInjectorProvider() throws Exception {
        IInjectorProvider injectorProvider = null;
        InjectWith injectWith = this.getTestClass().getJavaClass().getAnnotation(InjectWith.class);
        if (injectWith != null) {
            injectorProvider = injectWith.value().newInstance();
        }
        return injectorProvider;
    }
}

