/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.junit.serializer.AssertNodeModelAcceptor;
import org.eclipse.xtext.junit.util.ParseHelper;
import org.eclipse.xtext.junit.validation.ValidationTestHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.StringBufferSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.IHiddenTokenSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;
import org.eclipse.xtext.util.EmfFormatter;

public class SerializerTester {
    @Inject
    protected Provider<ISemanticSequencer> semanticSequencerProvider;
    @Inject
    protected Provider<ISyntacticSequencer> syntacticSequencerProvider;
    @Inject
    protected Provider<IHiddenTokenSequencer> hiddenTokenSequencerProvider;
    @Inject
    protected IGrammarAccess grammar;
    @Inject
    protected IFormatter formatter;
    @Inject
    protected ParseHelper<EObject> parseHelper;
    @Inject
    protected ValidationTestHelper validationHelper;
    @Inject
    protected ISerializer serializer;

    protected void removeNodeModel(EObject eObject) {
        TreeIterator iterator = EcoreUtil.getAllContents((Resource)eObject.eResource(), (boolean)false);
        block0: while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            Iterator adapters = object.eAdapters().iterator();
            while (adapters.hasNext()) {
                Adapter adapter = (Adapter)adapters.next();
                if (!(adapter instanceof ICompositeNode)) continue;
                adapters.remove();
                continue block0;
            }
        }
    }

    public void assertSerializeWithoutNodeModel(String semanticModel) throws Exception {
        EObject semanticObject = this.parseHelper.parse(semanticModel);
        this.validationHelper.assertNoErrors(semanticObject);
        this.assertSerializeWithoutNodeModel(semanticObject);
    }

    public void assertSerializeWithNodeModel(String semanticModel) throws Exception {
        EObject semanticObject = this.parseHelper.parse(semanticModel);
        this.validationHelper.assertNoErrors(semanticObject);
        this.assertSerializeWithNodeModel(semanticObject);
    }

    public void assertSerializeWithoutNodeModel(EObject semanticObject) throws Exception {
        this.removeNodeModel(semanticObject);
        String serialized = this.serializer.serialize(semanticObject);
        EObject parsed = this.parseHelper.parse(serialized);
        EcoreUtil.resolveAll((EObject)parsed);
        String expected = EmfFormatter.objToStr((Object)semanticObject, (EStructuralFeature[])new EStructuralFeature[0]);
        String actual = EmfFormatter.objToStr((Object)parsed, (EStructuralFeature[])new EStructuralFeature[0]);
        Assert.assertEquals((String)expected, (String)actual);
    }

    public void assertSerializeWithNodeModel(EObject semanticObject) {
        ISerializationDiagnostic.Acceptor errors = ISerializationDiagnostic.EXCEPTION_THROWING_ACCEPTOR;
        ISemanticSequencer semantic = (ISemanticSequencer)this.semanticSequencerProvider.get();
        ISyntacticSequencer syntactic = (ISyntacticSequencer)this.syntacticSequencerProvider.get();
        IHiddenTokenSequencer hidden = (IHiddenTokenSequencer)this.hiddenTokenSequencerProvider.get();
        StringBufferSequenceAcceptor result = new StringBufferSequenceAcceptor();
        semantic.init((ISemanticSequenceAcceptor)syntactic, errors);
        EObject context = (EObject)this.grammar.getGrammar().getRules().get(0);
        syntactic.init(context, semanticObject, (ISyntacticSequenceAcceptor)hidden, errors);
        hidden.init(context, semanticObject, (ISequenceAcceptor)new AssertNodeModelAcceptor((ISemanticSequenceAcceptor)result), errors);
        semantic.createSequence(context, semanticObject);
        XtextResource res = (XtextResource)semanticObject.eResource();
        Assert.assertEquals((String)res.getParseResult().getRootNode().getText(), (String)result.toString());
    }
}

