/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.inject.Inject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.ResourceForIEditorInputFactory;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;

public class JavaClassPathResourceForIEditorInputFactory
extends ResourceForIEditorInputFactory {
    @Inject
    private IStorage2UriMapper storageToUriMapper;

    protected Resource createResource(IStorage storage) throws CoreException {
        if (storage instanceof IJarEntryResource) {
            return this.createResourceFor((IJarEntryResource)storage);
        }
        return super.createResource(storage);
    }

    protected Resource createResourceFor(IJarEntryResource storage) {
        ResourceSet resourceSet = this.getResourceSet((IStorage)storage);
        URI uri = this.storageToUriMapper.getUri((IStorage)storage);
        this.configureResourceSet(resourceSet, uri);
        XtextResource resource = this.createResource(resourceSet, uri);
        resource.setValidationDisabled(true);
        return resource;
    }

    protected ResourceSet getResourceSet(IStorage storage) {
        IJavaProject project;
        IPackageFragmentRoot root;
        if (storage instanceof IJarEntryResource && (root = ((IJarEntryResource)storage).getPackageFragmentRoot()) != null && (project = root.getJavaProject()) != null) {
            return this.getResourceSetProvider().get(project.getProject());
        }
        return super.getResourceSet(storage);
    }
}

