/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IResourceForEditorInputFactory;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.quickfix.XtextResourceMarkerAnnotationModel;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class XtextDocumentProvider
extends FileDocumentProvider {
    @Inject
    private Provider<XtextDocument> documentProvider;
    @Inject
    private Provider<IDocumentPartitioner> documentPartitioner;
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private IssueResolutionProvider issueResolutionProvider;
    @Inject
    private IssueUtil issueUtil;
    @Inject
    private IResourceForEditorInputFactory resourceForEditorInputFactory;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private IEncodingProvider encodingProvider;
    private UnchangedElementListener listener;

    protected XtextDocument createEmptyDocument() {
        XtextDocument xtextDocument = (XtextDocument)this.documentProvider.get();
        return xtextDocument;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            IDocumentPartitioner partitioner = (IDocumentPartitioner)this.documentPartitioner.get();
            partitioner.connect(document);
            document.setDocumentPartitioner(partitioner);
        }
        return document;
    }

    public boolean isDeleted(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            IPath path = input.getFile().getLocation();
            if (path == null) {
                return !input.getFile().exists();
            }
            return !path.toFile().exists();
        }
        return super.isDeleted(element);
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        boolean result = super.setDocumentContent(document, editorInput, encoding);
        if (result) {
            XtextDocument xtextDocument = (XtextDocument)document;
            XtextResource xtextResource = (XtextResource)this.resourceForEditorInputFactory.createResource(editorInput);
            this.loadResource(xtextResource, xtextDocument.get(), encoding);
            xtextDocument.setInput(xtextResource);
        }
        return result;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info.fDocument instanceof XtextDocument) {
            XtextDocument document = (XtextDocument)info.fDocument;
            document.disposeInput();
        }
        super.disposeElementInfo(element, info);
    }

    protected void loadResource(XtextResource resource, String document, String encoding) throws CoreException {
        try {
            byte[] bytes = encoding != null ? document.getBytes(encoding) : document.getBytes();
            resource.load((InputStream)new ByteArrayInputStream(bytes), Collections.singletonMap(XtextResource.OPTION_ENCODING, encoding));
        }
        catch (IOException ex) {
            String message = ex.getMessage() != null ? ex.getMessage() : ex.toString();
            Status s = new Status(4, "org.eclipse.xtext.ui", 0, message, (Throwable)ex);
            throw new CoreException((IStatus)s);
        }
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        AbstractDocumentProvider.ElementInfo info = super.createElementInfo(element);
        XtextDocument doc = (XtextDocument)info.fDocument;
        AnnotationIssueProcessor annotationIssueProcessor = new AnnotationIssueProcessor(doc, info.fModel, this.issueResolutionProvider);
        ValidationJob job = new ValidationJob(this.resourceValidator, doc, annotationIssueProcessor, CheckMode.FAST_ONLY);
        doc.setValidationJob(job);
        return info;
    }

    protected void addUnchangedElementListeners(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info.fDocument != null) {
            if (this.listener != null) {
                info.fDocument.removeDocumentListener((IDocumentListener)this.listener);
            }
            this.listener = new UnchangedElementListener(info);
            info.fDocument.addDocumentListener((IDocumentListener)new UnchangedElementListener(info));
        }
    }

    protected void removeUnchangedElementListeners(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (this.listener != null) {
            info.fDocument.removeDocumentListener((IDocumentListener)this.listener);
            this.listener = null;
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return new XtextResourceMarkerAnnotationModel(input.getFile(), this.issueResolutionProvider, this.issueUtil);
        }
        return super.createAnnotationModel(element);
    }

    public void setResourceForEditorInputFactory(IResourceForEditorInputFactory resourceForEditorInputFactory) {
        this.resourceForEditorInputFactory = resourceForEditorInputFactory;
    }

    public IResourceForEditorInputFactory getResourceForEditorInputFactory() {
        return this.resourceForEditorInputFactory;
    }

    public String getEncoding(Object element) {
        String encoding = super.getEncoding(element);
        if (encoding == null && element instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)element).getStorage();
                URI uri = this.storage2UriMapper.getUri(storage);
                if (uri != null) {
                    encoding = this.encodingProvider.getEncoding(uri);
                } else if (storage instanceof IEncodedStorage) {
                    encoding = ((IEncodedStorage)storage).getCharset();
                }
            }
            catch (CoreException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
        return encoding;
    }

    public boolean isSynchronized(Object element) {
        FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(element);
        long modificationStamp = this.getModificationStamp(element);
        if (info.fModificationStamp != modificationStamp) {
            return false;
        }
        return super.isSynchronized(element);
    }

    public class UnchangedElementListener
    implements IDocumentListener {
        private final AbstractDocumentProvider.ElementInfo element;
        private long modificationStamp;

        public UnchangedElementListener(AbstractDocumentProvider.ElementInfo element) {
            this.element = element;
            this.modificationStamp = element.fDocument instanceof IDocumentExtension4 ? ((IDocumentExtension4)element.fDocument).getModificationStamp() : -1L;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (this.element.fCanBeSaved && this.modificationStamp == event.getModificationStamp()) {
                this.element.fCanBeSaved = false;
                XtextDocumentProvider.this.fireElementDirtyStateChanged(this.element.fElement, this.element.fCanBeSaved);
            } else if (!this.element.fCanBeSaved) {
                this.element.fCanBeSaved = true;
                XtextDocumentProvider.this.fireElementDirtyStateChanged(this.element.fElement, this.element.fCanBeSaved);
            }
        }
    }
}

