/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.validation;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;

public class MarkerCreator {
    public void createMarker(Issue issue, IResource resource, String markerType) throws CoreException {
        IMarker marker = resource.createMarker(markerType);
        String lineNR = "";
        if (issue.getLineNumber() != null) {
            lineNR = "line: " + issue.getLineNumber() + " ";
        }
        marker.setAttribute("location", (Object)(String.valueOf(lineNR) + resource.getFullPath().toString()));
        marker.setAttribute("CODE_KEY", (Object)issue.getCode());
        marker.setAttribute("severity", this.getSeverity(issue));
        marker.setAttribute("charStart", (Object)issue.getOffset());
        if (issue.getOffset() != null && issue.getLength() != null) {
            marker.setAttribute("charEnd", issue.getOffset() + issue.getLength());
        }
        marker.setAttribute("lineNumber", (Object)issue.getLineNumber());
        marker.setAttribute("message", (Object)issue.getMessage());
        if (issue.getUriToProblem() != null) {
            marker.setAttribute("URI_KEY", (Object)issue.getUriToProblem().toString());
        }
        if (issue.getData() != null && issue.getData().length > 0) {
            marker.setAttribute("DATA_KEY", (Object)Strings.pack((String[])issue.getData()));
        }
    }

    private Object getSeverity(Issue issue) {
        switch (issue.getSeverity()) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }
}

