/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.util.Strings;

public class ProjectUtil {
    @Inject
    private IWorkspace workspace;

    public IProject getProject(URI targetElementURI) {
        if (!targetElementURI.isPlatformResource()) {
            throw new IllegalArgumentException("Refactored element URI must be a platform resource URI: " + Strings.notNull((Object)targetElementURI));
        }
        String projectName = targetElementURI.segment(1);
        IProject project = this.workspace.getRoot().getProject(projectName);
        if (project == null) {
            throw new IllegalArgumentException("Cannot find containing project for " + Strings.notNull((Object)targetElementURI));
        }
        return project;
    }
}

