/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.SimpleLocalResourceAccess;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringReferenceQueryDataFactory;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringStatusException;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;

public class ReferenceUpdaterDispatcher {
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private RefactoringReferenceQueryDataFactory queryDataFactory;

    public void createReferenceUpdates(ElementRenameArguments elementRenameArguments, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating references", (int)100);
        ReferenceDescriptionAcceptor referenceDescriptionAcceptor = this.createFindReferenceAcceptor(updateAcceptor);
        IReferenceFinder.IQueryData referenceQueryData = this.queryDataFactory.create(elementRenameArguments);
        this.referenceFinder.findAllReferences(referenceQueryData, new SimpleLocalResourceAccess(resourceSet), referenceDescriptionAcceptor, (IProgressMonitor)progress.newChild(2));
        Multimap<IReferenceUpdater, IReferenceDescription> updater2descriptions = referenceDescriptionAcceptor.getReferenceUpdater2ReferenceDescriptions();
        SubMonitor updaterProgress = progress.newChild(98).setWorkRemaining(updater2descriptions.keySet().size());
        for (IReferenceUpdater referenceUpdater : updater2descriptions.keySet()) {
            if (updaterProgress.isCanceled()) {
                return;
            }
            referenceUpdater.createReferenceUpdates(elementRenameArguments, updater2descriptions.get((Object)referenceUpdater), updateAcceptor, (IProgressMonitor)updaterProgress.newChild(1));
        }
    }

    protected ReferenceDescriptionAcceptor createFindReferenceAcceptor(IRefactoringUpdateAcceptor updateAcceptor) {
        return new ReferenceDescriptionAcceptor(this.resourceServiceProviderRegistry, updateAcceptor.getRefactoringStatus());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReferenceDescriptionAcceptor
    implements IAcceptor<IReferenceDescription> {
        private Map<IResourceServiceProvider, IReferenceUpdater> provider2updater = Maps.newHashMap();
        private Multimap<IReferenceUpdater, IReferenceDescription> updater2refs = HashMultimap.create();
        private RefactoringStatus status;
        private final IResourceServiceProvider.Registry resourceServiceProviderRegistry;

        public ReferenceDescriptionAcceptor(IResourceServiceProvider.Registry resourceServiceProviderRegistry, RefactoringStatus status) {
            this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
            this.status = status;
        }

        public void accept(IReferenceDescription referenceDescription) {
            if (referenceDescription.getSourceEObjectUri() == null || referenceDescription.getTargetEObjectUri() == null || referenceDescription.getEReference() == null) {
                throw new RefactoringStatusException("Xtext index is corrupt. It is suggested to perform a workspace refresh and a clean build.", true);
            }
            URI sourceResourceURI = referenceDescription.getSourceEObjectUri().trimFragment();
            if (!sourceResourceURI.isPlatformResource()) {
                throw new RefactoringStatusException("Referring element is not in workspace: " + Strings.notNull((Object)sourceResourceURI), false);
            }
            IReferenceUpdater referenceUpdater = this.getReferenceUpdater(sourceResourceURI);
            if (referenceUpdater == null) {
                this.status.addError("Cannot find a reference updater for " + Strings.notNull((Object)sourceResourceURI) + " which contains references to renamed elements");
            } else {
                this.updater2refs.put((Object)referenceUpdater, (Object)referenceDescription);
            }
        }

        protected IReferenceUpdater getReferenceUpdater(URI sourceResourceURI) {
            IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(sourceResourceURI);
            IReferenceUpdater referenceUpdater = this.provider2updater.get(resourceServiceProvider);
            if (referenceUpdater == null && (referenceUpdater = (IReferenceUpdater)resourceServiceProvider.get(IReferenceUpdater.class)) != null) {
                this.provider2updater.put(resourceServiceProvider, referenceUpdater);
            }
            return referenceUpdater;
        }

        public Multimap<IReferenceUpdater, IReferenceDescription> getReferenceUpdater2ReferenceDescriptions() {
            return this.updater2refs;
        }
    }
}

