/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.TypeMatchFilters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.QualifiedNameValueConverter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.RepeatedContentAssistProcessor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.conversion.StaticQualifierValueConverter;
import org.eclipse.xtext.xbase.scoping.XbaseScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xbase.ui.contentassist.AbstractXbaseProposalProvider;
import org.eclipse.xtext.xbase.ui.contentassist.MultiNameDescription;
import org.eclipse.xtext.xbase.ui.contentassist.StaticQualifierPrefixMatcher;
import org.eclipse.xtext.xbase.ui.contentassist.XbaseReferenceProposalCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseProposalProvider
extends AbstractXbaseProposalProvider
implements RepeatedContentAssistProcessor.ModeAware {
    private static final Logger log = Logger.getLogger(XbaseProposalProvider.class);
    @Inject
    private ITypesProposalProvider typeProposalProvider;
    @Inject
    private ValidFeatureDescription featureDescriptionPredicate;
    @Inject
    private XbaseGrammarAccess grammarAccess;
    @Inject
    private QualifiedNameValueConverter qualifiedNameValueConverter;
    @Inject
    private StaticQualifierValueConverter staticQualifierValueConverter;
    @Inject
    private StaticQualifierPrefixMatcher staticQualifierPrefixMatcher;

    public String getNextCategory() {
        return this.getXbaseCrossReferenceProposalCreator().getNextCategory();
    }

    public void nextMode() {
        this.getXbaseCrossReferenceProposalCreator().nextMode();
    }

    public void reset() {
        this.getXbaseCrossReferenceProposalCreator().reset();
    }

    public boolean isLastMode() {
        return this.getXbaseCrossReferenceProposalCreator().isLastMode();
    }

    public XbaseReferenceProposalCreator getXbaseCrossReferenceProposalCreator() {
        return (XbaseReferenceProposalCreator)super.getCrossReferenceProposalCreator();
    }

    @Override
    public void completeJvmParameterizedTypeReference_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (this.getXbaseCrossReferenceProposalCreator().isShowTypeProposals() || this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals()) {
            this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, acceptor);
        }
    }

    @Override
    public void completeXRelationalExpression_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, XbasePackage.Literals.XINSTANCE_OF_EXPRESSION__TYPE, acceptor);
    }

    protected void completeJavaTypes(ContentAssistContext context, EReference reference, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, reference, (IValueConverter<String>)this.qualifiedNameValueConverter, TypeMatchFilters.all(), acceptor);
    }

    protected void completeJavaTypes(ContentAssistContext context, EReference reference, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, reference, (IValueConverter<String>)this.qualifiedNameValueConverter, filter, acceptor);
    }

    protected void completeJavaTypes(ContentAssistContext context, EReference reference, IValueConverter<String> valueConverter, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, reference, false, valueConverter, filter, acceptor);
    }

    protected void completeJavaTypes(ContentAssistContext context, EReference reference, boolean forced, IValueConverter<String> valueConverter, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
        String prefix = context.getPrefix();
        if (prefix.length() > 0) {
            if (Character.isJavaIdentifierStart(context.getPrefix().charAt(0))) {
                if (!(forced || !this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals() || prefix.contains(".") || prefix.contains("::") || Character.isUpperCase(prefix.charAt(0)))) {
                    return;
                }
                this.typeProposalProvider.createTypeProposals((ICompletionProposalFactory)this, context, reference, filter, valueConverter, acceptor);
            }
        } else if (forced || !this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals()) {
            this.typeProposalProvider.createTypeProposals((ICompletionProposalFactory)this, context, reference, filter, valueConverter, acceptor);
        }
    }

    @Override
    public void completeXTypeLiteral_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, XbasePackage.Literals.XTYPE_LITERAL__TYPE, true, (IValueConverter<String>)this.qualifiedNameValueConverter, TypeMatchFilters.all(), acceptor);
    }

    @Override
    public void completeXFeatureCall_DeclaringType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (this.getXbaseCrossReferenceProposalCreator().isShowTypeProposals() || this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals()) {
            ContentAssistContext modifiedContext = context.copy().setMatcher((PrefixMatcher)this.staticQualifierPrefixMatcher).toContext();
            this.completeJavaTypes(modifiedContext, XbasePackage.Literals.XFEATURE_CALL__DECLARING_TYPE, (IValueConverter<String>)this.staticQualifierValueConverter, TypeMatchFilters.all(), acceptor);
        }
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (this.isKeywordWorthyToPropose(keyword)) {
            super.completeKeyword(keyword, contentAssistContext, acceptor);
        }
    }

    protected boolean isKeywordWorthyToPropose(Keyword keyword) {
        return keyword.getValue().length() > 1 && Character.isLetter(keyword.getValue().charAt(0));
    }

    protected boolean doCreateIntProposals() {
        return false;
    }

    protected boolean doCreateIdProposals() {
        return false;
    }

    protected boolean doCreateStringProposals() {
        return false;
    }

    public XbaseScopeProvider getScopeProvider() {
        return (XbaseScopeProvider)super.getScopeProvider();
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference(crossReference, contentAssistContext, acceptor, this.getFeatureDescriptionPredicate(contentAssistContext));
    }

    @Override
    public void completeXAssignment_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (assignment == this.grammarAccess.getXAssignmentAccess().getFeatureAssignment_1_1_0_0_1()) {
            super.completeXAssignment_Feature(model, assignment, context, acceptor);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void completeXFeatureCall_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block9: {
            block8: {
                if (!(model instanceof XBlockExpression) || (block = (XBlockExpression)model).getExpressions().isEmpty()) break block9;
                previousModel = context.getPreviousModel();
                if (context.getPreviousModel() != model) ** GOTO lbl12
                for (XExpression expression : block.getExpressions()) {
                    node = NodeModelUtils.findActualNodeFor((EObject)expression);
                    if (node.getOffset() < context.getOffset()) {
                        previousModel = expression;
                        continue;
                    }
                    break block8;
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    previousModel = previousModel.eContainer();
lbl12:
                    // 2 sources

                    ** while (previousModel.eContainer() != block)
                }
            }
            idx = block.getExpressions().indexOf((Object)previousModel);
            this.createLocalVariableAndImplicitProposals((EObject)block, idx + 1, context, acceptor);
            return;
        }
        if (model instanceof XForLoopExpression) {
            node = NodeModelUtils.getNode((EObject)model);
            eachExpression = false;
            for (INode leaf : node.getLeafNodes()) {
                if (leaf.getOffset() >= context.getOffset()) break;
                if (leaf.getGrammarElement() != this.grammarAccess.getXForLoopExpressionAccess().getRightParenthesisKeyword_6()) continue;
                eachExpression = true;
                break;
            }
            if (!eachExpression) {
                this.createLocalVariableAndImplicitProposals(model, false, -1, context, acceptor);
                return;
            }
        }
        if (model instanceof XFeatureCall && ((XFeatureCall)model).getDeclaringType() != null) {
            super.completeXFeatureCall_Feature(model, assignment, context, acceptor);
        }
        if (model == null || model instanceof XExpression || model instanceof XCatchClause) {
            this.createLocalVariableAndImplicitProposals(model, context, acceptor);
        }
    }

    @Override
    public void completeXBlockExpression_Expressions(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeXBlockExpression_Expressions(model, assignment, context, acceptor);
        if (!(model instanceof XBlockExpression)) {
            EObject local = model;
            while (!(local.eContainer() instanceof XBlockExpression)) {
                if ((local = local.eContainer()) != null) continue;
                return;
            }
            XBlockExpression block = (XBlockExpression)local.eContainer();
            int idx = block.getExpressions().indexOf((Object)local);
            this.createLocalVariableAndImplicitProposals((EObject)block, idx + 1, context, acceptor);
        }
    }

    @Override
    public void completeXCasePart_Then(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeXCasePart_Then(model, assignment, context, acceptor);
        if (model instanceof XCasePart) {
            this.createLocalVariableAndImplicitProposals(model, -1, context, acceptor);
        }
    }

    @Override
    public void completeXCasePart_Case(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeXCasePart_Case(model, assignment, context, acceptor);
        if (model instanceof XCasePart) {
            this.createLocalVariableAndImplicitProposals(model, -1, context, acceptor);
        }
    }

    protected void lookupCrossReference(CrossReference crossReference, EReference reference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        int length;
        ICompositeNode node;
        int offset;
        if (reference == XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR) {
            this.completeJavaTypes(contentAssistContext, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter<String>)this.qualifiedNameValueConverter, TypeMatchFilters.canInstantiate(), acceptor);
            return;
        }
        if (!this.getScopeProvider().isFeatureCallScope(reference)) {
            super.lookupCrossReference(crossReference, reference, contentAssistContext, acceptor, filter);
            return;
        }
        EObject model = contentAssistContext.getCurrentModel();
        if (model == contentAssistContext.getPreviousModel() || !(contentAssistContext.getPreviousModel() instanceof XExpression)) {
            INode node2;
            XAbstractFeatureCall memberFeatureCall;
            List nodesForFeature;
            if (model instanceof XBinaryOperation) {
                XBinaryOperation binaryOperation = (XBinaryOperation)model;
                if (this.doNotProposeFeatureOfBinaryOperation(contentAssistContext, binaryOperation)) {
                    return;
                }
            } else if (model instanceof XAbstractFeatureCall && !(nodesForFeature = NodeModelUtils.findNodesForFeature((EObject)(memberFeatureCall = (XAbstractFeatureCall)model), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE)).isEmpty() && (node2 = (INode)nodesForFeature.get(0)).getOffset() + node2.getLength() <= contentAssistContext.getOffset() - contentAssistContext.getPrefix().length() && !Iterables.isEmpty((Iterable)node2.getLeafNodes())) {
                this.createReceiverProposals((XExpression)memberFeatureCall, crossReference, reference, contentAssistContext, acceptor, filter);
                return;
            }
            super.lookupCrossReference(crossReference, reference, contentAssistContext, acceptor, filter);
            return;
        }
        if (model instanceof XBinaryOperation) {
            XBinaryOperation binaryOperation = (XBinaryOperation)model;
            if (contentAssistContext.getPreviousModel() == binaryOperation.getRightOperand()) {
                this.createReceiverProposals(binaryOperation.getRightOperand(), crossReference, reference, contentAssistContext, acceptor, filter);
                return;
            }
        }
        if (model instanceof XAbstractFeatureCall && (offset = (node = NodeModelUtils.findActualNodeFor((EObject)model)).getOffset()) + (length = node.getLength()) >= contentAssistContext.getOffset()) {
            super.lookupCrossReference(crossReference, reference, contentAssistContext, acceptor, filter);
            return;
        }
        if (model != null && !(model instanceof XExpression)) {
            super.lookupCrossReference(crossReference, reference, contentAssistContext, acceptor, filter);
            return;
        }
        if (contentAssistContext.getPreviousModel() instanceof XExpression) {
            this.createReceiverProposals((XExpression)contentAssistContext.getPreviousModel(), crossReference, reference, contentAssistContext, acceptor, filter);
        } else {
            super.lookupCrossReference(crossReference, reference, contentAssistContext, acceptor, filter);
        }
    }

    protected void createLocalVariableAndImplicitProposals(EObject context, int idx, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(context, true, idx, contentAssistContext, acceptor);
    }

    protected void createLocalVariableAndImplicitProposals(EObject context, boolean includeCurrentObject, int idx, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        Function<IEObjectDescription, ICompletionProposal> proposalFactory = this.getProposalFactory(this.grammarAccess.getIdOrSuperRule().getName(), contentAssistContext);
        IScope scope = this.getScopeProvider().createSimpleFeatureCallScope(context, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, (Resource)contentAssistContext.getResource(), includeCurrentObject, idx);
        this.getCrossReferenceProposalCreator().lookupCrossReference(scope, context, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, acceptor, this.getFeatureDescriptionPredicate(contentAssistContext), proposalFactory);
    }

    protected void createLocalVariableAndImplicitProposals(EObject context, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(context, -1, contentAssistContext, acceptor);
    }

    protected void createReceiverProposals(XExpression receiver, CrossReference crossReference, EReference reference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        String ruleName = null;
        if (crossReference.getTerminal() instanceof RuleCall) {
            ruleName = ((RuleCall)crossReference.getTerminal()).getRule().getName();
        }
        Function<IEObjectDescription, ICompletionProposal> proposalFactory = this.getProposalFactory(ruleName, contentAssistContext);
        IScope scope = this.getScopeProvider().createFeatureCallScopeForReceiver(receiver, receiver, reference);
        this.getCrossReferenceProposalCreator().lookupCrossReference(scope, (EObject)receiver, reference, acceptor, filter, proposalFactory);
    }

    protected boolean doNotProposeFeatureOfBinaryOperation(ContentAssistContext contentAssistContext, XBinaryOperation binaryOperation) {
        INode node;
        List nodesForFeature = NodeModelUtils.findNodesForFeature((EObject)binaryOperation, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
        if (!nodesForFeature.isEmpty() && (node = (INode)nodesForFeature.get(0)).getOffset() < contentAssistContext.getOffset() - contentAssistContext.getPrefix().length()) {
            XExpression rightOperand = binaryOperation.getRightOperand();
            if (rightOperand == null) {
                return true;
            }
            ICompositeNode rightOperandNode = NodeModelUtils.findActualNodeFor((EObject)rightOperand);
            if (rightOperandNode.getOffset() >= contentAssistContext.getOffset()) {
                return true;
            }
            if (this.isParentOf((INode)rightOperandNode, contentAssistContext.getLastCompleteNode())) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isParentOf(INode node, INode child) {
        if (node != null) ** GOTO lbl4
        return false;
lbl-1000:
        // 1 sources

        {
            child = child.getParent();
lbl4:
            // 2 sources

            ** while (child != null && node.equals((Object)child))
        }
lbl5:
        // 1 sources

        return node.equals(child);
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(final String ruleName, final ContentAssistContext contentAssistContext) {
        return new AbstractJavaBasedContentProposalProvider.DefaultProposalCreator((AbstractJavaBasedContentProposalProvider)this, contentAssistContext, ruleName, this.getQualifiedNameConverter()){

            public ICompletionProposal apply(IEObjectDescription candidate) {
                IEObjectDescription myCandidate = candidate;
                ContentAssistContext myContentAssistContext = contentAssistContext;
                if (myCandidate instanceof MultiNameDescription) {
                    final MultiNameDescription multiNamed = (MultiNameDescription)candidate;
                    myCandidate = multiNamed.getDelegate();
                    myContentAssistContext = myContentAssistContext.copy().setMatcher(new PrefixMatcher(){

                        public boolean isCandidateMatchingPrefix(String name, String prefix) {
                            PrefixMatcher delegateMatcher = contentAssistContext.getMatcher();
                            if (delegateMatcher.isCandidateMatchingPrefix(name, prefix)) {
                                return true;
                            }
                            IQualifiedNameConverter converter = XbaseProposalProvider.this.getQualifiedNameConverter();
                            for (QualifiedName otherName : multiNamed.getOtherNames()) {
                                String alternative = converter.toString(otherName);
                                if (!delegateMatcher.isCandidateMatchingPrefix(alternative, prefix)) continue;
                                return true;
                            }
                            return false;
                        }
                    }).toContext();
                }
                if (myCandidate instanceof JvmFeatureDescription && (XbaseProposalProvider.this.grammarAccess.getIdOrSuperRule().getName().equals(ruleName) || XbaseProposalProvider.this.grammarAccess.getValidIDRule().getName().equals(ruleName))) {
                    EObject objectOrProxy;
                    StyledString displayString;
                    ICompletionProposal result = null;
                    String key = ((JvmFeatureDescription)myCandidate).getKey();
                    boolean withParenths = key.endsWith(")");
                    String proposal = XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getName());
                    if (ruleName != null) {
                        try {
                            proposal = XbaseProposalProvider.this.getValueConverter().toString((Object)proposal, ruleName);
                        }
                        catch (ValueConverterException e) {
                            log.debug((Object)e.getMessage(), (Throwable)e);
                            return null;
                        }
                    }
                    if (withParenths) {
                        proposal = String.valueOf(proposal) + "()";
                    }
                    if ((result = XbaseProposalProvider.this.createCompletionProposal(proposal, displayString = XbaseProposalProvider.this.getStyledDisplayString((JvmFeature)(objectOrProxy = myCandidate.getEObjectOrProxy()), withParenths, XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getQualifiedName()), XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getName())), null, myContentAssistContext)) instanceof ConfigurableCompletionProposal) {
                        ConfigurableCompletionProposal casted = (ConfigurableCompletionProposal)result;
                        casted.setAdditionalProposalInfo((Object)objectOrProxy);
                        casted.setHover(XbaseProposalProvider.this.getHover());
                        if (withParenths) {
                            casted.setSelectionStart(casted.getReplacementOffset() + proposal.length() - 1);
                            casted.setSelectionLength(0);
                            casted.setAutoInsertable(false);
                            casted.setSimpleLinkedMode(myContentAssistContext.getViewer(), new char[]{'\t', '\n'});
                        }
                    }
                    XbaseProposalProvider.this.getPriorityHelper().adjustCrossReferencePriority(result, myContentAssistContext.getPrefix());
                    return result;
                }
                return super.apply(candidate);
            }
        };
    }

    protected StyledString getStyledDisplayString(JvmFeature feature, boolean withParenths, String qualifiedNameAsString, String shortName) {
        StyledString result = new StyledString(shortName);
        if (feature instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)feature;
            if (withParenths) {
                result.append('(');
                this.appendParameters(result, (JvmExecutable)feature);
                result.append(')');
            }
            if (operation.getReturnType() != null) {
                result.append(" : ");
                result.append(operation.getReturnType().getSimpleName());
            }
            result.append(" - ", StyledString.QUALIFIER_STYLER);
            result.append(feature.getDeclaringType().getSimpleName(), StyledString.QUALIFIER_STYLER);
            if (!withParenths) {
                result.append(".", StyledString.QUALIFIER_STYLER);
                result.append(feature.getSimpleName(), StyledString.QUALIFIER_STYLER);
                result.append("()", StyledString.QUALIFIER_STYLER);
            }
        } else if (feature instanceof JvmField) {
            result.append(" : ");
            result.append(((JvmField)feature).getType().getSimpleName());
            result.append(" - ", StyledString.QUALIFIER_STYLER);
            result.append(feature.getDeclaringType().getSimpleName(), StyledString.QUALIFIER_STYLER);
        } else if (feature instanceof JvmConstructor && withParenths) {
            result.append('(');
            this.appendParameters(result, (JvmExecutable)feature);
            result.append(')');
        }
        return result;
    }

    protected void appendParameters(StyledString result, JvmExecutable executable) {
        boolean first = true;
        for (JvmFormalParameter parameter : executable.getParameters()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(parameter.getParameterType().getSimpleName());
            result.append(' ');
            result.append(Strings.notNull((Object)parameter.getName()));
        }
    }

    protected Predicate<IEObjectDescription> getFeatureDescriptionPredicate(ContentAssistContext contentAssistContext) {
        return this.featureDescriptionPredicate;
    }

    protected QualifiedNameValueConverter getQualifiedNameValueConverter() {
        return this.qualifiedNameValueConverter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidFeatureDescription
    implements Predicate<IEObjectDescription> {
        @Inject
        private OperatorMapping operatorMapping;

        public boolean apply(IEObjectDescription input) {
            if (input instanceof JvmFeatureDescription) {
                if (!((JvmFeatureDescription)input).isValid()) {
                    return false;
                }
                return this.operatorMapping.getOperator(input.getName()) == null;
            }
            return true;
        }
    }
}

