/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hover;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

public class XbaseHoverProvider
extends DefaultEObjectHoverProvider {
    @Inject
    private ITypeProvider typeProvider;

    protected String getFirstLine(EObject o) {
        if (o instanceof JvmIdentifiableElement) {
            JvmTypeReference type = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)o);
            return this.getFirstLine(type, o);
        }
        return super.getFirstLine(o);
    }

    protected String getFirstLine(JvmTypeReference type, EObject o) {
        String typeString = "";
        if (type != null) {
            typeString = type instanceof JvmAnyTypeReference ? "null " : String.valueOf(type.getSimpleName()) + " ";
        }
        String label = this.getFirstLineLabel(o);
        String plain = String.valueOf(typeString) + (label != null ? label : "");
        return "<b>" + this.toHtml(plain) + "</b>";
    }

    protected String getFirstLineLabel(EObject o) {
        XSwitchExpression switchExpression;
        if (o instanceof XCasePart && o.eContainer() instanceof XSwitchExpression && (switchExpression = (XSwitchExpression)o.eContainer()) != null) {
            XFeatureCall call;
            if (switchExpression.getLocalVarName() != null) {
                return switchExpression.getLocalVarName();
            }
            if (switchExpression.getSwitch() instanceof XFeatureCall && (call = (XFeatureCall)switchExpression.getSwitch()).getFeature() != null) {
                return call.getFeature().getSimpleName();
            }
        }
        String label = this.getLabel(o);
        return label;
    }

    protected String toHtml(String plain) {
        String result = plain.replace("<", "&lt;").replace(">", "&gt;");
        return result;
    }

    protected boolean hasHover(EObject o) {
        return o instanceof JvmIdentifiableElement || super.hasHover(o);
    }

    protected ITypeProvider getTypeProvider() {
        return this.typeProvider;
    }
}

