/*
* generated by Xtext
*/
package org.eclipse.xtext.xtend2.ui.outline;

import static com.google.common.collect.Iterables.*;
import static com.google.common.collect.Lists.*;
import static com.google.common.collect.Sets.*;
import static java.util.Collections.*;

import java.util.Comparator;
import java.util.List;
import java.util.Set;

import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.xtend2.jvmmodel.DispatchUtil;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.ui.labeling.Xtend2Images;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendMember;

import com.google.inject.Inject;

/**
 * Customization of the default outline structure.
 * 
 * @author Jan Koehnlein
 */
public class Xtend2OutlineTreeProvider extends DefaultOutlineTreeProvider {

	@Inject
	private Xtend2Images images;

	@Inject
	private IXtend2JvmAssociations associations;

	@Inject
	private DispatchUtil dispatchUtil;

	protected void _createChildren(DocumentRootNode parentNode, XtendFile xtendFile) {
		if (xtendFile.getPackage() != null)
			createEStructuralFeatureNode(parentNode, xtendFile, Xtend2Package.Literals.XTEND_FILE__PACKAGE,
					images.forPackage(), xtendFile.getPackage(), true);
		if (!xtendFile.getImports().isEmpty())
			createEStructuralFeatureNode(parentNode, xtendFile, Xtend2Package.Literals.XTEND_FILE__IMPORTS,
					images.forImportContainer(), "import declarations", false);
		if (xtendFile.getXtendClass() != null)
			createEObjectNode(parentNode, xtendFile.getXtendClass());
	}

	protected void _createChildren(IOutlineNode parentNode, XtendClass xtendClass) {
		JvmGenericType inferredType = associations.getInferredType(xtendClass);
		if (inferredType != null) {
			Set<XtendFunction> dispatchFunctions = newHashSet();
			for (XtendMember member : xtendClass.getMembers()) {
				if (!dispatchFunctions.contains(member) && member instanceof XtendFunction
						&& ((XtendFunction) member).isDispatch()) {
					for (JvmOperation inferredOperation : filter(associations
							.getJvmElements(member), JvmOperation.class)) {
						if (dispatchUtil.isDispatcherFunction(inferredOperation)) {
							createEObjectNode(parentNode, inferredOperation);
							dispatchFunctions.addAll(newArrayList(filter(associations.getSourceElements(inferredOperation),
									XtendFunction.class)));
						}
					}
				}
			}
			for (XtendMember member : xtendClass.getMembers()) {
				if (!dispatchFunctions.contains(member))
					createEObjectNode(parentNode, member);
			}
		} else {
			for (XtendMember member : xtendClass.getMembers())
				createEObjectNode(parentNode, member);
		}
	}

	protected void _createChildren(IOutlineNode parentNode, JvmOperation inferredOperation) {
		List<XtendFunction> xtendFunctions = newArrayList(filter(associations.getSourceElements(inferredOperation),
				XtendFunction.class));
		sort(xtendFunctions, new Comparator<XtendFunction>() {
			public int compare(XtendFunction arg0, XtendFunction arg1) {
				return index(arg0) - index(arg1);
			}
		});
		for (XtendFunction xtendFunction : xtendFunctions) {
			if (xtendFunction.isDispatch())
				createEObjectNode(parentNode, xtendFunction);
		}
	}

	protected boolean _isLeaf(XtendMember function) {
		return true;
	}

	protected int index(XtendFunction f) {
		return ((XtendClass) f.eContainer()).getMembers().indexOf(f);
	}

}
