
/*
* generated by Xtext
*/
package org.eclipse.xtext.xtend2.ui.refactoring;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringStatusException;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.AbstractJvmModelRenameStrategy;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.JvmMemberRenameStrategy;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.RenameJvmReferenceContext;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;

import com.google.inject.Inject;

/**
 * Encapsulates the model changes of a rename refactoring.  
 */
@SuppressWarnings("restriction")
public class Xtend2RenameStrategy extends AbstractJvmModelRenameStrategy {

	public static class Provider extends DefaultRenameStrategy.Provider {

		@Inject
		private IXtend2JvmAssociations jvmModelAssociations;

		@Override
		public IRenameStrategy get(EObject targetElement, IRenameElementContext renameElementContext) {
			if (renameElementContext instanceof RenameJvmReferenceContext) {
				return new JvmMemberRenameStrategy((JvmMember) targetElement);
			}
			return new Xtend2RenameStrategy(targetElement, getLocationInFileProvider(), jvmModelAssociations);
		}
	}
	
	protected Xtend2RenameStrategy(EObject targetElement, ILocationInFileProvider locationInFileProvider,
			IXtend2JvmAssociations jvmModelAssociations) {
		super(targetElement, locationInFileProvider, jvmModelAssociations);
	}
	
	@Override
	public void createDeclarationUpdates(String newName, ResourceSet resourceSet,
			IRefactoringUpdateAcceptor updateAcceptor) {
		super.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
		IPath path = getPathToRename(targetElementOriginalURI, resourceSet);
		if(path != null) 
			updateAcceptor.accept(targetElementOriginalURI.trimFragment(), new RenameResourceChange(path, newName + "." + path.getFileExtension()));
	}
	
	@Override
	protected IXtend2JvmAssociations getJvmModelAssociations() {
		return (IXtend2JvmAssociations) super.getJvmModelAssociations();
	}

	@Override
	protected void setInferredJvmElementName(String name, EObject renamedElement) {
		if (renamedElement instanceof XtendClass) {
			JvmGenericType inferredJvmType = getJvmModelAssociations().getInferredType((XtendClass) renamedElement);
			if(inferredJvmType != null) {
				inferredJvmType.setSimpleName(((XtendClass)renamedElement).getName());
				inferredJvmType.setPackageName(((XtendClass)renamedElement).getPackageName());
			}
			JvmConstructor inferredConstructor = getJvmModelAssociations().getInferredConstructor((XtendClass) renamedElement);
			if(inferredConstructor != null) {
				inferredConstructor.setSimpleName(((XtendClass)renamedElement).getName());
			}
		} else if(renamedElement instanceof XtendFunction) {
			JvmMember inferredJvmMember = getJvmModelAssociations().getDirectlyInferredOperation(((XtendFunction) renamedElement));
			if(inferredJvmMember != null) {
				inferredJvmMember.setSimpleName(((XtendFunction) renamedElement).getName());
			}
		}
	}
	
	protected IPath getPathToRename(URI elementURI, ResourceSet resourceSet) {
		EObject targetObject = resourceSet.getEObject(elementURI, false);
		if(targetObject instanceof XtendClass) {
			URI resourceURI = EcoreUtil2.getNormalizedResourceURI(targetObject);
			if(!resourceURI.isPlatformResource())
				throw new RefactoringStatusException("Renamed class does not reside in the workspace", true);
			IPath path = new Path("/").append(new Path(resourceURI.path()).removeFirstSegments(1));
			return path;
		}
		return null;
		
	}
}
