/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;

public class RichStringPartitionDelimiterSkippingStrategy
extends AbstractEditStrategy {
    private final String partitionDelimiter = "'''";

    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.length == 0 && command.text.length() == 1) {
            ITypedRegion partition = document.getPartition(command.offset);
            String partitionContent = document.get(partition.getOffset(), partition.getLength());
            int relativeOffset = command.offset - partition.getOffset();
            if (relativeOffset < partition.getLength() - "'''".length()) {
                if (relativeOffset == 0 || relativeOffset >= "'''".length()) {
                    return;
                }
                if (!partitionContent.startsWith("'''")) {
                    return;
                }
                String text = command.text;
                if (partitionContent.substring(relativeOffset, relativeOffset + text.length()).equals(text)) {
                    command.length = text.length();
                }
            } else {
                if (!partitionContent.endsWith("'''")) {
                    return;
                }
                String text = command.text;
                if (partitionContent.length() - relativeOffset < text.length()) {
                    text = text.substring(0, partitionContent.length() - relativeOffset);
                }
                if (partitionContent.substring(relativeOffset, relativeOffset + text.length()).equals(text)) {
                    command.length = text.length();
                }
            }
        }
    }
}

