/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.compiler;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.compiler.AnnotationCompiler;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.DelegatingAppendable;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xtend2.dispatch.DispatchingSupport;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtext.xtend2.richstring.DefaultIndentationHandler;
import org.eclipse.xtext.xtend2.richstring.IRichStringIndentationHandler;
import org.eclipse.xtext.xtend2.richstring.RichStringProcessor;
import org.eclipse.xtext.xtend2.xtend2.CreateExtensionInfo;
import org.eclipse.xtext.xtend2.xtend2.RichString;
import org.eclipse.xtext.xtend2.xtend2.RichStringForLoop;
import org.eclipse.xtext.xtend2.xtend2.RichStringIf;
import org.eclipse.xtext.xtend2.xtend2.RichStringLiteral;
import org.eclipse.xtext.xtend2.xtend2.XtendAnnotationTarget;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendClassSuperCallReferable;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendMember;
import org.eclipse.xtext.xtend2.xtend2.XtendParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xtend2Compiler
extends XbaseCompiler {
    @Inject
    private RichStringProcessor richStringProcessor;
    @Inject
    private Provider<DefaultIndentationHandler> indentationHandler;
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private IXtend2JvmAssociations associations;
    @Inject
    private AnnotationCompiler annotationCompiler;

    public void compile(XtendFile obj, Writer writer) {
        try {
            if (obj.getPackage() != null) {
                writer.append("package ");
                writer.append(obj.getPackage());
                writer.append(";\n");
            }
            ImportManager importManager = new ImportManager(true, obj.getXtendClass() != null ? obj.getXtendClass().getName() : null);
            StringBuilderBasedAppendable appendable = new StringBuilderBasedAppendable(importManager);
            if (obj.getXtendClass() != null) {
                this.compile(obj.getXtendClass(), (IAppendable)appendable);
            }
            for (String imprt : appendable.getImports()) {
                writer.append("\nimport ").append(imprt).append(";");
            }
            writer.append("\n");
            writer.append(appendable.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void compile(EObject obj, IAppendable appendable) {
        if (obj instanceof XtendClass) {
            this.compile((XtendClass)obj, appendable);
        } else if (obj instanceof XtendFunction) {
            this.compile((XtendFunction)obj, appendable);
        } else if (obj instanceof XtendFile) {
            this.compile(obj, appendable);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void compile(XtendClass obj, IAppendable appendable) {
        appendable.append((Object)"\n@SuppressWarnings(\"all\")");
        this.generateAnnotations(obj, appendable);
        appendable.append((Object)"\npublic class ").append((Object)obj.getName());
        this.appendTypeParameterDeclaration((EList<JvmTypeParameter>)obj.getTypeParameters(), appendable);
        if (obj.getExtends() != null) {
            appendable.append((Object)" extends ");
            this.serialize(obj.getExtends(), obj, appendable);
        }
        if (!obj.getImplements().isEmpty()) {
            appendable.append((Object)" implements ");
            this.serialize((JvmTypeReference)obj.getImplements().get(0), obj, appendable);
            int i = 1;
            while (i < obj.getImplements().size()) {
                appendable.append((Object)", ");
                this.serialize((JvmTypeReference)obj.getImplements().get(i), obj, appendable);
                ++i;
            }
        }
        appendable.append((Object)" {");
        appendable.increaseIndentation();
        this.declareThis(obj, appendable);
        for (XtendMember member : obj.getMembers()) {
            if (member instanceof XtendFunction) {
                this.compile((XtendFunction)member, appendable);
                continue;
            }
            if (!(member instanceof XtendField)) continue;
            this.compile((XtendField)member, appendable);
        }
        this.generateDispatchMethods(obj, appendable);
        appendable.decreaseIndentation();
        appendable.append((Object)"\n}");
    }

    protected void compile(XtendField field, IAppendable appendable) {
        appendable.append((Object)"\n");
        this.generateAnnotations(field, appendable);
        appendable.append((Object)"\nprivate ");
        this.serialize(field.getType(), field, appendable);
        appendable.append((Object)" ");
        appendable.append((Object)appendable.declareVariable((Object)field, field.getName())).append((Object)";");
    }

    protected void generateAnnotations(XtendAnnotationTarget annotationTarget, IAppendable appendable) {
        for (XAnnotation anno : annotationTarget.getAnnotations()) {
            appendable.append((Object)"\n");
            this.annotationCompiler.generate((EObject)anno, appendable);
        }
    }

    protected void generateDispatchMethods(XtendClass obj, IAppendable appendable) {
        JvmGenericType type = this.associations.getInferredType(obj);
        Multimap<Pair<String, Integer>, JvmOperation> dispatchMethods = this.dispatchingSupport.getDispatchMethods(type);
        for (Pair dispatchMethod : dispatchMethods.keySet()) {
            JvmOperation jvmOperation = this.dispatchingSupport.findSyntheticDispatchMethod(obj, (Pair<String, Integer>)dispatchMethod);
            this.generateDispatchMethod(jvmOperation, dispatchMethods.get((Object)dispatchMethod), appendable);
        }
    }

    protected void generateDispatchMethod(JvmOperation dispatchOperation, Collection<JvmOperation> collection, IAppendable a) {
        a.openScope();
        a.append((Object)"\n\npublic ");
        this.serialize(dispatchOperation.getReturnType(), (EObject)dispatchOperation, a);
        a.append((Object)" ");
        a.append((Object)dispatchOperation.getSimpleName()).append((Object)"(");
        this.declareJvmParameters((EList<JvmFormalParameter>)dispatchOperation.getParameters(), a);
        a.append((Object)") ");
        this.declareExceptions(dispatchOperation, a);
        a.append((Object)"{");
        a.increaseIndentation();
        a.append((Object)"\n");
        for (JvmOperation operation : this.dispatchingSupport.sort(collection)) {
            a.append((Object)"if (");
            a.increaseIndentation().increaseIndentation();
            Iterator iter1 = dispatchOperation.getParameters().iterator();
            Iterator iter2 = operation.getParameters().iterator();
            while (iter2.hasNext()) {
                JvmFormalParameter p1 = (JvmFormalParameter)iter1.next();
                JvmFormalParameter p2 = (JvmFormalParameter)iter2.next();
                JvmTypeReference type = p2.getParameterType();
                String name = this.getVarName(p1, a);
                if (this.getTypeReferences().is(type, Void.class)) {
                    a.append((Object)"(").append((Object)name).append((Object)" == null)");
                } else {
                    a.append((Object)"(").append((Object)name).append((Object)" instanceof ");
                    a.append((Object)this.getPrimitives().asWrapperTypeIfPrimitive(type).getType()).append((Object)")");
                }
                if (!iter2.hasNext()) continue;
                a.append((Object)"\n && ");
            }
            a.decreaseIndentation().decreaseIndentation();
            a.append((Object)") {").increaseIndentation();
            a.append((Object)"\n");
            boolean isCurrentVoid = this.getTypeReferences().is(operation.getReturnType(), Void.TYPE);
            boolean isDispatchVoid = this.getTypeReferences().is(dispatchOperation.getReturnType(), Void.TYPE);
            if (isDispatchVoid) {
                this.generateActualDispatchCall(dispatchOperation, operation, a);
                a.append((Object)";");
            } else {
                if (isCurrentVoid) {
                    this.generateActualDispatchCall(dispatchOperation, operation, a);
                    a.append((Object)";\nreturn null");
                } else {
                    a.append((Object)"return ");
                    this.generateActualDispatchCall(dispatchOperation, operation, a);
                }
                a.append((Object)";");
            }
            a.decreaseIndentation().append((Object)"\n} else ");
        }
        a.append((Object)"{").increaseIndentation();
        a.append((Object)"\nthrow new IllegalArgumentException();");
        a.decreaseIndentation().append((Object)"\n}");
        a.decreaseIndentation().append((Object)"\n}");
        a.closeScope();
    }

    protected void generateActualDispatchCall(JvmOperation dispatchOperation, JvmOperation actualOperationToCall, IAppendable a) {
        a.append((Object)actualOperationToCall.getSimpleName()).append((Object)"(");
        Iterator iter1 = dispatchOperation.getParameters().iterator();
        Iterator iter2 = actualOperationToCall.getParameters().iterator();
        while (iter2.hasNext()) {
            JvmFormalParameter p1 = (JvmFormalParameter)iter1.next();
            JvmFormalParameter p2 = (JvmFormalParameter)iter2.next();
            a.append((Object)"(");
            this.serialize(this.getPrimitives().asWrapperTypeIfPrimitive(p2.getParameterType()), (EObject)dispatchOperation, a);
            a.append((Object)")");
            if (this.getTypeReferences().is(p2.getParameterType(), Void.class)) {
                a.append((Object)"null");
            } else {
                a.append((Object)this.getVarName(p1, a));
            }
            if (!iter2.hasNext()) continue;
            a.append((Object)", ");
        }
        a.append((Object)")");
    }

    protected void compile(XtendFunction obj, IAppendable appendable) {
        if (obj.getCreateExtensionInfo() != null) {
            this.declareCreateExtensionCache(obj, appendable);
        }
        appendable.openScope();
        JvmTypeReference returnType = this.associations.getDirectlyInferredOperation(obj).getReturnType();
        String name = obj.getName();
        if (obj.isDispatch()) {
            name = "_" + name;
        }
        appendable.append((Object)"\n");
        this.generateAnnotations(obj, appendable);
        appendable.append((Object)"\npublic ");
        this.appendTypeParameterDeclaration((EList<JvmTypeParameter>)obj.getTypeParameters(), appendable);
        this.serialize(this.resolveMultiType(returnType), obj, appendable);
        appendable.append((Object)" ").append((Object)name).append((Object)"(");
        EList<XtendParameter> parameters = obj.getParameters();
        this.declareParameters(parameters, appendable);
        appendable.append((Object)") ");
        JvmOperation operation = this.associations.getDirectlyInferredOperation(obj);
        this.declareExceptions(operation, appendable);
        appendable.append((Object)"{");
        appendable.increaseIndentation();
        if (obj.getCreateExtensionInfo() != null) {
            this.compileCreateExtensionBody(obj, appendable);
        } else {
            this.compile(obj.getExpression(), appendable, returnType);
        }
        appendable.decreaseIndentation();
        appendable.append((Object)"\n}").closeScope();
    }

    protected void declareExceptions(JvmOperation obj, IAppendable appendable) {
        List<JvmTypeReference> checkedExceptions = this.getCheckedExceptions(obj);
        HashSet alreadyDeclared = Sets.newHashSet();
        if (!checkedExceptions.isEmpty()) {
            appendable.append((Object)"throws ");
            Iterator<JvmTypeReference> iterator = checkedExceptions.iterator();
            while (iterator.hasNext()) {
                JvmTypeReference jvmTypeReference = iterator.next();
                if (!alreadyDeclared.add(jvmTypeReference.getType())) continue;
                this.serialize(jvmTypeReference, (EObject)obj, appendable);
                if (!iterator.hasNext()) continue;
                appendable.append((Object)", ");
            }
            appendable.append((Object)" ");
        }
    }

    protected void compileCreateExtensionBody(XtendFunction obj, IAppendable appendable) {
        CreateExtensionInfo info = obj.getCreateExtensionInfo();
        JvmTypeReference listType = this.getTypeReferences().getTypeForName(ArrayList.class, (EObject)obj, new JvmTypeReference[0]);
        JvmTypeReference collectonLiterals = this.getTypeReferences().getTypeForName(CollectionLiterals.class, (EObject)obj, new JvmTypeReference[0]);
        String cacheVarName = appendable.getName(this.cacheVarKey(info));
        String cacheKeyVarName = appendable.declareVariable((Object)"CacheKey", "_cacheKey");
        appendable.append((Object)"\nfinal ");
        this.serialize(listType, (EObject)info.getCreateExpression(), appendable);
        appendable.append((Object)cacheKeyVarName).append((Object)" = ");
        this.serialize(collectonLiterals, (EObject)info.getCreateExpression(), appendable);
        appendable.append((Object)".newArrayList(");
        EList<XtendParameter> list = obj.getParameters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XtendParameter jvmFormalParameter = (XtendParameter)iterator.next();
            appendable.append((Object)appendable.getName((Object)jvmFormalParameter));
            if (!iterator.hasNext()) continue;
            appendable.append((Object)", ");
        }
        appendable.append((Object)");");
        JvmTypeReference returnType = this.getTypeProvider().getType(info.getCreateExpression());
        appendable.append((Object)"\n");
        this.serialize(returnType, (EObject)info.getCreateExpression(), appendable);
        String varName = this.declareNameInVariableScope((EObject)info, appendable);
        appendable.append((Object)" ").append((Object)varName).append((Object)";");
        appendable.append((Object)"\nsynchronized (").append((Object)cacheVarName).append((Object)") {");
        appendable.increaseIndentation();
        appendable.append((Object)"\nif (").append((Object)cacheVarName).append((Object)".containsKey(").append((Object)cacheKeyVarName).append((Object)")) {");
        appendable.increaseIndentation();
        appendable.append((Object)"\nreturn ").append((Object)cacheVarName).append((Object)".get(").append((Object)cacheKeyVarName).append((Object)");");
        appendable.decreaseIndentation().append((Object)"\n}");
        this.internalToJavaStatement(info.getCreateExpression(), appendable, true);
        appendable.append((Object)"\n");
        appendable.append((Object)varName).append((Object)" = ");
        this.internalToJavaExpression(info.getCreateExpression(), appendable);
        appendable.append((Object)";");
        appendable.append((Object)"\n").append((Object)cacheVarName).append((Object)".put(").append((Object)cacheKeyVarName).append((Object)", ").append((Object)varName).append((Object)");");
        appendable.decreaseIndentation();
        appendable.append((Object)"\n}");
        JvmTypeReference primitiveVoid = this.getTypeReferences().getTypeForName(Void.TYPE, (EObject)obj, new JvmTypeReference[0]);
        this.compile(obj.getExpression(), appendable, primitiveVoid);
        appendable.append((Object)"\nreturn ");
        appendable.append((Object)varName).append((Object)";");
    }

    protected void declareCreateExtensionCache(XtendFunction obj, IAppendable appendable) {
        CreateExtensionInfo info = obj.getCreateExtensionInfo();
        JvmTypeReference returnType = this.getTypeProvider().getType(info.getCreateExpression());
        JvmTypeReference list = this.getTypeReferences().getTypeForName(ArrayList.class, (EObject)obj, new JvmTypeReference[0]);
        JvmTypeReference map = this.getTypeReferences().getTypeForName(HashMap.class, (EObject)obj, new JvmTypeReference[]{list, returnType});
        appendable.append((Object)"\n\nprivate final ");
        this.serialize(map, (EObject)info.getCreateExpression(), appendable);
        appendable.append((Object)" ");
        String cacheName = appendable.declareVariable(this.cacheVarKey(info), "_createCache_" + obj.getName());
        appendable.append((Object)cacheName);
        appendable.append((Object)" = new ");
        this.serialize(map, (EObject)info.getCreateExpression(), appendable);
        appendable.append((Object)"();");
    }

    protected Object cacheVarKey(CreateExtensionInfo createExtensionInfo) {
        return Tuples.pair((Object)"cache", (Object)createExtensionInfo);
    }

    protected void appendTypeParameterDeclaration(EList<JvmTypeParameter> typeParameters, IAppendable appendable) {
        if (!typeParameters.isEmpty()) {
            appendable.append((Object)"<");
            Iterator iterator = typeParameters.iterator();
            while (iterator.hasNext()) {
                JvmTypeParameter tp = (JvmTypeParameter)iterator.next();
                appendable.append((Object)tp);
                Iterable constraints = Iterables.filter((Iterable)tp.getConstraints(), JvmUpperBound.class);
                Iterator iter2 = constraints.iterator();
                if (iter2.hasNext()) {
                    appendable.append((Object)" extends ");
                    while (iter2.hasNext()) {
                        JvmUpperBound constraint = (JvmUpperBound)iter2.next();
                        this.serialize(constraint.getTypeReference(), (EObject)tp, appendable);
                        if (!iter2.hasNext()) continue;
                        appendable.append((Object)",");
                    }
                }
                if (!iterator.hasNext()) continue;
                appendable.append((Object)",");
            }
            appendable.append((Object)"> ");
        }
    }

    protected List<JvmTypeReference> getCheckedExceptions(JvmOperation operation) {
        Iterable types = this.getTypeProvider().getThrownExceptionForIdentifiable((JvmIdentifiableElement)operation);
        ArrayList result = Lists.newArrayList();
        HashSet alreadyDeclared = Sets.newHashSet();
        for (JvmTypeReference jvmTypeReference : types) {
            if (!alreadyDeclared.add(jvmTypeReference.getType()) || !this.getTypeReferences().isInstanceOf(jvmTypeReference, Exception.class)) continue;
            result.add(jvmTypeReference);
        }
        Collections.sort(result, new Comparator<JvmTypeReference>(){

            @Override
            public int compare(JvmTypeReference o1, JvmTypeReference o2) {
                return o1.getIdentifier().compareTo(o2.getIdentifier());
            }
        });
        return result;
    }

    protected void declareParameters(EList<XtendParameter> parameters, IAppendable appendable) {
        int numParams = parameters.size();
        int i = 0;
        while (i < numParams) {
            XtendParameter p = (XtendParameter)parameters.get(i);
            String varName = this.declareNameInVariableScope(p, appendable);
            appendable.append((Object)"final ");
            this.serialize(p.getParameterType(), p, appendable);
            appendable.append((Object)" ").append((Object)varName);
            if (i != numParams - 1) {
                appendable.append((Object)", ");
            }
            ++i;
        }
    }

    protected void declareJvmParameters(EList<JvmFormalParameter> parameters, IAppendable appendable) {
        int numParams = parameters.size();
        int i = 0;
        while (i < numParams) {
            JvmFormalParameter p = (JvmFormalParameter)parameters.get(i);
            String varName = this.declareNameInVariableScope((EObject)p, appendable);
            appendable.append((Object)"final ");
            this.serialize(p.getParameterType(), (EObject)p, appendable);
            appendable.append((Object)" ").append((Object)varName);
            if (i != numParams - 1) {
                appendable.append((Object)", ");
            }
            ++i;
        }
    }

    protected void declareThis(XtendClass clazz, IAppendable appendable) {
        appendable.declareVariable((Object)clazz, "this");
        appendable.declareVariable((Object)clazz.getSuperCallReferable(), "super");
    }

    protected void _toJavaStatement(XClosure closure, IAppendable b, boolean isReferenced) {
        super._toJavaStatement(closure, this.getClosureContextAppendable(b), isReferenced);
    }

    protected IAppendable getClosureContextAppendable(IAppendable appendable) {
        return new DelegatingAppendable(appendable){

            public String getName(Object key) {
                if (key instanceof XtendClass) {
                    return String.valueOf(((XtendClass)key).getSimpleName()) + ".this";
                }
                if (key instanceof XtendClassSuperCallReferable) {
                    return String.valueOf(((XtendClassSuperCallReferable)key).getXtendClass().getSimpleName()) + ".super";
                }
                return super.getName(key);
            }
        };
    }

    protected String getFavoriteVariableName(EObject ex) {
        if (ex instanceof RichStringForLoop) {
            return "hasAnyElements";
        }
        return super.getFavoriteVariableName(ex);
    }

    public void _toJavaStatement(RichString richString, IAppendable b, boolean isReferenced) {
        JvmTypeReference type = this.getTypeProvider().getType((XExpression)richString);
        String variableName = b.declareVariable((Object)Tuples.pair((Object)richString, (Object)"result"), "_builder");
        b.append((Object)"\n");
        this.serialize(type, (EObject)richString, b);
        b.append((Object)" ");
        b.append((Object)variableName);
        b.append((Object)" = new ");
        this.serialize(type, (EObject)richString, b);
        b.append((Object)"();");
        RichStringPrepareCompiler compiler = new RichStringPrepareCompiler(b, variableName);
        this.richStringProcessor.process(richString, compiler, (IRichStringIndentationHandler)this.indentationHandler.get());
    }

    public void _toJavaExpression(RichString richString, IAppendable b) {
        b.append((Object)this.getVarName(Tuples.pair((Object)richString, (Object)"result"), b));
    }

    public class RichStringPrepareCompiler
    extends AbstractRichStringPartAcceptor.ForLoopOnce {
        private final LinkedList<RichStringIf> ifStack = Lists.newLinkedList();
        private final LinkedList<RichStringForLoop> forStack = Lists.newLinkedList();
        private final IAppendable appendable;
        private final String variableName;

        public RichStringPrepareCompiler(IAppendable appendable, String variableName) {
            this.appendable = appendable;
            this.variableName = variableName;
        }

        public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
            this.appendable.append((Object)"\n");
            this.appendable.append((Object)this.variableName);
            if (!controlStructureSeen) {
                this.appendable.append((Object)".newLine();");
            } else {
                this.appendable.append((Object)".newLineIfNotEmpty();");
            }
        }

        public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
        }

        public void acceptSemanticText(CharSequence text, RichStringLiteral origin) {
            if (text.length() == 0) {
                return;
            }
            this.appendable.append((Object)"\n");
            this.appendable.append((Object)this.variableName);
            this.appendable.append((Object)".append(\"");
            this.appendable.append((Object)Strings.convertToJavaString((String)text.toString()));
            this.appendable.append((Object)"\");");
        }

        public void acceptIfCondition(XExpression condition) {
            this.ifStack.add((RichStringIf)condition.eContainer());
            this.appendable.append((Object)"\n");
            this.appendable.append((Object)"{").increaseIndentation();
            this.writeIf(condition);
        }

        public void acceptElseIfCondition(XExpression condition) {
            this.writeElse();
            this.writeIf(condition);
        }

        protected void writeIf(XExpression condition) {
            Xtend2Compiler.this.internalToJavaStatement(condition, this.appendable, true);
            this.appendable.append((Object)"\n");
            this.appendable.append((Object)"if (");
            Xtend2Compiler.this.internalToJavaExpression(condition, this.appendable);
            this.appendable.append((Object)") {").increaseIndentation();
        }

        protected void writeElse() {
            this.appendable.decreaseIndentation();
            this.appendable.append((Object)"} else {");
            this.appendable.increaseIndentation();
        }

        public void acceptElse() {
            this.writeElse();
        }

        public void acceptEndIf() {
            RichStringIf richStringIf = this.ifStack.removeLast();
            int i = 0;
            while (i < richStringIf.getElseIfs().size() + 2) {
                this.appendable.decreaseIndentation();
                this.appendable.append((Object)"\n");
                this.appendable.append((Object)"}");
                ++i;
            }
        }

        public void acceptForLoop(JvmFormalParameter parameter, XExpression expression) {
            super.acceptForLoop(parameter, expression);
            RichStringForLoop forLoop = (RichStringForLoop)expression.eContainer();
            this.forStack.add(forLoop);
            this.appendable.append((Object)"\n").append((Object)"{").increaseIndentation();
            Xtend2Compiler.this.internalToJavaStatement(expression, this.appendable, true);
            String variableName = null;
            if (forLoop.getAfter() != null || forLoop.getSeparator() != null || forLoop.getAfter() != null) {
                variableName = Xtend2Compiler.this.declareNameInVariableScope((EObject)forLoop, this.appendable);
                this.appendable.append((Object)"\n");
                this.appendable.append((Object)"boolean ");
                this.appendable.append((Object)variableName);
                this.appendable.append((Object)" = false;");
            }
            this.appendable.append((Object)"\n");
            this.appendable.append((Object)"for(");
            JvmTypeReference paramType = Xtend2Compiler.this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)parameter);
            Xtend2Compiler.this.serialize(paramType, (EObject)parameter, this.appendable);
            this.appendable.append((Object)" ");
            String loopParam = Xtend2Compiler.this.declareNameInVariableScope((EObject)parameter, this.appendable);
            this.appendable.append((Object)loopParam);
            this.appendable.append((Object)" : ");
            Xtend2Compiler.this.internalToJavaExpression(expression, this.appendable);
            this.appendable.append((Object)") {").increaseIndentation();
        }

        public boolean forLoopHasNext(XExpression before, XExpression separator, CharSequence indentation) {
            if (!super.forLoopHasNext(before, separator, indentation)) {
                return false;
            }
            RichStringForLoop forLoop = this.forStack.getLast();
            String varName = Xtend2Compiler.this.getVarName(forLoop, this.appendable);
            if (varName != null) {
                this.appendable.append((Object)"\n");
                this.appendable.append((Object)"if (!");
                this.appendable.append((Object)varName);
                this.appendable.append((Object)") {");
                this.appendable.increaseIndentation();
                this.appendable.append((Object)"\n");
                this.appendable.append((Object)varName);
                this.appendable.append((Object)" = true;");
                if (before != null) {
                    this.writeExpression(before, indentation, false);
                }
                this.appendable.decreaseIndentation();
                this.appendable.append((Object)"\n");
                this.appendable.append((Object)"}");
                if (forLoop.getSeparator() != null) {
                    this.appendable.append((Object)" else {");
                    this.appendable.increaseIndentation();
                    this.writeExpression(separator, indentation, true);
                    this.appendable.decreaseIndentation();
                    this.appendable.append((Object)"\n");
                    this.appendable.append((Object)"}");
                }
            }
            return true;
        }

        public void acceptEndFor(XExpression after, CharSequence indentation) {
            super.acceptEndFor(after, indentation);
            this.appendable.decreaseIndentation();
            this.appendable.append((Object)"\n");
            this.appendable.append((Object)"}");
            RichStringForLoop forLoop = this.forStack.removeLast();
            if (after != null) {
                String varName = Xtend2Compiler.this.getVarName(forLoop, this.appendable);
                this.appendable.append((Object)"\n");
                this.appendable.append((Object)"if (");
                this.appendable.append((Object)varName);
                this.appendable.append((Object)") {");
                this.appendable.increaseIndentation();
                this.writeExpression(after, indentation, false);
                this.appendable.decreaseIndentation();
                this.appendable.append((Object)"\n");
                this.appendable.append((Object)"}");
            }
            this.appendable.decreaseIndentation();
            this.appendable.append((Object)"\n");
            this.appendable.append((Object)"}");
        }

        public void acceptExpression(XExpression expression, CharSequence indentation) {
            this.writeExpression(expression, indentation, false);
        }

        protected void writeExpression(XExpression expression, CharSequence indentation, boolean immediate) {
            Xtend2Compiler.this.internalToJavaStatement(expression, this.appendable, true);
            if (!Xtend2Compiler.this.getTypeReferences().is(Xtend2Compiler.this.getTypeProvider().getType(expression), Void.TYPE)) {
                this.appendable.append((Object)"\n");
                this.appendable.append((Object)this.variableName);
                if (immediate) {
                    this.appendable.append((Object)".appendImmediate(");
                } else {
                    this.appendable.append((Object)".append(");
                }
                Xtend2Compiler.this.internalToJavaExpression(expression, this.appendable);
                this.appendable.append((Object)", \"");
                this.appendable.append((Object)indentation.toString());
                this.appendable.append((Object)"\");");
            }
        }
    }
}

