/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.resource;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.resource.XbaseResource;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;
import org.eclipse.xtext.xtend2.dispatch.DispatchingSupport;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.typing.XtendOverridesService;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xtend2Resource
extends XbaseResource {
    public static final String FRAGMENT_PREFIX = "\u00a7lazyType$";
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IXtend2JvmAssociations associations;
    @Inject
    private XbaseTypeConformanceComputer typeConformanceComputer;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private Primitives primitives;
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private XtendOverridesService overridesService;
    private Set<String> computingFragments = Sets.newLinkedHashSet();

    public synchronized EObject getEObject(String uriFragment) {
        if (!uriFragment.startsWith(FRAGMENT_PREFIX)) {
            return super.getEObject(uriFragment);
        }
        if (!this.computingFragments.add(uriFragment)) {
            return null;
        }
        try {
            String fragmentToJvmOperation = uriFragment.substring(FRAGMENT_PREFIX.length());
            EObject eObject = super.getEObject(fragmentToJvmOperation);
            if (eObject instanceof JvmOperation) {
                JvmOperation op = (JvmOperation)eObject;
                JvmTypeReference typeReference = this.inferReturnType(op);
                if (typeReference == null || typeReference.getType() == null) {
                    JvmTypeReference jvmTypeReference = this.typeReferences.getTypeForName(Object.class, (EObject)this.getContents().get(0), new JvmTypeReference[0]);
                    return jvmTypeReference;
                }
                if (typeReference.eContainer() != null && typeReference.eContainer() != op) {
                    typeReference = (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)typeReference);
                }
                JvmTypeReference jvmTypeReference = typeReference;
                return jvmTypeReference;
            }
            if (eObject instanceof JvmFormalParameter) {
                int index;
                JvmFormalParameter param = (JvmFormalParameter)eObject;
                JvmOperation op = (JvmOperation)param.eContainer();
                Multimap<Pair<String, Integer>, JvmOperation> dispatchMethods = this.dispatchingSupport.getDispatchMethods((JvmGenericType)op.getDeclaringType());
                Collection dispatchOperations = dispatchMethods.get((Object)Tuples.pair((Object)op.getSimpleName(), (Object)op.getParameters().size()));
                JvmTypeReference commonType = this.commonType(dispatchOperations, new Function<JvmOperation, JvmTypeReference>(index = op.getParameters().indexOf((Object)param)){
                    private final /* synthetic */ int val$index;
                    {
                        this.val$index = n;
                    }

                    public JvmTypeReference apply(JvmOperation from) {
                        return ((JvmFormalParameter)from.getParameters().get(this.val$index)).getParameterType();
                    }
                });
                if (commonType != null && commonType.eContainer() != null) {
                    commonType = (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)commonType);
                }
                JvmTypeReference jvmTypeReference = commonType;
                return jvmTypeReference;
            }
            throw new IllegalStateException("couldn't resolve type proxy in " + eObject);
        }
        finally {
            this.computingFragments.remove(uriFragment);
        }
    }

    protected JvmTypeReference inferReturnType(JvmOperation jvmOperation) {
        ArrayList associatedReturnTypes = Lists.newArrayList();
        Iterable associatedElements = Iterables.filter((Iterable)this.associations.getSourceElements((EObject)jvmOperation), XtendFunction.class);
        boolean wasDispatch = false;
        for (XtendFunction func : associatedElements) {
            JvmTypeReference type = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)func);
            if (type != null && !(type instanceof JvmAnyTypeReference)) {
                associatedReturnTypes.add(type);
            }
            wasDispatch |= func.isDispatch();
        }
        if (wasDispatch) {
            if (jvmOperation.getSimpleName().startsWith("_")) {
                Iterator iterator = associatedElements.iterator();
                if (iterator.hasNext()) {
                    XtendFunction func;
                    func = (XtendFunction)iterator.next();
                    if (func.getReturnType() != null) {
                        return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)func.getReturnType());
                    }
                    JvmOperation overriddenOperation = this.overridesService.findOverriddenOperation(jvmOperation);
                    if (overriddenOperation != null) {
                        JvmTypeReference result = overriddenOperation.getReturnType();
                        return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)result);
                    }
                    JvmOperation dispatchOperation = this.associations.getDispatchOperation(func);
                    JvmTypeReference result = dispatchOperation.getReturnType();
                    return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)result);
                }
            } else {
                JvmOperation overriddenOperation = this.overridesService.findOverriddenOperation(jvmOperation);
                if (overriddenOperation != null) {
                    JvmTypeReference result = overriddenOperation.getReturnType();
                    return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)result);
                }
            }
        }
        if (!associatedReturnTypes.isEmpty()) {
            JvmTypeReference commonSuperType = this.typeConformanceComputer.getCommonSuperType((List)associatedReturnTypes);
            return commonSuperType;
        }
        return null;
    }

    protected <T> JvmTypeReference commonType(Iterable<? extends T> iterable, Function<T, JvmTypeReference> mapping) {
        ArrayList references = Lists.newArrayList();
        for (T element : iterable) {
            JvmTypeReference apply = (JvmTypeReference)mapping.apply(element);
            if (this.typeReferences.isNullOrProxy(apply)) continue;
            apply = this.primitives.asWrapperTypeIfPrimitive(apply);
            references.add(apply);
        }
        return this.typeConformanceComputer.getCommonSuperType((List)references);
    }
}

