/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.xbase.scoping.featurecalls.AbstractFeaturesForTypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionMethodsFeaturesProvider
extends AbstractFeaturesForTypeProvider {
    @Inject
    private FeatureOverridesService overridesService;
    private JvmTypeReference extensionProvidingType;

    public void setContext(JvmTypeReference type) {
        this.extensionProvidingType = type;
    }

    public Iterable<? extends JvmFeature> getFeaturesForType(JvmTypeReference type) {
        if (this.extensionProvidingType == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        Iterable iterable = this.overridesService.getAllJvmFeatures(this.extensionProvidingType);
        for (JvmFeature jvmFeature : iterable) {
            if (!(jvmFeature instanceof JvmOperation)) continue;
            JvmOperation jvmOperation = (JvmOperation)jvmFeature;
            EList parameters = jvmOperation.getParameters();
            if (jvmOperation.isStatic() || parameters.size() <= 0 || !this.isSameTypeOrAssignableToUpperBound(type, ((JvmFormalParameter)parameters.get(0)).getParameterType())) continue;
            result.add(jvmFeature);
        }
        return result;
    }

    public boolean isExtensionProvider() {
        return true;
    }
}

