/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.xtext.ui.graph.RailroadSelectionProvider;
import org.eclipse.xtext.xtext.ui.graph.RailroadSynchronizer;
import org.eclipse.xtext.xtext.ui.graph.actions.ExportToFileAction;
import org.eclipse.xtext.xtext.ui.graph.actions.LinkWithEditorAction;
import org.eclipse.xtext.xtext.ui.graph.actions.RailroadSelectionLinker;

@Singleton
public class RailroadView
extends ViewPart {
    public static final String ID = "org.eclipse.xtext.xtext.ui.graph.view";
    @Inject
    private RailroadSynchronizer synchronizer;
    @Inject
    private RailroadSelectionProvider selectionProvider;
    @Inject
    private ExportToFileAction exportAction;
    @Inject
    private LinkWithEditorAction linkWithEditorAction;
    @Inject
    private RailroadSelectionLinker selectionLinker;
    private IFigure rootFigure;
    private FigureCanvas canvas;
    private IFigure contents;

    public void createPartControl(Composite parent) {
        this.canvas = new FigureCanvas(parent, 768);
        this.rootFigure = new Figure();
        this.rootFigure.addMouseListener((MouseListener)this.selectionProvider);
        this.rootFigure.setLayoutManager((LayoutManager)new StackLayout());
        this.rootFigure.setVisible(true);
        this.canvas.setContents(this.rootFigure);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.createActions();
    }

    private void createActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.exportAction);
        toolBarManager.add((IAction)this.linkWithEditorAction);
        this.selectionLinker.activate();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.synchronizer);
    }

    public void dispose() {
        this.selectionLinker.deactivate();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.synchronizer);
        super.dispose();
    }

    public void setContents(final IFigure newContents) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (RailroadView.this.contents != null && RailroadView.this.contents.getParent() == RailroadView.this.rootFigure) {
                    RailroadView.this.rootFigure.remove(RailroadView.this.contents);
                }
                if (newContents != null) {
                    RailroadView.this.rootFigure.add(newContents);
                }
                RailroadView.this.rootFigure.revalidate();
                RailroadView.this.contents = newContents;
                RailroadView.this.exportAction.setEnabled(newContents != null);
            }
        });
    }

    public IFigure getContents() {
        return this.contents;
    }

    public IFigure findFigureAt(Point location) {
        return this.rootFigure.findFigureAt(location);
    }

    public void reveal(IFigure figure) {
        Viewport viewport = this.canvas.getViewport();
        Rectangle viewportBounds = viewport.getBounds().getCopy();
        viewportBounds.translate(viewport.getViewLocation());
        Rectangle figureBounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)figureBounds);
        figureBounds.translate(viewport.getViewLocation());
        if (!viewportBounds.contains(figureBounds)) {
            int newX = viewportBounds.x;
            int newY = viewportBounds.y;
            if (viewportBounds.x > figureBounds.x) {
                newX = figureBounds.x;
            } else if (viewportBounds.x + viewportBounds.getRight().x < figureBounds.getRight().x) {
                newX = figureBounds.getRight().x - viewportBounds.width;
            }
            if (viewportBounds.y > figureBounds.y) {
                newY = figureBounds.y;
            } else if (viewportBounds.getBottom().y < figureBounds.getBottom().y) {
                newY = figureBounds.getBottom().y - viewportBounds.height;
            }
            this.canvas.scrollSmoothTo(newX, newY);
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    public Control getControl() {
        return this.canvas;
    }
}

