/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.editor.outline;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.label.StylerFactory;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xtext.UsedRulesFinder;
import org.eclipse.xtext.xtext.ui.editor.outline.RuleNode;
import org.eclipse.xtext.xtext.ui.editor.syntaxcoloring.SemanticHighlightingConfiguration;

public class XtextOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    private static final String ALIAS_TYPE_SEPARATOR = "::";
    public static final String NAME_TYPE_SEPARATOR = " - ";
    @Inject
    private SemanticHighlightingConfiguration semanticHighlightingConfiguration;
    @Inject
    private StylerFactory stylerFactory;
    private Set<AbstractRule> calledRules = Sets.newHashSet();

    protected Object _text(AbstractRule rule) {
        StyledString ruleText = null;
        ruleText = !this.calledRules.isEmpty() && !this.calledRules.contains(rule) ? new StyledString(this.safeName(rule.getName()), this.stylerFactory.createXtextStyleAdapterStyler(this.semanticHighlightingConfiguration.unusedRule())) : (GrammarUtil.isDatatypeRule((AbstractRule)rule) ? new StyledString(this.safeName(rule.getName()), this.stylerFactory.createXtextStyleAdapterStyler(this.semanticHighlightingConfiguration.dataTypeRule())) : new StyledString(this.safeName(rule.getName())));
        return ruleText;
    }

    protected StyledString getReturnTypeText(AbstractRule rule) {
        StringBuilder typeName = new StringBuilder(NAME_TYPE_SEPARATOR);
        if (rule.getType() != null && rule.getType().getClassifier() != null) {
            String alias = rule.getType().getMetamodel().getAlias();
            if (alias != null) {
                typeName.append(alias);
                typeName.append(ALIAS_TYPE_SEPARATOR);
            }
            typeName.append(this.safeName(rule.getType().getClassifier().getName()));
        } else {
            typeName.append(this.safeName(rule.getName()));
        }
        StyledString styledType = new StyledString(typeName.toString(), this.stylerFactory.createXtextStyleAdapterStyler(this.semanticHighlightingConfiguration.typeReference()));
        return styledType;
    }

    protected void _createNode(IOutlineNode parentNode, Grammar grammar) {
        this.calledRules = Sets.newHashSet();
        if (!grammar.getRules().isEmpty()) {
            UsedRulesFinder usedRulesFinder = new UsedRulesFinder(this.calledRules);
            usedRulesFinder.compute(grammar);
        }
        super._createNode(parentNode, (EObject)grammar);
    }

    protected void _createNode(IOutlineNode parentNode, AbstractRule rule) {
        StyledString text = (StyledString)this.textDispatcher.invoke(new Object[]{rule});
        Image image = (Image)this.imageDispatcher.invoke(new Object[]{rule});
        RuleNode ruleNode = new RuleNode((EObject)rule, parentNode, image, text, (Boolean)this.isLeafDispatcher.invoke(new Object[]{rule}));
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)rule);
        if (parserNode != null) {
            ruleNode.setTextRegion((ITextRegion)new TextRegion(parserNode.getOffset(), parserNode.getLength()));
        }
        ruleNode.setShortTextRegion(this.locationInFileProvider.getSignificantTextRegion((EObject)rule));
        ruleNode.setFullText(new StyledString().append(text).append(this.getReturnTypeText(rule)));
    }

    protected void _createChildren(IOutlineNode parentNode, Grammar grammar) {
        for (AbstractMetamodelDeclaration metamodelDeclaration : grammar.getMetamodelDeclarations()) {
            this.createNode(parentNode, (EObject)metamodelDeclaration);
        }
        for (AbstractRule rule : grammar.getRules()) {
            this.createNode(parentNode, (EObject)rule);
        }
    }

    protected boolean _isLeaf(AbstractRule rule) {
        return true;
    }

    protected String safeName(String s) {
        return s == null ? "<unnamed>" : s;
    }
}

