/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocationInFileProvider
implements ILocationInFileProvider {
    @Override
    public ITextRegion getSignificantTextRegion(EObject obj) {
        return this.getTextRegion(obj, true);
    }

    @Override
    public ITextRegion getFullTextRegion(EObject obj) {
        return this.getTextRegion(obj, false);
    }

    protected ITextRegion getTextRegion(EObject obj, boolean isSignificant) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor(obj);
        if (node == null) {
            if (obj.eContainer() == null) {
                return ITextRegion.EMPTY_REGION;
            }
            return this.getTextRegion(obj.eContainer(), isSignificant);
        }
        List<INode> nodes = null;
        if (isSignificant) {
            nodes = this.getLocationNodes(obj);
        }
        if (nodes == null || nodes.isEmpty()) {
            nodes = Collections.singletonList(node);
        }
        return this.createRegion(nodes);
    }

    @Override
    public ITextRegion getSignificantTextRegion(EObject owner, EStructuralFeature feature, int indexInList) {
        return this.getTextRegion(owner, feature, indexInList, true);
    }

    @Override
    public ITextRegion getFullTextRegion(EObject owner, EStructuralFeature feature, int indexInList) {
        return this.getTextRegion(owner, feature, indexInList, false);
    }

    private ITextRegion getTextRegion(final EObject owner, EStructuralFeature feature, final int indexInList, final boolean isSignificant) {
        return (ITextRegion)new EcoreSwitch<ITextRegion>(){

            public ITextRegion caseEAttribute(EAttribute feature) {
                return DefaultLocationInFileProvider.this.getLocationOfAttribute(owner, feature, indexInList, isSignificant);
            }

            public ITextRegion caseEReference(EReference feature) {
                if (feature.isContainment() || feature.isContainer()) {
                    return DefaultLocationInFileProvider.this.getLocationOfContainmentReference(owner, feature, indexInList, isSignificant);
                }
                return DefaultLocationInFileProvider.this.getLocationOfCrossReference(owner, feature, indexInList, isSignificant);
            }
        }.doSwitch((EObject)feature);
    }

    protected ITextRegion getLocationOfContainmentReference(EObject owner, EReference feature, int indexInList, boolean isSignificant) {
        List values;
        Object referencedElement = null;
        referencedElement = feature.isMany() ? (indexInList >= (values = (List)owner.eGet((EStructuralFeature)feature)).size() ? owner : values.get(indexInList)) : owner.eGet((EStructuralFeature)feature);
        return this.getTextRegion((EObject)referencedElement, isSignificant);
    }

    protected ITextRegion getLocationOfCrossReference(EObject owner, EReference reference, int indexInList, boolean isSignificant) {
        return this.doGetLocationOfFeature(owner, (EStructuralFeature)reference, indexInList, isSignificant);
    }

    protected ITextRegion getLocationOfAttribute(EObject owner, EAttribute attribute, int indexInList, boolean isSignificant) {
        return this.doGetLocationOfFeature(owner, (EStructuralFeature)attribute, indexInList, isSignificant);
    }

    protected ITextRegion doGetLocationOfFeature(EObject owner, EStructuralFeature feature, int indexInList, boolean isSignificant) {
        if (!feature.isMany()) {
            indexInList = 0;
        }
        if (indexInList >= 0) {
            List<INode> findNodesForFeature = NodeModelUtils.findNodesForFeature(owner, feature);
            if (indexInList < findNodesForFeature.size()) {
                INode node = findNodesForFeature.get(indexInList);
                return new TextRegion(node.getOffset(), node.getLength());
            }
            return this.getTextRegion(owner, isSignificant);
        }
        return null;
    }

    protected List<INode> getLocationNodes(EObject obj) {
        EStructuralFeature nameFeature = this.getIdentifierFeature(obj);
        if (nameFeature != null) {
            return NodeModelUtils.findNodesForFeature(obj, nameFeature);
        }
        ArrayList resultNodes = Lists.newArrayList();
        ICompositeNode startNode = NodeModelUtils.getNode(obj);
        INode keywordNode = null;
        for (INode child : startNode.getChildren()) {
            EObject grammarElement = child.getGrammarElement();
            if (grammarElement instanceof RuleCall) {
                RuleCall ruleCall = (RuleCall)grammarElement;
                String ruleName = ruleCall.getRule().getName();
                if (!ruleName.equals("ID")) continue;
                resultNodes.add(child);
                continue;
            }
            if (!(grammarElement instanceof Keyword) || keywordNode != null || !this.useKeyword((Keyword)grammarElement, obj)) continue;
            keywordNode = child;
        }
        if (resultNodes.isEmpty() && keywordNode != null) {
            resultNodes.add(keywordNode);
        }
        return resultNodes;
    }

    protected boolean useKeyword(Keyword keyword, EObject context) {
        return true;
    }

    protected EStructuralFeature getIdentifierFeature(EObject obj) {
        EClass eClass = obj.eClass();
        EStructuralFeature result = eClass.getEStructuralFeature("name");
        return result != null ? result : eClass.getEStructuralFeature("id");
    }

    protected ITextRegion createRegion(List<INode> nodes) {
        ITextRegion result = ITextRegion.EMPTY_REGION;
        for (INode node : nodes) {
            if (this.isHidden(node)) continue;
            result = result.merge((ITextRegion)new TextRegion(node.getOffset(), node.getLength()));
        }
        return result;
    }

    protected boolean isHidden(INode node) {
        return node instanceof ILeafNode && ((ILeafNode)node).isHidden();
    }
}

