/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.internal.Join;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NfaToGrammar {
    protected <T> void collectStates(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return;
        }
        for (StateAlias<T> out : state.getOutgoing()) {
            this.collectStates(out, visited);
        }
    }

    protected <T> boolean createAlternative(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        HashMultimap alternative = HashMultimap.create();
        for (StateAlias<T> stateAlias : state.getOutgoing()) {
            if (stateAlias.getOutgoing().size() != 1 || stateAlias.getIncoming().size() != 1) continue;
            for (StateAlias<T> candidate2 : state.getOutgoing()) {
                if (candidate2.getOutgoing().size() != 1 || candidate2.getIncoming().size() != 1) continue;
                for (StateAlias stateAlias2 : stateAlias.getOutgoing()) {
                    if (stateAlias == candidate2 || !candidate2.getOutgoing().contains(stateAlias2)) continue;
                    alternative.put((Object)stateAlias2, stateAlias);
                    alternative.put((Object)stateAlias2, candidate2);
                }
            }
        }
        for (StateAlias<Object> stateAlias : alternative.keySet()) {
            ALternativeAlias alt = new ALternativeAlias();
            StateAlias altState = new StateAlias(alt);
            for (StateAlias stateAlias3 : alternative.get(stateAlias)) {
                alt.addChild(stateAlias3.getElement());
                state.getOutgoing().remove(stateAlias3);
                stateAlias.getIncoming().remove(stateAlias3);
            }
            altState.getIncoming().add(state);
            altState.getOutgoing().add(stateAlias);
            state.getOutgoing().add(altState);
            stateAlias.getIncoming().add(altState);
            created = true;
        }
        for (StateAlias<Object> stateAlias : state.getOutgoing()) {
            if (!this.createAlternative(stateAlias, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> boolean createCycle(StateAlias<T> state, Set<StateAlias<T>> visited) {
        StateAlias<T> center;
        if (!visited.add(state)) {
            return false;
        }
        if (state.getOutgoing().size() == 1 && state.getIncoming().size() == 1 && (center = state.getOutgoing().iterator().next()) != state && center == state.getIncoming().iterator().next()) {
            GroupAlias<T> cycle = new GroupAlias<T>();
            cycle.addChild(state.getElement());
            cycle.addChild(center.getElement());
            cycle.setMany(true);
            cycle.setOptional(true);
            GroupAlias<T> group = new GroupAlias<T>();
            group.addChild(center.getElement());
            group.addChild(cycle);
            center.element = group;
            center.getOutgoing().remove(state);
            center.getIncoming().remove(state);
            return true;
        }
        boolean created = false;
        for (StateAlias out : Lists.newArrayList(state.getOutgoing())) {
            if (!this.createCycle(out, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> void createGroup(StateAlias<T> first, StateAlias<T> second) {
        GroupAlias<T> group = new GroupAlias<T>();
        if (first.getElement() instanceof GroupAlias && first.getElement().isOne()) {
            group.getChildren().addAll(((GroupAlias)first.getElement()).getChildren());
        } else {
            group.addChild(first.getElement());
        }
        if (second.getElement() instanceof GroupAlias && second.getElement().isOne()) {
            group.getChildren().addAll(((GroupAlias)second.getElement()).getChildren());
        } else {
            group.addChild(second.getElement());
        }
        first.element = group;
        first.getOutgoing().clear();
        first.absorbOutgoing(second);
    }

    protected <T> boolean createGroups(StateAlias<T> state, Set<StateAlias<T>> visited) {
        StateAlias<T> follower;
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        if (state.getOutgoing().size() == 1 && state.getOutgoing().iterator().next().getIncoming().size() == 1 && state != (follower = state.getOutgoing().iterator().next())) {
            this.createGroup(state, follower);
            created = true;
        }
        for (StateAlias<T> out : state.getOutgoing()) {
            if (!this.createGroups(out, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> boolean createMany(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        if (state.getOutgoing().contains(state)) {
            state.getElement().setMany(true);
            state.getOutgoing().remove(state);
            state.getIncoming().remove(state);
            created = true;
        }
        for (StateAlias<T> out : state.getOutgoing()) {
            if (!this.createMany(out, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> boolean createOptional(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        HashMultimap optional = HashMultimap.create();
        for (StateAlias<T> stateAlias : state.getOutgoing()) {
            if (stateAlias.getOutgoing().size() != 1 || stateAlias.getIncoming().size() != 1) continue;
            for (StateAlias stateAlias2 : stateAlias.getOutgoing()) {
                if (stateAlias == stateAlias2 || !state.getOutgoing().contains(stateAlias2)) continue;
                optional.put((Object)stateAlias2, stateAlias);
            }
        }
        for (StateAlias<Object> stateAlias : optional.keySet()) {
            for (StateAlias stateAlias3 : optional.get(stateAlias)) {
                stateAlias3.getElement().setOptional(true);
            }
            state.getOutgoing().remove(stateAlias);
            stateAlias.getIncoming().remove(state);
            created = true;
        }
        for (StateAlias<Object> stateAlias : state.getOutgoing()) {
            if (!this.createOptional(stateAlias, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> Set<StateAlias<T>> getAllStates(StateAlias<T> state) {
        HashSet visited = Sets.newHashSet();
        this.collectStates(state, visited);
        return visited;
    }

    public <T> AbstractElementAlias<T> nfaToGtammar(T startT, T stopT, Function<T, Iterable<T>> followers) {
        StateAlias<T> stop = new StateAlias<T>(new ElementAlias<T>(stopT));
        StateAlias<T> start = this.toAlias(startT, stop, followers, Maps.newHashMap());
        boolean changed = true;
        while (!start.getOutgoing().isEmpty() && changed) {
            changed = this.createMany(start, Sets.newHashSet());
            changed |= this.createGroups(start, Sets.newHashSet());
            changed |= this.createAlternative(start, Sets.newHashSet());
            changed |= this.createOptional(start, Sets.newHashSet());
            changed |= this.createCycle(start, Sets.newHashSet());
        }
        return start.getElement();
    }

    protected <T> StateAlias<T> toAlias(T state, StateAlias<T> stop, Function<T, Iterable<T>> followers, Map<T, StateAlias<T>> cache) {
        StateAlias<T> result = cache.get(state);
        if (result != null) {
            return result;
        }
        result = new StateAlias<T>(new ElementAlias<T>(state));
        cache.put(state, result);
        for (Object follower : (Iterable)followers.apply(state)) {
            StateAlias followerState = this.toAlias(follower, stop, followers, cache);
            result.getOutgoing().add(followerState);
            followerState.getIncoming().add(result);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ALternativeAlias<T>
    extends AbstractElementAlias<T> {
        protected Set<AbstractElementAlias<T>> children = Sets.newHashSet();

        public void addChild(AbstractElementAlias<T> child) {
            if (child == this) {
                throw new RuntimeException();
            }
            this.children.add(child);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ALternativeAlias other = (ALternativeAlias)obj;
            return this.children.equals(other.children) && this.many == other.many && this.optional == other.optional;
        }

        public Set<AbstractElementAlias<T>> getChildren() {
            return this.children;
        }

        public int hashCode() {
            int result = this.children.hashCode();
            if (this.many) {
                result *= 3;
            }
            if (this.optional) {
                result *= 7;
            }
            return result;
        }

        @Override
        public String toString(boolean isNested) {
            ArrayList result = Lists.newArrayList();
            for (AbstractElementAlias<T> child : this.children) {
                result.add(child.toString(true));
            }
            Collections.sort(result);
            String body = Join.join((String)" | ", (Iterable)result);
            if (this.isOne() && !isNested) {
                return body;
            }
            return "(" + body + ")" + this.getCardinality();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractElementAlias<T> {
        protected boolean many = false;
        protected boolean optional = false;

        protected AbstractElementAlias() {
        }

        protected AbstractElementAlias(boolean optional, boolean many) {
            this.optional = optional;
            this.many = many;
        }

        public String getCardinality() {
            if (this.optional && this.many) {
                return "*";
            }
            if (this.many) {
                return "+";
            }
            if (this.optional) {
                return "?";
            }
            return "";
        }

        public boolean isMany() {
            return this.many;
        }

        public boolean isOne() {
            return !this.optional && !this.many;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setMany(boolean many) {
            this.many = many;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public String toString() {
            return this.toString(false);
        }

        public abstract String toString(boolean var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ElementAlias<T>
    extends AbstractElementAlias<T> {
        protected T element;

        public ElementAlias(boolean optional, boolean many, T element) {
            super(optional, many);
            this.element = element;
        }

        public ElementAlias(T element) {
            this.element = element;
        }

        public boolean equals(Object obj) {
            T e2;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ElementAlias other = (ElementAlias)obj;
            if (this.many != other.many || this.optional != other.optional) {
                return false;
            }
            T e1 = this.element instanceof ISyntacticSequencerPDAProvider.ISynState ? ((ISyntacticSequencerPDAProvider.ISynState)this.element).getGrammarElement() : this.element;
            Object object = e2 = other.element instanceof ISyntacticSequencerPDAProvider.ISynState ? ((ISyntacticSequencerPDAProvider.ISynState)other.element).getGrammarElement() : other.element;
            return e1 == e2;
        }

        public T getElement() {
            return this.element;
        }

        public int hashCode() {
            int result;
            int n = result = this.element instanceof ISyntacticSequencerPDAProvider.ISynState ? ((ISyntacticSequencerPDAProvider.ISynState)this.element).getGrammarElement().hashCode() : this.element.hashCode();
            if (this.many) {
                result *= 3;
            }
            if (this.optional) {
                result *= 7;
            }
            return result;
        }

        @Override
        public String toString(boolean isNested) {
            return String.valueOf(this.element.toString()) + this.getCardinality();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GroupAlias<T>
    extends AbstractElementAlias<T> {
        protected List<AbstractElementAlias<T>> children = Lists.newArrayList();

        public GroupAlias() {
        }

        public GroupAlias(boolean optional, boolean many, AbstractElementAlias<T> ... children) {
            super(optional, many);
            Collections.addAll(this.children, children);
        }

        public void addChild(AbstractElementAlias<T> child) {
            if (child == this) {
                throw new RuntimeException();
            }
            this.children.add(child);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupAlias other = (GroupAlias)obj;
            return this.children.equals(other.children) && this.many == other.many && this.optional == other.optional;
        }

        public List<AbstractElementAlias<T>> getChildren() {
            return this.children;
        }

        public int hashCode() {
            int result = this.children.hashCode();
            if (this.many) {
                result *= 3;
            }
            if (this.optional) {
                result *= 7;
            }
            return result;
        }

        @Override
        public String toString(boolean isNested) {
            ArrayList result = Lists.newArrayList();
            for (AbstractElementAlias<T> child : this.children) {
                result.add(child.toString(true));
            }
            String body = Join.join((String)" ", (Iterable)result);
            if (this.isOne() && !isNested) {
                return body;
            }
            return "(" + body + ")" + this.getCardinality();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StateAlias<T> {
        protected AbstractElementAlias<T> element;
        protected Set<StateAlias<T>> incoming = Sets.newHashSet();
        protected Set<StateAlias<T>> outgoing = Sets.newHashSet();

        protected StateAlias(AbstractElementAlias<T> element) {
            this.element = element;
        }

        public void absorbIncoming(StateAlias<T> state) {
            for (StateAlias<T> in : state.incoming) {
                in.outgoing.remove(state);
                in.outgoing.add(this);
                this.incoming.add(in);
            }
        }

        public void absorbOutgoing(StateAlias<T> state) {
            for (StateAlias<T> out : state.outgoing) {
                out.incoming.remove(state);
                out.incoming.add(this);
                this.outgoing.add(out);
            }
        }

        public void addOutgoing(StateAlias<T> state) {
            this.outgoing.add(state);
            state.incoming.add(this);
        }

        protected AbstractElementAlias<T> getElement() {
            return this.element;
        }

        protected Set<StateAlias<T>> getIncoming() {
            return this.incoming;
        }

        protected Set<StateAlias<T>> getOutgoing() {
            return this.outgoing;
        }

        public String toString() {
            return "S(" + this.element + ")";
        }
    }
}

