/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.grammaranalysis.IGrammarNFAProvider;
import org.eclipse.xtext.grammaranalysis.INFAState;
import org.eclipse.xtext.grammaranalysis.INFATransition;
import org.eclipse.xtext.grammaranalysis.IPDAState;
import org.eclipse.xtext.grammaranalysis.impl.AbstractCachingNFABuilder;
import org.eclipse.xtext.grammaranalysis.impl.AbstractNFAProvider;
import org.eclipse.xtext.grammaranalysis.impl.AbstractNFAState;
import org.eclipse.xtext.grammaranalysis.impl.AbstractNFATransition;
import org.eclipse.xtext.grammaranalysis.impl.AbstractPDAProvider;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementFullTitleSwitch;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.analysis.NfaToGrammar;
import org.eclipse.xtext.serializer.sequencer.RuleCallStack;
import org.eclipse.xtext.util.LinkedStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SyntacticSequencerPDAProvider
implements ISyntacticSequencerPDAProvider {
    protected Map<SequencerPDAContext, ISyntacticSequencerPDAProvider.ISynAbsorberState> cache = Maps.newHashMap();
    protected SequencerPDAProvider pdaProvider = this.createSequencerPDAProvider();

    protected boolean canReachAbsorber(IPDAState from, IPDAState to, Set<IPDAState> visited) {
        if (this.isMandatoryAbsorber(from.getGrammarElement()) || !visited.add(from)) {
            return false;
        }
        for (IPDAState follower : from.getFollowers()) {
            if (follower == to) {
                return true;
            }
            if (!this.canReachAbsorber(follower, to, visited)) continue;
            return true;
        }
        return false;
    }

    protected void collectFollowingAbsorberStates(IPDAState state, boolean collect, Set<IPDAState> visited, Set<IPDAState> absorber) {
        if (collect) {
            if (!visited.add(state)) {
                return;
            }
            if (this.isMandatoryAbsorber(state.getGrammarElement()) || state.getType() == IPDAState.PDAStateType.STOP) {
                absorber.add(state);
                return;
            }
            if (this.isOptionalAbsorber(state.getGrammarElement())) {
                absorber.add(state);
            }
        }
        for (IPDAState follower : state.getFollowers()) {
            this.collectFollowingAbsorberStates(follower, true, visited, absorber);
        }
    }

    protected SynAbsorberState createAbsorberState(IPDAState state, Map<IPDAState, SynAbsorberState> absorbers, Map<SynAbsorberState, Map<IPDAState, SynState>> emitters, EObject context, EClass eClass) {
        SynAbsorberState result = absorbers.get(state);
        if (result != null) {
            return result;
        }
        if (state.getType() == IPDAState.PDAStateType.STOP) {
            result = this.createAbsorberState(ISyntacticSequencerPDAProvider.SynStateType.STOP, null, context, eClass);
            absorbers.put(state, result);
            return result;
        }
        result = this.createAbsorberState(this.getType(state), state.getGrammarElement(), context, eClass);
        absorbers.put(state, result);
        HashSet followers = Sets.newHashSet();
        this.collectFollowingAbsorberStates(state, false, Sets.newHashSet(), followers);
        for (IPDAState follower : followers) {
            SynAbsorberState target = this.createAbsorberState(follower, absorbers, emitters, context, eClass);
            SynTransition transition = this.createTransition(result, target);
            HashMap emitter = emitters.get(target);
            if (emitter == null) {
                emitter = Maps.newHashMap();
                emitters.put(target, emitter);
            }
            transition.setFollowers(this.createEmitterStates(state, follower, target, emitter));
            result.addTransition(transition);
        }
        return result;
    }

    protected SynAbsorberState createAbsorberState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, EObject context, EClass eClass) {
        return new SynAbsorberState(type, element, context, eClass);
    }

    protected SynState createEmitterState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, SynAbsorberState target) {
        return new SynEmitterState(type, element, target);
    }

    protected List<ISyntacticSequencerPDAProvider.ISynState> createEmitterStates(IPDAState from, IPDAState to, SynAbsorberState target, Map<IPDAState, SynState> emitters) {
        ArrayList result = Lists.newArrayList();
        for (IPDAState next : from.getFollowers()) {
            if (next == to) {
                result.add(target);
                continue;
            }
            if (!this.canReachAbsorber(next, to, Sets.newHashSet())) continue;
            SynState emitter = emitters.get(next);
            if (emitter == null) {
                emitter = this.createEmitterState(this.getType(next), next.getGrammarElement(), target);
                emitters.put(next, emitter);
                emitter.setFollowers(this.createEmitterStates(next, to, target, emitters));
            }
            result.add(emitter);
        }
        return result;
    }

    protected SequencerNFAProvider createSequenceParserNFAProvider() {
        return new SequencerNFAProvider();
    }

    protected SequencerPDAProvider createSequencerPDAProvider() {
        return new SequencerPDAProvider(this.createSequenceParserNFAProvider());
    }

    protected SynTransition createTransition(SynAbsorberState source, SynAbsorberState target) {
        return new SynTransition(source, target);
    }

    @Override
    public ISyntacticSequencerPDAProvider.ISynAbsorberState getPDA(EObject context, EClass type) {
        SequencerPDAContext ctx = new SequencerPDAContext(context, type);
        ISyntacticSequencerPDAProvider.ISynAbsorberState result = this.cache.get(context);
        if (result == null) {
            HashMap absorbers = Maps.newHashMap();
            HashMap emitters = Maps.newHashMap();
            result = this.createAbsorberState(this.pdaProvider.getPDA(ctx), absorbers, emitters, context, type);
            this.cache.put(ctx, result);
        }
        return result;
    }

    protected ISyntacticSequencerPDAProvider.SynStateType getType(IPDAState state) {
        switch (state.getType()) {
            case ELEMENT: {
                AbstractElement ele = state.getGrammarElement();
                if (ele instanceof Action) {
                    if (((Action)ele).getFeature() == null) {
                        return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGEND_ACTION_CALL;
                    }
                    return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_ACTION_CALL;
                }
                if (GrammarUtil.containingCrossReference(ele) != null) {
                    if (ele instanceof RuleCall) {
                        RuleCall rc = (RuleCall)ele;
                        if (rc.getRule() instanceof ParserRule) {
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_DATATYPE_RULE_CALL;
                        }
                        if (rc.getRule() instanceof TerminalRule) {
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_TERMINAL_RULE_CALL;
                        }
                        if (!(rc.getRule() instanceof EnumRule)) break;
                        return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_ENUM_RULE_CALL;
                    }
                    if (!(ele instanceof Keyword)) break;
                    return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_KEYWORD;
                }
                Assignment ass = GrammarUtil.containingAssignment(ele);
                if (ass != null) {
                    if (ele instanceof RuleCall) {
                        RuleCall rc = (RuleCall)ele;
                        if (rc.getRule() instanceof ParserRule) {
                            if (rc.getRule().getType().getClassifier() instanceof EClass) {
                                return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_PARSER_RULE_CALL;
                            }
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_DATATYPE_RULE_CALL;
                        }
                        if (rc.getRule() instanceof TerminalRule) {
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_TERMINAL_RULE_CALL;
                        }
                        if (!(rc.getRule() instanceof EnumRule)) break;
                        return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_ENUM_RULE_CALL;
                    }
                    if (!(ele instanceof Keyword)) break;
                    if (GrammarUtil.isBooleanAssignment(ass)) {
                        return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_BOOLEAN_KEYWORD;
                    }
                    return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_KEYWORD;
                }
                if (ele instanceof RuleCall) {
                    RuleCall rc = (RuleCall)ele;
                    if (rc.getRule() instanceof ParserRule) {
                        return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_DATATYPE_RULE_CALL;
                    }
                    if (!(rc.getRule() instanceof TerminalRule)) break;
                    return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_TERMINAL_RULE_CALL;
                }
                if (!(ele instanceof Keyword)) break;
                return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGEND_KEYWORD;
            }
            case RULECALL_ENTER: {
                return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_ENTER;
            }
            case RULECALL_EXIT: {
                return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_EXIT;
            }
            case START: {
                return ISyntacticSequencerPDAProvider.SynStateType.START;
            }
            case STOP: {
                return ISyntacticSequencerPDAProvider.SynStateType.STOP;
            }
        }
        throw new RuntimeException("no type found for " + state);
    }

    protected boolean isMandatoryAbsorber(AbstractElement ele) {
        if (ele == null) {
            return true;
        }
        if (GrammarUtil.isAssigned(ele)) {
            return true;
        }
        return GrammarUtil.isAssignedAction(ele);
    }

    protected boolean isOptionalAbsorber(AbstractElement ele) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequencerNFAProvider
    extends AbstractNFAProvider<SequencerNFAState, SequencerNFATransition> {
        @Override
        protected IGrammarNFAProvider.NFABuilder<SequencerNFAState, SequencerNFATransition> createBuilder() {
            return new SequencerNFABuilder();
        }

        public IGrammarNFAProvider.NFABuilder<SequencerNFAState, SequencerNFATransition> getBuilder() {
            return this.builder;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SequencerNFABuilder
        extends AbstractCachingNFABuilder<SequencerNFAState, SequencerNFATransition> {
            @Override
            public SequencerNFAState createState(AbstractElement ele) {
                return new SequencerNFAState(ele, this);
            }

            @Override
            protected SequencerNFATransition createTransition(SequencerNFAState source, SequencerNFAState target, boolean isRuleCall, AbstractElement loopCenter) {
                return new SequencerNFATransition(source, target, isRuleCall, loopCenter);
            }

            @Override
            public boolean filter(AbstractElement ele) {
                if (ele instanceof CompoundElement) {
                    return true;
                }
                if (ele instanceof Assignment) {
                    return true;
                }
                return ele instanceof CrossReference;
            }

            @Override
            public IGrammarNFAProvider.NFADirection getDirection() {
                return IGrammarNFAProvider.NFADirection.FORWARD;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequencerNFAState
    extends AbstractNFAState<SequencerNFAState, SequencerNFATransition> {
        public SequencerNFAState(AbstractElement element, IGrammarNFAProvider.NFABuilder<SequencerNFAState, SequencerNFATransition> builder) {
            super(element, builder);
        }

        public List<SequencerNFATransition> collectOutgoingTransitions() {
            this.outgoing = Lists.newArrayList();
            this.outgoingRuleCalls = Lists.newArrayList();
            this.collectOutgoing(this.element, Sets.newHashSet(), false, null);
            this.removeDuplicates(this.outgoing);
            this.removeDuplicates(this.outgoingRuleCalls);
            return this.outgoingRuleCalls.isEmpty() ? this.outgoing : this.outgoingRuleCalls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequencerNFATransition
    extends AbstractNFATransition<SequencerNFAState, SequencerNFATransition> {
        public SequencerNFATransition(SequencerNFAState source, SequencerNFAState target, boolean ruleCall, AbstractElement loopCenter) {
            super(source, target, ruleCall, loopCenter);
        }
    }

    public static class SequencerPDAContext {
        protected EObject context;
        protected EClass type;

        public SequencerPDAContext(EObject context, EClass type) {
            this.context = context;
            this.type = type;
        }

        public int hashCode() {
            return this.context.hashCode() + (this.type == null ? 0 : this.type.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SequencerPDAContext other = (SequencerPDAContext)obj;
            return this.context == other.context && this.type == other.type;
        }

        public EObject getContext() {
            return this.context;
        }

        public EClass getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequencerPDAProvider
    extends AbstractPDAProvider<SequencerPDAContext> {
        protected SequencerNFAProvider nfaProvider;

        public SequencerPDAProvider(SequencerNFAProvider nfaProvider) {
            this.nfaProvider = nfaProvider;
        }

        @Override
        protected boolean canEnterRuleCall(INFAState<?, ?> state) {
            if (!(state.getGrammarElement() instanceof RuleCall)) {
                return false;
            }
            RuleCall rc = (RuleCall)state.getGrammarElement();
            if (!(rc.getRule() instanceof ParserRule) || !(rc.getRule().getType().getClassifier() instanceof EClass)) {
                return false;
            }
            return GrammarUtil.containingAssignment(rc) == null;
        }

        protected boolean canReachElement(INFAState<?, ?> from, AbstractElement to, Set<Object> visited) {
            if (!visited.add(from)) {
                return false;
            }
            if (from.getGrammarElement() == to) {
                return true;
            }
            for (INFATransition trans : from.getAllOutgoing()) {
                if (trans.isRuleCall() || !this.canReachElement((INFAState<?, ?>)trans.getTarget(), to, visited)) continue;
                return true;
            }
            return false;
        }

        protected boolean canReachEndState(INFAState<?, ?> from, Set<Object> visited) {
            if (!visited.add(from)) {
                return false;
            }
            if (from.isEndState()) {
                return true;
            }
            for (INFATransition trans : from.getAllOutgoing()) {
                if (trans.isRuleCall() || !this.canReachEndState((INFAState<?, ?>)trans.getTarget(), visited)) continue;
                return true;
            }
            return false;
        }

        protected List<INFAState<?, ?>> getActionStartFollowers(Action action) {
            ParserRule rule = GrammarUtil.containingParserRule(action);
            ArrayList result = Lists.newArrayList();
            for (INFAState<?, ?> state : this.getAllRuleStartFollowers(rule)) {
                if (!this.canReachElement(state, action, Sets.newHashSet())) continue;
                result.add(state);
            }
            return result;
        }

        protected List<INFAState<?, ?>> getAllRuleStartFollowers(ParserRule pr) {
            SequencerNFAState startNfa = (SequencerNFAState)this.nfaProvider.getNFA(pr.getAlternatives());
            ArrayList result = Lists.newArrayList();
            if (this.nfaProvider.getBuilder().filter(pr.getAlternatives())) {
                for (SequencerNFATransition transition : startNfa.collectOutgoingTransitions()) {
                    result.add(transition.getTarget());
                }
            } else {
                result.add(startNfa);
            }
            for (Action a : GrammarUtil.containedActions(pr)) {
                if (!GrammarUtil.isAssignedAction(a)) continue;
                result.add((INFAState)this.nfaProvider.getNFA(a));
            }
            return result;
        }

        @Override
        protected List<INFAState<?, ?>> getFollowers(SequencerPDAContext context, INFAState<?, ?> state, boolean returning, boolean canReturn) {
            ArrayList result = Lists.newArrayList();
            for (INFATransition transition : returning ? state.getOutgoingAfterReturn() : state.getOutgoing()) {
                if (!GrammarUtil.isAssignedAction(((INFAState)transition.getTarget()).getGrammarElement())) {
                    result.add(transition.getTarget());
                }
                if (!transition.isRuleCall()) continue;
                for (Action action : GrammarUtil.containedActions(GrammarUtil.containingRule(((INFAState)transition.getTarget()).getGrammarElement()))) {
                    if (!GrammarUtil.isAssignedAction(action)) continue;
                    result.add((INFAState)this.nfaProvider.getNFA(action));
                }
            }
            return result;
        }

        protected List<INFAState<?, ?>> getParserRuleStartFollowers(ParserRule rule) {
            ArrayList result = Lists.newArrayList();
            for (INFAState<?, ?> state : this.getAllRuleStartFollowers(rule)) {
                if (!this.canReachEndState(state, Sets.newHashSet())) continue;
                result.add(state);
            }
            return result;
        }

        @Override
        protected List<INFAState<?, ?>> getStartFollowers(SequencerPDAContext context) {
            if (context.getContext() instanceof ParserRule) {
                return this.getParserRuleStartFollowers((ParserRule)context.getContext());
            }
            if (context.getContext() instanceof Action) {
                return this.getActionStartFollowers((Action)context.getContext());
            }
            return Collections.emptyList();
        }

        @Override
        protected boolean isFinalState(SequencerPDAContext context, INFAState<?, ?> state, boolean returning, boolean canReturn) {
            if (context.getContext() instanceof Action) {
                for (INFATransition transition : returning ? state.getOutgoingAfterReturn() : state.getOutgoing()) {
                    if (((INFAState)transition.getTarget()).getGrammarElement() != context.getContext()) continue;
                    return true;
                }
            } else if (canReturn && context.getContext() instanceof ParserRule && state.isEndState() && GrammarUtil.containingParserRule(state.getGrammarElement()) == context.getContext()) {
                return true;
            }
            return false;
        }

        @Override
        protected boolean canPass(SequencerPDAContext context, INFAState<?, ?> state, EClass constructedType) {
            AbstractElement ele = state.getGrammarElement();
            if (ele instanceof Action) {
                return ((Action)ele).getType().getClassifier() == context.getType();
            }
            if (constructedType != null) {
                return true;
            }
            if (GrammarUtil.containingAssignment(ele) != null) {
                return GrammarUtil.containingRule(ele).getType().getClassifier() == context.getType();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SynAbsorberState
    extends SynState
    implements ISyntacticSequencerPDAProvider.ISynAbsorberState {
        protected EObject context;
        protected EClass eClass;
        protected Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> outTransitionsByElement = Maps.newHashMap();
        protected Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> outTransitionsByRuleCallEnter = Maps.newHashMap();
        protected Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> outTransitionsByRuleCallExit = Maps.newHashMap();

        public SynAbsorberState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, EObject context, EClass eClass) {
            super(type, element);
            this.context = context;
            this.eClass = eClass;
        }

        protected void addTransition(ISyntacticSequencerPDAProvider.ISynTransition transition) {
            this.addFollower(transition.getFollowers());
            switch (transition.getTarget().getType().getSimpleType()) {
                case START: {
                    throw new UnsupportedOperationException("StartStates can not have incoming transitions");
                }
                case ELEMENT: 
                case STOP: {
                    if (this.outTransitionsByElement.isEmpty()) {
                        this.outTransitionsByElement = Maps.newHashMap();
                    }
                    this.outTransitionsByElement.put(transition.getTarget().getGrammarElement(), transition);
                    break;
                }
                case RULECALL_ENTER: {
                    if (this.outTransitionsByRuleCallEnter.isEmpty()) {
                        this.outTransitionsByRuleCallEnter = Maps.newHashMap();
                    }
                    this.outTransitionsByRuleCallEnter.put(transition.getTarget().getGrammarElement(), transition);
                    break;
                }
                case RULECALL_EXIT: {
                    if (this.outTransitionsByRuleCallExit.isEmpty()) {
                        this.outTransitionsByRuleCallExit = Maps.newHashMap();
                    }
                    this.outTransitionsByRuleCallExit.put(transition.getTarget().getGrammarElement(), transition);
                }
            }
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynTransition> getOutTransitions() {
            ArrayList result = Lists.newArrayList();
            result.addAll(this.outTransitionsByElement.values());
            result.addAll(this.outTransitionsByRuleCallEnter.values());
            result.addAll(this.outTransitionsByRuleCallExit.values());
            return result;
        }

        @Override
        public Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> getOutTransitionsByElement() {
            return this.outTransitionsByElement;
        }

        @Override
        public Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> getOutTransitionsByRuleCallEnter() {
            return this.outTransitionsByRuleCallEnter;
        }

        @Override
        public Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> getOutTransitionsByRuleCallExit() {
            return this.outTransitionsByRuleCallExit;
        }

        @Override
        public EClass getEClass() {
            return this.eClass;
        }

        @Override
        public EObject getContext() {
            return this.context;
        }
    }

    protected static class SynEmitterState
    extends SynNavigable
    implements ISyntacticSequencerPDAProvider.ISynEmitterState {
        public SynEmitterState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, SynAbsorberState target) {
            super(type, element, target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SynNavigable
    extends SynState
    implements ISyntacticSequencerPDAProvider.ISynNavigable {
        protected static final List<ISyntacticSequencerPDAProvider.ISynState> RULE_EXIT_DEPENDENT = Lists.newArrayList();
        protected static final int UNREACHABLE = Integer.MAX_VALUE;
        protected int distanceToAbsorber = -1;
        protected Boolean involvesRuleExit;
        protected Boolean involvesUnassignedTokenRuleCalls = null;
        protected List<ISyntacticSequencerPDAProvider.ISynState> shortestPathToAbsorber = null;
        protected Boolean syntacticallyAmbiguous = null;
        protected ISyntacticSequencerPDAProvider.ISynAbsorberState target;

        public SynNavigable(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, ISyntacticSequencerPDAProvider.ISynAbsorberState target) {
            super(type, element);
            this.target = target;
        }

        protected int distanceTo(ISyntacticSequencerPDAProvider.ISynState state, Predicate<ISyntacticSequencerPDAProvider.ISynState> matches, Predicate<ISyntacticSequencerPDAProvider.ISynState> bounds, RuleCallStack stack, LinkedStack<ISyntacticSequencerPDAProvider.ISynState> visited) {
            if (matches.apply((Object)state)) {
                return 0;
            }
            if (bounds.apply((Object)state)) {
                return Integer.MAX_VALUE;
            }
            if (visited.contains((Object)state)) {
                return Integer.MAX_VALUE;
            }
            visited = (LinkedStack)visited.cloneAndPush((Object)state);
            if (state.getType().isRuleCallExit()) {
                if (!stack.isEmpty()) {
                    if (stack.peek() != state.getGrammarElement()) {
                        return Integer.MAX_VALUE;
                    }
                    stack = (RuleCallStack)stack.cloneAndPop();
                }
            } else if (state.getType().isRuleCallEnter()) {
                stack = (RuleCallStack)stack.cloneAndPush((RuleCall)state.getGrammarElement());
            }
            int dist = Integer.MAX_VALUE;
            for (ISyntacticSequencerPDAProvider.ISynState follower : state.getFollowers()) {
                dist = Math.min(dist, this.distanceTo(follower, matches, bounds, stack, (LinkedStack<ISyntacticSequencerPDAProvider.ISynState>)visited));
            }
            if (dist != Integer.MAX_VALUE && state.getType() != ISyntacticSequencerPDAProvider.SynStateType.TRANSITION) {
                ++dist;
            }
            return dist;
        }

        @Override
        public int getDistanceTo(Predicate<ISyntacticSequencerPDAProvider.ISynState> matches, Predicate<ISyntacticSequencerPDAProvider.ISynState> bounds, RuleCallStack stack) {
            return this.distanceTo(this, matches, bounds, stack, (LinkedStack<ISyntacticSequencerPDAProvider.ISynState>)new LinkedStack());
        }

        @Override
        public int getDistanceWithStackToAbsorber(RuleCallStack stack) {
            if (this.involvesRuleExit().booleanValue()) {
                return this.getDistanceWithStackToElement(ISyntacticSequencerPDAProvider.SynPredicates.absorber(), stack);
            }
            if (this.distanceToAbsorber < 0) {
                this.distanceToAbsorber = this.getDistanceTo(ISyntacticSequencerPDAProvider.SynPredicates.absorber(), ISyntacticSequencerPDAProvider.SynPredicates.absorber(), stack);
            }
            return this.distanceToAbsorber;
        }

        public int getDistanceWithStackToElement(Predicate<ISyntacticSequencerPDAProvider.ISynState> matches, RuleCallStack stack) {
            int result = 0;
            if (this.involvesRuleExit().booleanValue()) {
                while (!stack.isEmpty()) {
                    int r = this.getDistanceTo(ISyntacticSequencerPDAProvider.SynPredicates.ruleCallExit((RuleCall)stack.peek()), ISyntacticSequencerPDAProvider.SynPredicates.ruleCallExits(), stack);
                    if (r == Integer.MAX_VALUE) break;
                    result += r;
                    stack = (RuleCallStack)stack.cloneAndPop();
                }
            }
            return result + this.getDistanceTo(matches, ISyntacticSequencerPDAProvider.SynPredicates.absorber(), stack);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestPathTo(AbstractElement ele, RuleCallStack stack, boolean addMatch) {
            return this.getShortestPathTo(ISyntacticSequencerPDAProvider.SynPredicates.emitter(ele), ISyntacticSequencerPDAProvider.SynPredicates.absorber(), stack, addMatch);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestPathTo(Predicate<ISyntacticSequencerPDAProvider.ISynState> matches, Predicate<ISyntacticSequencerPDAProvider.ISynState> bounds, RuleCallStack stack, boolean addMatch) {
            List<ISyntacticSequencerPDAProvider.ISynState> routes = this.getFollowers();
            ArrayList result = Lists.newArrayList();
            HashSet visited = Sets.newHashSet();
            while (true) {
                ISyntacticSequencerPDAProvider.ISynState next;
                if (routes.size() == 1) {
                    next = routes.get(0);
                    if (matches.apply((Object)next)) {
                        if (addMatch) {
                            result.add(next);
                        }
                        return result;
                    }
                    if (bounds.apply((Object)next)) {
                        return null;
                    }
                } else {
                    next = null;
                    int minDist = Integer.MAX_VALUE;
                    for (ISyntacticSequencerPDAProvider.ISynState follower : routes) {
                        ISyntacticSequencerPDAProvider.ISynEmitterState navFolower;
                        int dist;
                        if (matches.apply((Object)follower)) {
                            if (addMatch) {
                                result.add(follower);
                            }
                            return result;
                        }
                        if (bounds.apply((Object)follower) || !(follower instanceof ISyntacticSequencerPDAProvider.ISynEmitterState) || (dist = (navFolower = (ISyntacticSequencerPDAProvider.ISynEmitterState)follower).getDistanceTo(matches, bounds, stack)) >= minDist) continue;
                        next = follower;
                        minDist = dist;
                    }
                }
                if (next == null || next instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
                    return null;
                }
                if (next.getType().isRuleCallExit()) {
                    stack = (RuleCallStack)stack.cloneAndPop();
                } else if (next.getType().isRuleCallEnter()) {
                    stack = (RuleCallStack)stack.cloneAndPush((RuleCall)next.getGrammarElement());
                }
                routes = next.getFollowers();
                visited.add(next);
                result.add(next);
            }
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestPathToAbsorber(RuleCallStack stack) {
            if (this.involvesRuleExit().booleanValue()) {
                return this.getShortestPathToElement(ISyntacticSequencerPDAProvider.SynPredicates.absorber(), stack);
            }
            if (this.shortestPathToAbsorber == null) {
                this.shortestPathToAbsorber = this.getShortestPathTo(ISyntacticSequencerPDAProvider.SynPredicates.absorber(), ISyntacticSequencerPDAProvider.SynPredicates.absorber(), stack, false);
            }
            return this.shortestPathToAbsorber;
        }

        protected List<ISyntacticSequencerPDAProvider.ISynState> getShortestPathToElement(Predicate<ISyntacticSequencerPDAProvider.ISynState> matches, RuleCallStack stack) {
            List<ISyntacticSequencerPDAProvider.ISynState> r;
            ArrayList result = Lists.newArrayList();
            ISyntacticSequencerPDAProvider.ISynNavigable current = this;
            if (this.involvesRuleExit().booleanValue()) {
                while (!stack.isEmpty()) {
                    r = current.getShortestPathTo(ISyntacticSequencerPDAProvider.SynPredicates.ruleCallExit((RuleCall)stack.peek()), ISyntacticSequencerPDAProvider.SynPredicates.ruleCallExitsOrAbsorber(), stack, true);
                    if (r == null) break;
                    result.addAll(r);
                    stack = (RuleCallStack)stack.cloneAndPop();
                    current = (ISyntacticSequencerPDAProvider.ISynNavigable)((Object)r.get(r.size() - 1));
                }
            }
            if ((r = current.getShortestPathTo(matches, ISyntacticSequencerPDAProvider.SynPredicates.absorber(), stack, false)) != null) {
                result.addAll(r);
            }
            return result;
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynAbsorberState getTarget() {
            return this.target;
        }

        @Override
        public boolean hasEmitters() {
            return this.getFollowers().size() != 1 || !(this.getFollowers().get(0) instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState);
        }

        protected boolean involves(ISyntacticSequencerPDAProvider.ISynState from, Set<ISyntacticSequencerPDAProvider.SynStateType> types, Set<ISyntacticSequencerPDAProvider.ISynState> visited) {
            if (types.contains((Object)from.getType())) {
                return true;
            }
            if (!visited.add(from)) {
                return false;
            }
            for (ISyntacticSequencerPDAProvider.ISynState state : from.getFollowers()) {
                if (state instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState || !this.involves(state, types, visited)) continue;
                return true;
            }
            return false;
        }

        protected boolean involves(Set<ISyntacticSequencerPDAProvider.SynStateType> types) {
            HashSet visited = Sets.newHashSet();
            for (ISyntacticSequencerPDAProvider.ISynState state : this.followers) {
                if (!this.involves(state, types, visited)) continue;
                return true;
            }
            return false;
        }

        protected Boolean involvesRuleExit() {
            if (this.involvesRuleExit == null) {
                this.involvesRuleExit = this.involves(EnumSet.of(ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_EXIT));
            }
            return this.involvesRuleExit;
        }

        @Override
        public boolean involvesUnassignedTokenRuleCalls() {
            if (this.involvesUnassignedTokenRuleCalls == null) {
                this.involvesUnassignedTokenRuleCalls = this.involves(EnumSet.of(ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_DATATYPE_RULE_CALL, ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_TERMINAL_RULE_CALL));
            }
            return this.involvesUnassignedTokenRuleCalls;
        }

        @Override
        public boolean isSyntacticallyAmbiguous() {
            if (this.syntacticallyAmbiguous == null) {
                this.syntacticallyAmbiguous = this.isSyntacticallyAmbiguous(this.followers);
            }
            return this.syntacticallyAmbiguous;
        }

        protected boolean isSyntacticallyAmbiguous(ISyntacticSequencerPDAProvider.ISynState state, RuleCallStack exits, RuleCallStack stack, List<RuleCallStack> results, Set<ISyntacticSequencerPDAProvider.ISynState> visited) {
            if (!visited.add((ISyntacticSequencerPDAProvider.ISynState)state)) {
                return true;
            }
            if (state instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
                results.add(exits);
                return false;
            }
            switch (state.getType().getSimpleType()) {
                case RULECALL_ENTER: {
                    stack = (RuleCallStack)stack.cloneAndPush((RuleCall)state.getGrammarElement());
                    break;
                }
                case RULECALL_EXIT: {
                    RuleCall rc = (RuleCall)state.getGrammarElement();
                    if (!stack.isEmpty()) {
                        if (rc == stack.peek()) {
                            stack = (RuleCallStack)stack.cloneAndPop();
                            break;
                        }
                        return false;
                    }
                    if (exits.contains(rc)) {
                        return false;
                    }
                    visited = Sets.newHashSet();
                    exits = (RuleCallStack)exits.cloneAndPush(rc);
                    break;
                }
            }
            for (ISyntacticSequencerPDAProvider.ISynState follower : state.getFollowers()) {
                if (!this.isSyntacticallyAmbiguous(follower, exits, stack, results, visited)) continue;
                return true;
            }
            return false;
        }

        protected boolean isSyntacticallyAmbiguous(List<ISyntacticSequencerPDAProvider.ISynState> states) {
            RuleCallStack exits = new RuleCallStack();
            RuleCallStack stack = new RuleCallStack();
            ArrayList results = Lists.newArrayList();
            HashSet visited = Sets.newHashSet();
            for (ISyntacticSequencerPDAProvider.ISynState state : states) {
                if (!this.isSyntacticallyAmbiguous(state, exits, stack, results, visited)) continue;
                return true;
            }
            return results.size() != Sets.newHashSet((Iterable)results).size();
        }

        @Override
        public EClass getEClass() {
            return this.target.getEClass();
        }

        @Override
        public EObject getContext() {
            return this.target.getContext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class SynState
    implements ISyntacticSequencerPDAProvider.ISynState {
        protected AbstractElement element;
        protected List<ISyntacticSequencerPDAProvider.ISynState> followers = Collections.emptyList();
        protected ISyntacticSequencerPDAProvider.SynStateType type;

        public SynState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element) {
            this.type = type;
            this.element = element;
            this.followers = Collections.emptyList();
        }

        protected void addFollower(ISyntacticSequencerPDAProvider.ISynState follower) {
            if (this.followers.isEmpty()) {
                this.followers = Lists.newArrayList();
            }
            this.followers.add(follower);
        }

        protected void addFollower(List<ISyntacticSequencerPDAProvider.ISynState> follower) {
            if (this.followers.isEmpty()) {
                this.followers = Lists.newArrayList();
            }
            this.followers.addAll(follower);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getFollowers() {
            return this.followers;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.element;
        }

        @Override
        public ISyntacticSequencerPDAProvider.SynStateType getType() {
            return this.type;
        }

        protected void setFollowers(List<ISyntacticSequencerPDAProvider.ISynState> followers) {
            this.followers = followers;
        }

        public String toString() {
            if (this.type == null) {
                return "(type is null)";
            }
            GrammarElementFullTitleSwitch titles = new GrammarElementFullTitleSwitch();
            switch (this.type.getSimpleType()) {
                case ELEMENT: {
                    return this.element == null ? "(null)" : (String)titles.doSwitch(this.element);
                }
                case RULECALL_ENTER: {
                    return ">>" + (this.element == null ? "(null)" : (String)titles.doSwitch(this.element));
                }
                case RULECALL_EXIT: {
                    return "<<" + (this.element == null ? "(null)" : (String)titles.doSwitch(this.element));
                }
                case START: {
                    return "start";
                }
                case STOP: {
                    return "stop";
                }
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SynTransition
    extends SynNavigable
    implements ISyntacticSequencerPDAProvider.ISynTransition {
        protected ISyntacticSequencerPDAProvider.ISynAbsorberState source;
        protected NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState> ambiguousSyntax;

        public SynTransition(ISyntacticSequencerPDAProvider.ISynAbsorberState source, ISyntacticSequencerPDAProvider.ISynAbsorberState target) {
            super(ISyntacticSequencerPDAProvider.SynStateType.TRANSITION, null, target);
            this.source = source;
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynAbsorberState getSource() {
            return this.source;
        }

        @Override
        public String toString() {
            return this.getSyntax().toString();
        }

        public NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState> getSyntax() {
            return new NfaToGrammar().nfaToGtammar(this.source, this.target, new Function<ISyntacticSequencerPDAProvider.ISynState, Iterable<ISyntacticSequencerPDAProvider.ISynState>>(){

                public Iterable<ISyntacticSequencerPDAProvider.ISynState> apply(ISyntacticSequencerPDAProvider.ISynState from) {
                    if (from == SynTransition.this.source) {
                        return SynTransition.this.getFollowers();
                    }
                    if (from == SynTransition.this.target) {
                        return Collections.emptyList();
                    }
                    return from.getFollowers();
                }
            });
        }

        public NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState> getShortSyntax() {
            return new NfaToGrammar().nfaToGtammar(this.source, this.target, new Function<ISyntacticSequencerPDAProvider.ISynState, Iterable<ISyntacticSequencerPDAProvider.ISynState>>(){

                public Iterable<ISyntacticSequencerPDAProvider.ISynState> apply(ISyntacticSequencerPDAProvider.ISynState from) {
                    if (from == SynTransition.this.target) {
                        return Collections.emptyList();
                    }
                    ISyntacticSequencerPDAProvider.ISynState owner = from == SynTransition.this.source ? SynTransition.this : from;
                    HashSet followers = Sets.newHashSet();
                    SynTransition.this.collectFollowers(owner, followers, Sets.newHashSet(), new Predicate<ISyntacticSequencerPDAProvider.ISynState>(){

                        public boolean apply(ISyntacticSequencerPDAProvider.ISynState input) {
                            if (input instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
                                return true;
                            }
                            AbstractElement ge = input.getGrammarElement();
                            return ge instanceof Keyword || GrammarUtil.isDatatypeRuleCall(ge) || GrammarUtil.isEnumRuleCall(ge) || GrammarUtil.isTerminalRuleCall(ge);
                        }
                    });
                    return followers;
                }
            });
        }

        protected void collectFollowers(ISyntacticSequencerPDAProvider.ISynFollowerOwner owner, Set<ISyntacticSequencerPDAProvider.ISynState> result, Set<ISyntacticSequencerPDAProvider.ISynState> visited, Predicate<ISyntacticSequencerPDAProvider.ISynState> filter) {
            for (ISyntacticSequencerPDAProvider.ISynState follower : owner.getFollowers()) {
                if (!visited.add(follower)) continue;
                if (filter.apply((Object)follower)) {
                    result.add(follower);
                    continue;
                }
                this.collectFollowers(follower, result, visited, filter);
            }
        }

        @Override
        public NfaToGrammar.AbstractElementAlias<ISyntacticSequencerPDAProvider.ISynState> getAmbiguousSyntax() {
            if (this.ambiguousSyntax != null) {
                return this.ambiguousSyntax;
            }
            this.ambiguousSyntax = this.getShortSyntax();
            if (this.ambiguousSyntax instanceof NfaToGrammar.GroupAlias) {
                NfaToGrammar.GroupAlias group = (NfaToGrammar.GroupAlias)this.ambiguousSyntax;
                List children = group.getChildren();
                int start = 0;
                while (start < children.size() && children.get(start) instanceof NfaToGrammar.ElementAlias && children.get(start).isOne()) {
                    ++start;
                }
                int end = children.size() - 1;
                while (end >= 0 && children.get(end) instanceof NfaToGrammar.ElementAlias && children.get(end).isOne()) {
                    --end;
                }
                group.children = children.subList(start, end + 1);
                if (group.children.size() == 1) {
                    this.ambiguousSyntax = group.children.get(0);
                }
            }
            return this.ambiguousSyntax;
        }
    }
}

