/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.diagnostic;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.ITokenDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.SerializationDiagnostic;
import org.eclipse.xtext.util.EmfFormatter;

public class TokenDiagnosticProvider
implements ITokenDiagnosticProvider {
    public ISerializationDiagnostic getNullNotAllowedDiagnostic(EObject semanticObject, AbstractElement ele) {
        return new SerializationDiagnostic(semanticObject, ele, "Must not be null");
    }

    public ISerializationDiagnostic getValueConversionExceptionDiagnostic(EObject semanticObject, AbstractElement element, Object value, Throwable exception) {
        return new SerializationDiagnostic(semanticObject, element, exception.getMessage());
    }

    protected String getFullReferenceName(EObject semanticObject, CrossReference reference) {
        EReference ref = GrammarUtil.getReference(reference);
        String clazz = semanticObject.eClass().getName();
        if (ref.getEContainingClass() != semanticObject.eClass()) {
            clazz = String.valueOf(ref.getEContainingClass().getName()) + "(" + clazz + ")";
        }
        return String.valueOf(clazz) + "." + ref.getName();
    }

    public ISerializationDiagnostic getNoScopeFoundDiagnostic(EObject semanticObject, CrossReference element, EObject target) {
        String msg = "Could not create Scope for EReference " + this.getFullReferenceName(semanticObject, element);
        return new SerializationDiagnostic(semanticObject, element, msg);
    }

    public ISerializationDiagnostic getNoEObjectDescriptionFoundDiagnostic(EObject semanticObject, CrossReference element, EObject target, IScope scope) {
        String msg = "No EObjectDescription could be found in Scope " + this.getFullReferenceName(semanticObject, element) + " for " + EmfFormatter.objPath((EObject)target);
        return new SerializationDiagnostic(semanticObject, element, msg);
    }
}

