/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.sequencer.AbstractSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.tokens.ICrossReferenceSerializer;
import org.eclipse.xtext.serializer.tokens.IEnumLiteralSerializer;
import org.eclipse.xtext.serializer.tokens.IKeywordSerializer;
import org.eclipse.xtext.serializer.tokens.IValueSerializer;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSemanticSequencer
extends AbstractSemanticSequencer {
    public static final int MAX = Integer.MAX_VALUE;
    protected static final int NO_ASSIGNMENT = -2;
    public static final int UNDEF = -1;
    protected static final int UNDEFINED_QUANTITY = -1;
    protected List<IGrammarConstraintProvider.IConstraintContext> constraintContexts;
    protected Map<Pair<EObject, EClass>, IGrammarConstraintProvider.IConstraint> constraints;
    @Inject
    protected IContextFinder contextFinder;
    @Inject
    protected ICrossReferenceSerializer crossRefSerializer;
    @Inject
    protected ISemanticSequencerDiagnosticProvider diagnosticProvider;
    @Inject
    protected IEnumLiteralSerializer enumLiteralSerializer;
    @Inject
    protected IGrammarAccess grammarAccess;
    @Inject
    protected IGrammarConstraintProvider grammarConstraintProvider;
    @Inject
    protected IKeywordSerializer keywordSerializer;
    @Inject
    protected ISemanticNodeProvider nodeProvider;
    @Inject
    protected ITransientValueService transientValueService;
    @Inject
    protected IValueSerializer valueSerializer;

    protected void acceptAction(Action action, EObject semanticChild, ICompositeNode node) {
        if (this.sequenceAcceptor.enterAssignedAction(action, semanticChild, node)) {
            this.masterSequencer.createSequence(action, semanticChild);
            this.sequenceAcceptor.leaveAssignedAction(action, semanticChild);
        }
    }

    protected void acceptEObjectRuleCall(RuleCall ruleCall, EObject semanticChild, ICompositeNode node) {
        if (this.sequenceAcceptor.enterAssignedParserRuleCall(ruleCall, semanticChild, node)) {
            this.masterSequencer.createSequence(ruleCall.getRule(), semanticChild);
            this.sequenceAcceptor.leaveAssignedParserRuleCall(ruleCall, semanticChild);
        }
    }

    protected boolean acceptSemantic(EObject semanticObj, IGrammarConstraintProvider.IConstraintElement constr, Object value, int index, INode node) {
        switch (constr.getType()) {
            case ASSIGNED_ACTION_CALL: {
                this.acceptAction(constr.getAction(), (EObject)value, (ICompositeNode)node);
                return true;
            }
            case ASSIGNED_PARSER_RULE_CALL: {
                this.acceptEObjectRuleCall(constr.getRuleCall(), (EObject)value, (ICompositeNode)node);
                return true;
            }
            case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: {
                RuleCall datatypeRC = constr.getRuleCall();
                EObject value1 = (EObject)value;
                ICompositeNode node1 = (ICompositeNode)node;
                String token1 = this.crossRefSerializer.serializeCrossRef(semanticObj, GrammarUtil.containingCrossReference(datatypeRC), value1, node1, this.errorAcceptor);
                this.sequenceAcceptor.acceptAssignedCrossRefDatatype(datatypeRC, token1, value1, index, node1);
                return true;
            }
            case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: {
                RuleCall terminalRC = constr.getRuleCall();
                EObject value2 = (EObject)value;
                ILeafNode node2 = (ILeafNode)node;
                String token2 = this.crossRefSerializer.serializeCrossRef(semanticObj, GrammarUtil.containingCrossReference(terminalRC), value2, node2, this.errorAcceptor);
                this.sequenceAcceptor.acceptAssignedCrossRefTerminal(terminalRC, token2, value2, index, node2);
                return true;
            }
            case ASSIGNED_CROSSREF_ENUM_RULE_CALL: {
                RuleCall enumRC = constr.getRuleCall();
                ICompositeNode node3 = (ICompositeNode)node;
                EObject target3 = (EObject)value;
                String token3 = this.crossRefSerializer.serializeCrossRef(semanticObj, GrammarUtil.containingCrossReference(enumRC), target3, node3, this.errorAcceptor);
                this.sequenceAcceptor.acceptAssignedCrossRefEnum(enumRC, token3, target3, index, node3);
                return true;
            }
            case ASSIGNED_DATATYPE_RULE_CALL: {
                RuleCall datatypeRC1 = constr.getRuleCall();
                ICompositeNode node4 = (ICompositeNode)node;
                String token4 = this.valueSerializer.serializeAssignedValue(semanticObj, datatypeRC1, value, node4, this.errorAcceptor);
                this.sequenceAcceptor.acceptAssignedDatatype(datatypeRC1, token4, value, index, node4);
                return true;
            }
            case ASSIGNED_ENUM_RULE_CALL: {
                RuleCall enumRC1 = constr.getRuleCall();
                ICompositeNode node5 = (ICompositeNode)node;
                String token5 = this.enumLiteralSerializer.serializeAssignedEnumLiteral(semanticObj, enumRC1, value, node5, this.errorAcceptor);
                this.sequenceAcceptor.acceptAssignedEnum(enumRC1, token5, value, index, node5);
                return true;
            }
            case ASSIGNED_TERMINAL_RULE_CALL: {
                RuleCall terminalRC1 = constr.getRuleCall();
                ILeafNode node6 = (ILeafNode)node;
                String token6 = this.valueSerializer.serializeAssignedValue(semanticObj, terminalRC1, value, node6, this.errorAcceptor);
                this.sequenceAcceptor.acceptAssignedTerminal(terminalRC1, token6, value, index, node6);
                return true;
            }
            case ASSIGNED_KEYWORD: {
                Keyword keyword = constr.getKeyword();
                String value3 = (String)value;
                ILeafNode node7 = (ILeafNode)node;
                String token7 = this.keywordSerializer.serializeAssignedKeyword(semanticObj, keyword, value3, node7, this.errorAcceptor);
                this.sequenceAcceptor.acceptAssignedKeyword(keyword, token7, value3, index, node7);
                return true;
            }
            case ASSIGNED_BOOLEAN_KEYWORD: {
                Keyword keyword1 = constr.getKeyword();
                Boolean value4 = (Boolean)value;
                ILeafNode node8 = (ILeafNode)node;
                String token71 = this.keywordSerializer.serializeAssignedKeyword(semanticObj, keyword1, value4, node8, this.errorAcceptor);
                this.sequenceAcceptor.acceptAssignedKeyword(keyword1, token71, value4 == null ? false : value4, index, node8);
                return true;
            }
            case ALTERNATIVE: 
            case GROUP: {
                return false;
            }
        }
        return false;
    }

    protected void applydeterministicQuantities(IGrammarConstraintProvider.IConstraint constraint, Feature2Assignment[] values) {
        boolean changed;
        do {
            changed = false;
            IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = constraint.getAssignments();
            int n = iConstraintElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                int max;
                int min;
                IGrammarConstraintProvider.IConstraintElement assignment = iConstraintElementArray[n2];
                if (values[assignment.getAssignmentID()] != null && values[assignment.getAssignmentID()].isAmbiguous() && (min = this.getMin(values, assignment)) == (max = this.getMax(values, assignment)) && min != -1) {
                    values[assignment.getAssignmentID()].setQuantity(assignment, min);
                    changed = true;
                }
                ++n2;
            }
        } while (changed);
    }

    protected boolean containsUnavailableFeature(Feature2Assignment[] values, IGrammarConstraintProvider.IConstraintElement element, IGrammarConstraintProvider.IConstraintElement excludeAssignment) {
        if (element.isOptional()) {
            return false;
        }
        switch (element.getType()) {
            case GROUP: {
                for (IGrammarConstraintProvider.IConstraintElement a : element.getChildren()) {
                    if (!this.containsUnavailableFeature(values, a, excludeAssignment)) continue;
                    return true;
                }
                return false;
            }
            case ALTERNATIVE: {
                for (IGrammarConstraintProvider.IConstraintElement a : element.getChildren()) {
                    if (this.containsUnavailableFeature(values, a, excludeAssignment)) continue;
                    return false;
                }
                return true;
            }
            case ASSIGNED_ACTION_CALL: 
            case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: 
            case ASSIGNED_CROSSREF_ENUM_RULE_CALL: 
            case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: 
            case ASSIGNED_DATATYPE_RULE_CALL: 
            case ASSIGNED_ENUM_RULE_CALL: 
            case ASSIGNED_KEYWORD: 
            case ASSIGNED_BOOLEAN_KEYWORD: 
            case ASSIGNED_PARSER_RULE_CALL: 
            case ASSIGNED_TERMINAL_RULE_CALL: {
                Feature2Assignment f2a = values[element.getAssignmentID()];
                if (f2a == null) {
                    return true;
                }
                if (f2a.isAmbiguous()) {
                    return false;
                }
                return f2a.getValuesFor(element).isEmpty();
            }
        }
        return false;
    }

    @Override
    public void createSequence(EObject context, EObject semanticObject) {
        this.initConstraints();
        IGrammarConstraintProvider.IConstraint constraint = this.getConstraint(context, semanticObject.eClass());
        if (constraint == null) {
            if (this.errorAcceptor != null) {
                this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
            }
            return;
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.nodeProvider.getNodesForSemanticObject(semanticObject, null);
        Feature2Assignment[] values = this.createValues(semanticObject, constraint, nodes);
        this.applydeterministicQuantities(constraint, values);
        if (constraint.getBody() != null) {
            Quantity quant = new Quantity(constraint.getBody(), this.createUnambiguousAllocation(constraint.getBody(), values));
            quant.accept(semanticObject);
        }
        this.sequenceAcceptor.finish();
    }

    protected List<? extends Allocation> createUnambiguousAllocation(IGrammarConstraintProvider.IConstraintElement constraint, Feature2Assignment[] values) {
        switch (constraint.getType()) {
            case ALTERNATIVE: {
                ArrayList result = Lists.newArrayList();
                for (IGrammarConstraintProvider.IConstraintElement child : constraint.getChildren()) {
                    List<? extends Allocation> allocs = this.createUnambiguousAllocation(child, values);
                    if (allocs == null) {
                        return null;
                    }
                    if (child.isMany()) {
                        Quantity quantity = new Quantity(child, allocs);
                        result.add(new AlternativeAllocation(quantity));
                        continue;
                    }
                    for (Allocation allocation : allocs) {
                        AlternativeAllocation alloc = new AlternativeAllocation(new Quantity(child, allocation));
                        result.add(alloc);
                    }
                }
                return result;
            }
            case GROUP: {
                int min = 0;
                int max = Integer.MAX_VALUE;
                ArrayList children = Lists.newArrayListWithExpectedSize((int)constraint.getChildren().size());
                for (IGrammarConstraintProvider.IConstraintElement iConstraintElement : constraint.getChildren()) {
                    List<? extends Allocation> allocs = this.createUnambiguousAllocation(iConstraintElement, values);
                    if (allocs == null) {
                        return null;
                    }
                    if (allocs.size() > 0) {
                        min = Math.max(min, iConstraintElement.isMany() ? 1 : allocs.size());
                    }
                    if (!iConstraintElement.isOptional()) {
                        max = Math.max(max, allocs.size());
                    }
                    children.add(Tuples.create((Object)iConstraintElement, allocs));
                }
                if (max < min) {
                    throw new RuntimeException("err");
                }
                ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)min);
                int i = 0;
                while (i < min) {
                    ArrayList ch = Lists.newArrayList();
                    for (Pair p : children) {
                        if (i >= ((List)p.getSecond()).size()) continue;
                        if (i == min - 1) {
                            ch.add(new Quantity((IGrammarConstraintProvider.IConstraintElement)p.getFirst(), ((List)p.getSecond()).subList(i, ((List)p.getSecond()).size())));
                            continue;
                        }
                        ch.add(new Quantity((IGrammarConstraintProvider.IConstraintElement)p.getFirst(), (Allocation)((List)p.getSecond()).get(i)));
                    }
                    arrayList.add(new GroupAllocation(ch));
                    ++i;
                }
                return arrayList;
            }
            case ASSIGNED_ACTION_CALL: 
            case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: 
            case ASSIGNED_CROSSREF_ENUM_RULE_CALL: 
            case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: 
            case ASSIGNED_DATATYPE_RULE_CALL: 
            case ASSIGNED_ENUM_RULE_CALL: 
            case ASSIGNED_KEYWORD: 
            case ASSIGNED_BOOLEAN_KEYWORD: 
            case ASSIGNED_PARSER_RULE_CALL: 
            case ASSIGNED_TERMINAL_RULE_CALL: {
                Feature2Assignment f2a = values[constraint.getAssignmentID()];
                if (f2a == null) {
                    return Collections.emptyList();
                }
                if (!f2a.isAmbiguous()) {
                    return f2a.getValuesFor(constraint);
                }
                return null;
            }
        }
        return null;
    }

    protected Feature2Assignment[] createValues(EObject semanticObject, IGrammarConstraintProvider.IConstraint constraint, ISemanticNodeProvider.INodesForEObjectProvider nodes) {
        INode node;
        Object value;
        ITransientValueService.ValueTransient trans;
        List<AllocationValue> allocs;
        Feature2Assignment[] result = new Feature2Assignment[constraint.getAssignments().length];
        for (IGrammarConstraintProvider.IFeatureInfo feature : constraint.getSingleAssignementFeatures()) {
            if (feature.getFeature().isMany()) {
                allocs = this.getNonTransientValuesForMVFeature(semanticObject, feature, nodes);
                if (allocs.isEmpty()) continue;
                IGrammarConstraintProvider.IConstraintElement ass = feature.getAssignments()[0];
                result[ass.getAssignmentID()] = new MVFeature2AssignmentUnambiguous(ass, allocs);
                continue;
            }
            trans = this.transientValueService.isValueTransient(semanticObject, feature.getFeature());
            if (trans == ITransientValueService.ValueTransient.YES) continue;
            value = semanticObject.eGet(feature.getFeature());
            node = nodes.getNodeForSingelValue(feature.getFeature(), value);
            if (trans == ITransientValueService.ValueTransient.PREFERABLY && node == null) continue;
            IGrammarConstraintProvider.IConstraintElement ass = feature.getAssignments()[0];
            AllocationValue alloc = new AllocationValue(value, -1, node);
            result[ass.getAssignmentID()] = new SVFeature2AssignmentUnambiguous(ass, trans == ITransientValueService.ValueTransient.PREFERABLY, alloc);
        }
        for (IGrammarConstraintProvider.IFeatureInfo feature : constraint.getMultiAssignementFeatures()) {
            if (feature.getFeature().isMany()) {
                allocs = this.getNonTransientValuesForMVFeature(semanticObject, feature, nodes);
                if (allocs.isEmpty()) continue;
                this.createValues(semanticObject, feature, allocs, result);
                continue;
            }
            trans = this.transientValueService.isValueTransient(semanticObject, feature.getFeature());
            if (trans == ITransientValueService.ValueTransient.YES) continue;
            value = semanticObject.eGet(feature.getFeature());
            node = nodes.getNodeForSingelValue(feature.getFeature(), value);
            AllocationValue alloc = new AllocationValue(value, -1, node);
            this.createValues(semanticObject, feature, trans == ITransientValueService.ValueTransient.PREFERABLY, alloc, result);
        }
        return result;
    }

    protected void createValues(EObject semanticObj, IGrammarConstraintProvider.IFeatureInfo feature, boolean optional, AllocationValue value, Feature2Assignment[] target) {
        List<Object> validAssignments = null;
        if (feature.isContentValidationNeeded()) {
            validAssignments = this.findValidAssignments(semanticObj, feature.getAssignments(), value);
            if (validAssignments.isEmpty()) {
                return;
            }
            if (validAssignments.size() == 1) {
                IGrammarConstraintProvider.IConstraintElement ass = (IGrammarConstraintProvider.IConstraintElement)validAssignments.get(0);
                target[ass.getAssignmentID()] = new SVFeature2AssignmentUnambiguous(ass, optional, value);
                return;
            }
        }
        if (validAssignments == null) {
            validAssignments = Lists.newArrayList((Object[])feature.getAssignments());
        }
        SVFeature2AssignmentAmbiguous f2a = new SVFeature2AssignmentAmbiguous((List<IGrammarConstraintProvider.IConstraintElement>)validAssignments, optional, value);
        for (IGrammarConstraintProvider.IConstraintElement iConstraintElement : validAssignments) {
            target[iConstraintElement.getAssignmentID()] = f2a;
        }
    }

    protected void createValues(EObject semanticObj, IGrammarConstraintProvider.IFeatureInfo feature, List<AllocationValue> values, Feature2Assignment[] target) {
        IGrammarConstraintProvider.IConstraintElement ass;
        List<Object> remainingAssignments = Lists.newArrayList();
        IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = feature.getAssignments();
        int n = iConstraintElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ass = iConstraintElementArray[n2];
            if (!this.isExcludedByDependees(ass, target)) {
                remainingAssignments.add(ass);
            }
            ++n2;
        }
        if (feature.isContentValidationNeeded()) {
            remainingAssignments = this.findValidAssignments(semanticObj, (List<IGrammarConstraintProvider.IConstraintElement>)remainingAssignments, values);
        }
        if (remainingAssignments.size() == 0) {
            throw new RuntimeException("no valid assignments");
        }
        if (remainingAssignments.size() == 1) {
            ass = (IGrammarConstraintProvider.IConstraintElement)remainingAssignments.get(0);
            target[ass.getAssignmentID()] = new MVFeature2AssignmentUnambiguous(ass, values);
            return;
        }
        ArrayList remainingValues = Lists.newArrayList(values);
        this.distributeValuesByQuantity(remainingAssignments, remainingValues, target);
        if (remainingAssignments.size() == 1) {
            IGrammarConstraintProvider.IConstraintElement ass2 = (IGrammarConstraintProvider.IConstraintElement)remainingAssignments.get(0);
            target[ass2.getAssignmentID()] = new MVFeature2AssignmentUnambiguous(ass2, remainingValues);
            return;
        }
        MVFeature2AssignmentAmbiguous f2a = new MVFeature2AssignmentAmbiguous(remainingAssignments, remainingValues);
        for (IGrammarConstraintProvider.IConstraintElement iConstraintElement : remainingAssignments) {
            target[iConstraintElement.getAssignmentID()] = f2a;
        }
    }

    protected void distributeValuesByQuantity(List<IGrammarConstraintProvider.IConstraintElement> assignments, List<AllocationValue> values, Feature2Assignment[] target) {
        IGrammarConstraintProvider.IConstraintElement ass;
        while ((ass = assignments.get(0)).isCardinalityOneAmongAssignments(assignments)) {
            target[ass.getAssignmentID()] = new SVFeature2AssignmentUnambiguous(ass, false, values.get(0));
            values.remove(0);
            assignments.remove(0);
        }
        int i = assignments.size() - 1;
        while (i >= 0 && !values.isEmpty()) {
            IGrammarConstraintProvider.IConstraintElement ass2 = assignments.get(i);
            if (ass2 == null || !ass2.isCardinalityOneAmongAssignments(assignments)) break;
            target[ass2.getAssignmentID()] = new SVFeature2AssignmentUnambiguous(ass2, false, values.get(values.size() - 1));
            values.remove(values.size() - 1);
            assignments.remove(i);
            --i;
        }
    }

    protected String f2aToStr(IGrammarConstraintProvider.IConstraintElement ele, Feature2Assignment[] values) {
        if (ele == null) {
            return "(null)";
        }
        StringBuilder result = new StringBuilder();
        this.f2aToStr(ele, values, "", result);
        return result.toString();
    }

    protected void f2aToStr(IGrammarConstraintProvider.IConstraintElement ele, Feature2Assignment[] values, String prefix, StringBuilder result) {
        result.append(prefix);
        if (ele.getChildren() != null) {
            result.append(ele.getType().name());
            result.append(ele.getCardinality());
            result.append(" {\n");
            for (IGrammarConstraintProvider.IConstraintElement child : ele.getChildren()) {
                this.f2aToStr(child, values, String.valueOf(prefix) + "  ", result);
            }
            result.append(prefix);
            result.append("}\n");
        } else if (ele.getAssignmentID() >= 0) {
            result.append(ele.toString());
            result.append(" => ");
            Feature2Assignment value = values[ele.getAssignmentID()];
            if (value != null) {
                if (value.isAmbiguous()) {
                    result.append("[");
                    result.append(this.getMin(values, ele));
                    result.append(", ");
                    result.append(this.getMax(values, ele));
                    result.append("] ");
                }
                result.append(Joiner.on((String)", ").join(values[ele.getAssignmentID()].getValuesFor(ele)));
            }
            result.append("\n");
        }
    }

    protected List<IGrammarConstraintProvider.IConstraintElement> findValidAssignments(EObject semanitcObj, IGrammarConstraintProvider.IConstraintElement[] assignments, AllocationValue value) {
        EStructuralFeature feature = assignments[0].getFeature();
        if (feature instanceof EAttribute) {
            if (feature.getEType() instanceof EEnum) {
                return this.findValidAssignmentsForEnum(semanitcObj, assignments, value.getValue());
            }
            return this.findValidAssignmentsForDatatype(semanitcObj, assignments, value.getValue());
        }
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            if (ref.isContainment()) {
                return this.findValidAssignmentsForContainmentRef(semanitcObj, assignments, (EObject)value.getValue());
            }
            return this.findValidAssignmentsForCrossRef(semanitcObj, assignments, (EObject)value.getValue(), value.getNode());
        }
        throw new RuntimeException("unknown feature type");
    }

    protected List<IGrammarConstraintProvider.IConstraintElement> findValidAssignments(EObject semanticObj, List<IGrammarConstraintProvider.IConstraintElement> assignments, List<AllocationValue> values) {
        BitSet bs = new BitSet();
        IGrammarConstraintProvider.IConstraintElement[] assignmentsAr = assignments.toArray(new IGrammarConstraintProvider.IConstraintElement[assignments.size()]);
        for (AllocationValue value : values) {
            for (IGrammarConstraintProvider.IConstraintElement validAssignments : this.findValidAssignments(semanticObj, assignmentsAr, value)) {
                bs.set(validAssignments.getFeatureAssignmentID());
            }
        }
        ArrayList result = Lists.newArrayList();
        for (IGrammarConstraintProvider.IConstraintElement ass : assignments) {
            if (!bs.get(ass.getFeatureAssignmentID())) continue;
            result.add(ass);
        }
        return result;
    }

    protected List<IGrammarConstraintProvider.IConstraintElement> findValidAssignmentsForContainmentRef(EObject semanitcObj, IGrammarConstraintProvider.IConstraintElement[] assignments, EObject value) {
        HashSet contexts = Sets.newHashSet();
        IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = assignments;
        int n = assignments.length;
        int n2 = 0;
        while (n2 < n) {
            IGrammarConstraintProvider.IConstraintElement ass = iConstraintElementArray[n2];
            contexts.add(ass.getCallContext());
            ++n2;
        }
        contexts = Sets.newHashSet(this.contextFinder.findContextsByContents(value, contexts));
        ArrayList result = Lists.newArrayList();
        IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray2 = assignments;
        int n3 = assignments.length;
        n = 0;
        while (n < n3) {
            IGrammarConstraintProvider.IConstraintElement ass = iConstraintElementArray2[n];
            if (contexts.contains(ass.getCallContext())) {
                result.add(ass);
            }
            ++n;
        }
        return result;
    }

    protected List<IGrammarConstraintProvider.IConstraintElement> findValidAssignmentsForCrossRef(EObject semanitcObj, IGrammarConstraintProvider.IConstraintElement[] assignments, EObject value, INode node) {
        HashMap candidates = Maps.newHashMap();
        IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = assignments;
        int n = assignments.length;
        int n2 = 0;
        while (n2 < n) {
            IGrammarConstraintProvider.IConstraintElement ass = iConstraintElementArray[n2];
            List cand = (List)candidates.get(ass.getCrossReference());
            if (cand == null) {
                if (EcoreUtil2.isAssignableFrom(ass.getCrossReferenceType(), value.eClass()) && this.crossRefSerializer.isValid(semanitcObj, ass.getCrossReference(), value, node, null)) {
                    candidates.put(ass.getCrossReference(), Lists.newArrayList((Object[])new IGrammarConstraintProvider.IConstraintElement[]{ass}));
                } else {
                    candidates.put(ass.getCrossReference(), Collections.emptyList());
                }
            } else if (cand != Collections.EMPTY_LIST) {
                cand.add(ass);
            }
            ++n2;
        }
        ArrayList result = Lists.newArrayList();
        for (List l : candidates.values()) {
            result.addAll(l);
        }
        return result;
    }

    protected List<IGrammarConstraintProvider.IConstraintElement> findValidAssignmentsForDatatype(EObject semanticObj, IGrammarConstraintProvider.IConstraintElement[] assignments, Object value) {
        int i = 0;
        while (i < assignments.length) {
            Keyword kw = assignments[i].getKeyword();
            if (kw != null && this.keywordSerializer.isValid(semanticObj, kw, value, null)) {
                return Collections.singletonList(assignments[i]);
            }
            ++i;
        }
        ArrayList result = Lists.newArrayList();
        int i2 = 0;
        while (i2 < assignments.length) {
            RuleCall rc = assignments[i2].getRuleCall();
            if (rc != null && this.valueSerializer.isValid(semanticObj, rc, value, null)) {
                result.add(assignments[i2]);
            }
            ++i2;
        }
        return result;
    }

    protected List<IGrammarConstraintProvider.IConstraintElement> findValidAssignmentsForEnum(EObject semanticObj, IGrammarConstraintProvider.IConstraintElement[] assignments, Object value) {
        ArrayList result = Lists.newArrayList();
        IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = assignments;
        int n = assignments.length;
        int n2 = 0;
        while (n2 < n) {
            IGrammarConstraintProvider.IConstraintElement ass = iConstraintElementArray[n2];
            if (ass.getRuleCall() != null && ass.getRuleCall().getRule() instanceof EnumRule && this.enumLiteralSerializer.isValid(semanticObj, ass.getRuleCall(), value, null)) {
                result.add(ass);
            }
            ++n2;
        }
        return result;
    }

    protected IGrammarConstraintProvider.IConstraint getConstraint(EObject context, EClass type) {
        return this.constraints.get(Tuples.create((Object)context, (Object)type));
    }

    protected int getMax(Feature2Assignment[] values, IGrammarConstraintProvider.IConstraintElement element) {
        int result = element.isRoot() ? 1 : this.getMaxByParent(values, element.getContainer(), element, null);
        return element.isMany() && result > 0 ? Integer.MAX_VALUE : result;
    }

    protected int getMaxByParent(Feature2Assignment[] values, IGrammarConstraintProvider.IConstraintElement parent, IGrammarConstraintProvider.IConstraintElement exclude, IGrammarConstraintProvider.IConstraintElement excludeAssignment) {
        int result;
        if (parent.isRoot()) {
            result = parent.isMany() ? Integer.MAX_VALUE : 1;
        } else {
            result = this.getMaxByParent(values, parent.getContainer(), parent, excludeAssignment);
            if (result == 0) {
                return 0;
            }
        }
        switch (parent.getType()) {
            case GROUP: {
                if (parent.isMany()) {
                    result = Integer.MAX_VALUE;
                }
                for (IGrammarConstraintProvider.IConstraintElement a : parent.getChildren()) {
                    int count;
                    if (a == exclude || (count = this.getMaxForChild(values, a)) == -1 || count >= result) continue;
                    result = count;
                }
                return result;
            }
            case ALTERNATIVE: {
                if (parent.isMany()) {
                    return Integer.MAX_VALUE;
                }
                for (IGrammarConstraintProvider.IConstraintElement a : parent.getChildren()) {
                    int count;
                    if (!(a != exclude ? (count = this.getMinForChild(values, a)) != -1 && count > 0 : excludeAssignment != null && this.containsUnavailableFeature(values, a, excludeAssignment))) continue;
                    return 0;
                }
                return result;
            }
        }
        return 1;
    }

    protected int getMaxForChild(Feature2Assignment[] values, IGrammarConstraintProvider.IConstraintElement child) {
        if (child.isOptional()) {
            return Integer.MAX_VALUE;
        }
        switch (child.getType()) {
            case GROUP: {
                int count1 = Integer.MAX_VALUE;
                for (IGrammarConstraintProvider.IConstraintElement a : child.getChildren()) {
                    int c = this.getMaxForChild(values, a);
                    if (c == -1 || c >= count1) continue;
                    count1 = c;
                }
                return count1;
            }
            case ALTERNATIVE: {
                int count2 = -1;
                for (IGrammarConstraintProvider.IConstraintElement a : child.getChildren()) {
                    int c = this.getMaxForChild(values, a);
                    if (c == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    if (c == -1) continue;
                    int n = count2 = count2 == -1 ? c : count2 + c;
                }
                return count2;
            }
            case ASSIGNED_ACTION_CALL: 
            case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: 
            case ASSIGNED_CROSSREF_ENUM_RULE_CALL: 
            case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: 
            case ASSIGNED_DATATYPE_RULE_CALL: 
            case ASSIGNED_ENUM_RULE_CALL: 
            case ASSIGNED_KEYWORD: 
            case ASSIGNED_BOOLEAN_KEYWORD: 
            case ASSIGNED_PARSER_RULE_CALL: 
            case ASSIGNED_TERMINAL_RULE_CALL: {
                Feature2Assignment f2a = values[child.getAssignmentID()];
                return f2a == null ? 0 : f2a.getQuantity(child);
            }
        }
        return -1;
    }

    protected int getMin(Feature2Assignment[] values, IGrammarConstraintProvider.IConstraintElement assignment) {
        if (assignment.isOptional()) {
            return 0;
        }
        if (assignment.isRoot()) {
            return 1;
        }
        return this.getMinByParent(values, assignment.getContainer(), assignment);
    }

    protected int getMinByParent(Feature2Assignment[] values, IGrammarConstraintProvider.IConstraintElement parent, IGrammarConstraintProvider.IConstraintElement exclude) {
        if (parent == null) {
            return 1;
        }
        switch (parent.getType()) {
            case GROUP: {
                if (!parent.isManyRecursive(null) && !parent.isOptionalRecursive(null)) {
                    return 1;
                }
                int count1 = this.getMinByParent(values, parent.getContainer(), parent);
                for (IGrammarConstraintProvider.IConstraintElement a : parent.getChildren()) {
                    int c;
                    if (a == exclude || (c = this.getMinForChild(values, a)) == -1 || c <= count1) continue;
                    count1 = c;
                }
                return count1;
            }
            case ALTERNATIVE: {
                if (parent.isOptional()) {
                    return 0;
                }
                boolean isUndef = false;
                for (IGrammarConstraintProvider.IConstraintElement a : parent.getChildren()) {
                    if (a == exclude) continue;
                    int count2 = this.getMinForChild(values, a);
                    if (count2 == -1) {
                        isUndef = true;
                        continue;
                    }
                    if (count2 <= 0) continue;
                    return 0;
                }
                if (isUndef) {
                    return -1;
                }
                return this.getMinByParent(values, parent.getContainer(), parent);
            }
        }
        return -1;
    }

    protected int getMinForChild(Feature2Assignment[] values, IGrammarConstraintProvider.IConstraintElement child) {
        int count = -1;
        switch (child.getType()) {
            case GROUP: {
                for (IGrammarConstraintProvider.IConstraintElement a : child.getChildren()) {
                    int c = this.getMinForChild(values, a);
                    if (c <= count) continue;
                    count = c;
                }
                break;
            }
            case ALTERNATIVE: {
                for (IGrammarConstraintProvider.IConstraintElement a : child.getChildren()) {
                    int c = this.getMinForChild(values, a);
                    int n = count = count == -1 ? c : c + count;
                }
                break;
            }
            case ASSIGNED_ACTION_CALL: 
            case ASSIGNED_CROSSREF_DATATYPE_RULE_CALL: 
            case ASSIGNED_CROSSREF_ENUM_RULE_CALL: 
            case ASSIGNED_CROSSREF_TERMINAL_RULE_CALL: 
            case ASSIGNED_DATATYPE_RULE_CALL: 
            case ASSIGNED_ENUM_RULE_CALL: 
            case ASSIGNED_KEYWORD: 
            case ASSIGNED_BOOLEAN_KEYWORD: 
            case ASSIGNED_PARSER_RULE_CALL: 
            case ASSIGNED_TERMINAL_RULE_CALL: {
                Feature2Assignment f2a = values[child.getAssignmentID()];
                return f2a == null ? 0 : f2a.getQuantity(child);
            }
        }
        if (child.isMany() && count > 1) {
            count = 1;
        }
        return count;
    }

    protected List<AllocationValue> getNonTransientValuesForMVFeature(EObject semanticObject, IGrammarConstraintProvider.IFeatureInfo feature, ISemanticNodeProvider.INodesForEObjectProvider nodes) {
        switch (this.transientValueService.isListTransient(semanticObject, feature.getFeature())) {
            case NO: {
                ArrayList allocs1 = Lists.newArrayList();
                List values1 = (List)semanticObject.eGet(feature.getFeature());
                int i = 0;
                while (i < values1.size()) {
                    Object value = values1.get(i);
                    INode node = nodes.getNodeForMultiValue(feature.getFeature(), i, i, value);
                    allocs1.add(new AllocationValue(value, i, node));
                    ++i;
                }
                return allocs1;
            }
            case SOME: {
                ArrayList allocs2 = Lists.newArrayList();
                List values2 = (List)semanticObject.eGet(feature.getFeature());
                int i = 0;
                int j = 0;
                while (i < values2.size()) {
                    if (!this.transientValueService.isValueInListTransient(semanticObject, i, feature.getFeature())) {
                        Object value = values2.get(i);
                        INode node = nodes.getNodeForMultiValue(feature.getFeature(), i, j++, value);
                        allocs2.add(new AllocationValue(value, i, node));
                    }
                    ++i;
                }
                return allocs2;
            }
        }
        return Collections.emptyList();
    }

    protected void initConstraints() {
        if (this.constraintContexts == null) {
            this.constraints = Maps.newHashMap();
            this.constraintContexts = this.grammarConstraintProvider.getConstraints(this.grammarAccess.getGrammar());
            for (IGrammarConstraintProvider.IConstraintContext ctx : this.constraintContexts) {
                for (IGrammarConstraintProvider.IConstraint constraint : ctx.getConstraints()) {
                    this.constraints.put((Pair<EObject, EClass>)Tuples.create((Object)ctx.getContext(), (Object)constraint.getType()), constraint);
                }
            }
        }
    }

    protected boolean isAmbiguous(Feature2Assignment[] allocations) {
        Feature2Assignment[] feature2AssignmentArray = allocations;
        int n = allocations.length;
        int n2 = 0;
        while (n2 < n) {
            Feature2Assignment feat = feature2AssignmentArray[n2];
            if (feat.isAmbiguous()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isExcludedByDependees(IGrammarConstraintProvider.IConstraintElement assignments, Feature2Assignment[] target) {
        List<Pair<IGrammarConstraintProvider.IConstraintElement, IGrammarConstraintProvider.RelationalDependencyType>> dependees = assignments.getDependingAssignment();
        if (dependees == null || dependees.isEmpty()) {
            return false;
        }
        block4: for (Pair<IGrammarConstraintProvider.IConstraintElement, IGrammarConstraintProvider.RelationalDependencyType> e : dependees) {
            switch ((IGrammarConstraintProvider.RelationalDependencyType)((Object)e.getSecond())) {
                case EXCLUDE_IF_SET: {
                    if (target[((IGrammarConstraintProvider.IConstraintElement)e.getFirst()).getAssignmentID()] == null) break;
                    return true;
                }
                case EXCLUDE_IF_UNSET: 
                case SAME: 
                case SAME_OR_LESS: {
                    if (target[((IGrammarConstraintProvider.IConstraintElement)e.getFirst()).getAssignmentID()] != null || ((IGrammarConstraintProvider.IConstraintElement)e.getFirst()).getFeatureInfo().getAssignments().length != 1) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    protected abstract class Allocation {
        public abstract void accept(EObject var1, IGrammarConstraintProvider.IConstraintElement var2);

        public abstract int maxValues(IGrammarConstraintProvider.IConstraintElement var1);

        public abstract int minValues(IGrammarConstraintProvider.IConstraintElement var1);

        public String toString() {
            return this.toString("");
        }

        public abstract String toString(String var1);
    }

    protected class AllocationValue
    extends Allocation {
        protected int index;
        protected INode node;
        protected Object value;

        public AllocationValue(Object value, int index, INode node) {
            this.value = value;
            this.node = node;
            this.index = index;
        }

        public void accept(EObject semanticObj, IGrammarConstraintProvider.IConstraintElement constraint) {
            GenericSemanticSequencer.this.acceptSemantic(semanticObj, constraint, this.value, this.index, this.node);
        }

        public INode getNode() {
            return this.node;
        }

        public Object getValue() {
            return this.value;
        }

        public int maxValues(IGrammarConstraintProvider.IConstraintElement constraint) {
            return 1;
        }

        public int minValues(IGrammarConstraintProvider.IConstraintElement constraint) {
            return 1;
        }

        public String toString(String prefix) {
            return this.value instanceof EObject ? EmfFormatter.objPath((EObject)((EObject)this.value)) : this.value.toString();
        }
    }

    protected class AlternativeAllocation
    extends Allocation {
        protected Quantity child;

        public AlternativeAllocation(Quantity child) {
            this.child = child;
        }

        public void accept(EObject semanticObj, IGrammarConstraintProvider.IConstraintElement constraint) {
            this.child.accept(semanticObj);
        }

        protected Quantity getChild() {
            return this.child;
        }

        public int maxValues(IGrammarConstraintProvider.IConstraintElement constraint) {
            return 0;
        }

        public int minValues(IGrammarConstraintProvider.IConstraintElement constraint) {
            return 0;
        }

        public String toString(String prefix) {
            String newPrefix = "  " + prefix;
            return "Alt-Choice {\n" + newPrefix + this.child.toString(newPrefix) + "\n" + prefix + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Feature2Assignment {
        protected Feature2Assignment() {
        }

        public abstract IGrammarConstraintProvider.IFeatureInfo getFeature();

        public abstract int getQuantity(IGrammarConstraintProvider.IConstraintElement var1);

        public abstract List<AllocationValue> getValuesFor(IGrammarConstraintProvider.IConstraintElement var1);

        public abstract boolean isAmbiguous();

        public abstract void setQuantity(IGrammarConstraintProvider.IConstraintElement var1, int var2);

        public String toString() {
            ArrayList result = Lists.newArrayList();
            IGrammarConstraintProvider.IConstraintElement[] iConstraintElementArray = this.getFeature().getAssignments();
            int n = iConstraintElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGrammarConstraintProvider.IConstraintElement assign = iConstraintElementArray[n2];
                result.add(assign + "=>(" + Joiner.on((String)", ").join(this.getValuesFor(assign)) + ")");
                ++n2;
            }
            return Joiner.on((String)", ").join((Iterable)result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GroupAllocation
    extends Allocation {
        protected List<Quantity> children = Lists.newArrayList();

        public GroupAllocation() {
        }

        public GroupAllocation(List<Quantity> children) {
            this.children = children;
        }

        @Override
        public void accept(EObject semanticObj, IGrammarConstraintProvider.IConstraintElement constraint) {
            for (Quantity q : this.children) {
                q.accept(semanticObj);
            }
        }

        public void addChild(Quantity quantity) {
            this.children.add(quantity);
        }

        public List<Quantity> getChildren() {
            return this.children;
        }

        @Override
        public int maxValues(IGrammarConstraintProvider.IConstraintElement constraint) {
            return 0;
        }

        @Override
        public int minValues(IGrammarConstraintProvider.IConstraintElement constraint) {
            return 0;
        }

        @Override
        public String toString(String prefix) {
            String newPrefix = "  " + prefix;
            StringBuilder r = new StringBuilder();
            r.append("Group {");
            for (Quantity child : this.children) {
                r.append("\n");
                r.append(newPrefix);
                r.append(child.getConstraintElement());
                r.append(" => ");
                r.append(child.toString(newPrefix));
            }
            r.append("\n");
            r.append(prefix);
            r.append("}");
            return r.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MVFeature2AssignmentAmbiguous
    extends Feature2Assignment {
        protected List<IGrammarConstraintProvider.IConstraintElement> assignments;
        protected int[] quantities;
        protected List<AllocationValue> values;

        public MVFeature2AssignmentAmbiguous(List<IGrammarConstraintProvider.IConstraintElement> assignments, List<AllocationValue> values) {
            this.assignments = assignments;
            this.values = values;
            this.quantities = new int[assignments.get(0).getFeatureInfo().getAssignments().length];
        }

        @Override
        public IGrammarConstraintProvider.IFeatureInfo getFeature() {
            return this.assignments.get(0).getFeatureInfo();
        }

        @Override
        public int getQuantity(IGrammarConstraintProvider.IConstraintElement assignment) {
            if (this.isAmbiguous()) {
                return -1;
            }
            return -1;
        }

        @Override
        public List<AllocationValue> getValuesFor(IGrammarConstraintProvider.IConstraintElement assignment) {
            return this.assignments.contains(assignment) ? this.values : Collections.emptyList();
        }

        @Override
        public boolean isAmbiguous() {
            int undefs = 0;
            for (IGrammarConstraintProvider.IConstraintElement ass : this.assignments) {
                if (this.quantities[ass.getFeatureAssignmentID()] != -1) continue;
                ++undefs;
            }
            return undefs > 1;
        }

        @Override
        public void setQuantity(IGrammarConstraintProvider.IConstraintElement assignment, int quantity) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MVFeature2AssignmentUnambiguous
    extends Feature2Assignment {
        protected IGrammarConstraintProvider.IConstraintElement assignment;
        protected List<AllocationValue> values;

        public MVFeature2AssignmentUnambiguous(IGrammarConstraintProvider.IConstraintElement assignment, List<AllocationValue> values) {
            this.assignment = assignment;
            this.values = values;
        }

        @Override
        public IGrammarConstraintProvider.IFeatureInfo getFeature() {
            return this.assignment.getFeatureInfo();
        }

        @Override
        public int getQuantity(IGrammarConstraintProvider.IConstraintElement assignment) {
            return assignment == this.assignment ? this.values.size() : -1;
        }

        @Override
        public List<AllocationValue> getValuesFor(IGrammarConstraintProvider.IConstraintElement assignment) {
            return assignment == this.assignment ? this.values : Collections.emptyList();
        }

        @Override
        public boolean isAmbiguous() {
            return false;
        }

        @Override
        public void setQuantity(IGrammarConstraintProvider.IConstraintElement assignment, int quantity) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Quantity {
        protected IGrammarConstraintProvider.IConstraintElement constraintElement;
        protected List<? extends Allocation> instances;

        public Quantity(IGrammarConstraintProvider.IConstraintElement constraintElement, Allocation allocation) {
            this.instances = Collections.singletonList(allocation);
            this.constraintElement = constraintElement;
        }

        public Quantity(IGrammarConstraintProvider.IConstraintElement constraintElement, List<? extends Allocation> allocation) {
            this.instances = allocation;
            this.constraintElement = constraintElement;
        }

        public void accept(EObject semanticObj) {
            if (this.instances != null) {
                for (Allocation allocation : this.instances) {
                    allocation.accept(semanticObj, this.constraintElement);
                }
            }
        }

        public List<? extends Allocation> getAllocations() {
            return this.instances;
        }

        public IGrammarConstraintProvider.IConstraintElement getConstraintElement() {
            return this.constraintElement;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String prefix) {
            if (this.instances == null) {
                return "(null)";
            }
            if (this.instances.isEmpty()) {
                return "(empty)";
            }
            if (!this.constraintElement.isMany() && this.instances.size() < 2) {
                return this.instances.get(0).toString(prefix);
            }
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            for (Allocation allocation : this.instances) {
                buf.append("\n");
                buf.append(String.valueOf(prefix) + "  ");
                buf.append(allocation.toString(String.valueOf(prefix) + "  "));
            }
            buf.append("\n");
            buf.append(prefix);
            buf.append("]");
            return buf.toString();
        }
    }

    protected abstract class SVFeature2Assignment
    extends Feature2Assignment {
        protected boolean optional;
        protected AllocationValue value;

        public SVFeature2Assignment(boolean optional, AllocationValue value) {
            this.optional = optional;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SVFeature2AssignmentAmbiguous
    extends SVFeature2Assignment {
        protected List<IGrammarConstraintProvider.IConstraintElement> assignments;
        protected Boolean[] enabled;

        public SVFeature2AssignmentAmbiguous(List<IGrammarConstraintProvider.IConstraintElement> assignments, boolean optional, AllocationValue value) {
            super(optional, value);
            this.assignments = assignments;
            this.enabled = new Boolean[assignments.get(0).getFeatureInfo().getAssignments().length];
            Arrays.fill((Object[])this.enabled, null);
        }

        @Override
        public IGrammarConstraintProvider.IFeatureInfo getFeature() {
            return this.assignments.get(0).getFeatureInfo();
        }

        @Override
        public int getQuantity(IGrammarConstraintProvider.IConstraintElement assignment) {
            if (this.isAmbiguous() || !this.assignments.contains(assignment)) {
                return -1;
            }
            Boolean en = this.enabled[assignment.getFeatureAssignmentID()];
            return en != null && en != false ? 1 : 0;
        }

        @Override
        public List<AllocationValue> getValuesFor(IGrammarConstraintProvider.IConstraintElement assignment) {
            if (this.assignments.contains(assignment)) {
                Boolean en = this.enabled[assignment.getFeatureAssignmentID()];
                if (en == null && !this.isAmbiguous()) {
                    for (IGrammarConstraintProvider.IConstraintElement ass : this.assignments) {
                        if (this.enabled[ass.getFeatureAssignmentID()] != Boolean.TRUE) continue;
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(this.value);
                }
                if (Boolean.TRUE.equals(en)) {
                    return Collections.singletonList(this.value);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public boolean isAmbiguous() {
            int undefined = 0;
            for (IGrammarConstraintProvider.IConstraintElement ass : this.assignments) {
                if (this.enabled[ass.getFeatureAssignmentID()] != null) continue;
                ++undefined;
            }
            return undefined > 1;
        }

        @Override
        public void setQuantity(IGrammarConstraintProvider.IConstraintElement assignment, int quantity) {
            this.enabled[assignment.getFeatureAssignmentID()] = quantity != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SVFeature2AssignmentUnambiguous
    extends SVFeature2Assignment {
        protected IGrammarConstraintProvider.IConstraintElement assignment;

        public SVFeature2AssignmentUnambiguous(IGrammarConstraintProvider.IConstraintElement assignment, boolean optional, AllocationValue value) {
            super(optional, value);
            this.assignment = assignment;
        }

        @Override
        public IGrammarConstraintProvider.IFeatureInfo getFeature() {
            return this.assignment.getFeatureInfo();
        }

        @Override
        public int getQuantity(IGrammarConstraintProvider.IConstraintElement assignment) {
            return 1;
        }

        @Override
        public List<AllocationValue> getValuesFor(IGrammarConstraintProvider.IConstraintElement assignment) {
            if (assignment == this.assignment) {
                return Collections.singletonList(this.value);
            }
            return Collections.emptyList();
        }

        @Override
        public boolean isAmbiguous() {
            return false;
        }

        @Override
        public void setQuantity(IGrammarConstraintProvider.IConstraintElement assignment, int quantity) {
        }
    }
}

