/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.serializer.sequencer.AbstractSemanticSequencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeModelSemanticSequencer
extends AbstractSemanticSequencer {
    @Override
    public void createSequence(EObject context, EObject semanticObject) {
        BidiTreeIterator<INode> ti = NodeModelUtils.findActualNodeFor(semanticObject).getAsTreeIterable().iterator();
        while (ti.hasNext()) {
            INode node = ti.next();
            if (node instanceof ILeafNode && ((ILeafNode)node).isHidden()) continue;
            EObject ge = node.getGrammarElement();
            if (ge instanceof RuleCall) {
                RuleCall rc = (RuleCall)ge;
                if (rc.getRule() == context || GrammarUtil.containedAssignments(rc) == null) continue;
                if (rc.getRule().getType().getClassifier() instanceof EClass) {
                    this.acceptSemantic(semanticObject, rc, node.getSemanticElement(), node);
                } else {
                    this.acceptSemantic(semanticObject, rc, NodeModelUtils.getTokenText(node), node);
                }
                if (node.getSemanticElement() == semanticObject) continue;
                ti.prune();
                continue;
            }
            if (ge instanceof Keyword) {
                Keyword kw = (Keyword)ge;
                if (GrammarUtil.containingAssignment(kw) == null) continue;
                this.acceptSemantic(semanticObject, kw, node.getText(), node);
                continue;
            }
            if (ge instanceof Action) {
                Action a = (Action)ge;
                if (a.getFeature() != null) {
                    this.acceptSemantic(semanticObject, a, node.getSemanticElement(), node);
                }
                if (node.getSemanticElement() == semanticObject) continue;
                ti.prune();
                continue;
            }
            if (!(ge instanceof CrossReference)) continue;
            CrossReference cr = (CrossReference)ge;
            RuleCall rc = (RuleCall)cr.getTerminal();
            EReference ref = GrammarUtil.getReference(cr);
            this.acceptSemantic(semanticObject, rc, node.getSemanticElement().eGet((EStructuralFeature)ref), node);
        }
    }

    protected boolean acceptSemantic(EObject semanticObject, AbstractElement ele, Object value, INode node) {
        EStructuralFeature feat;
        Assignment ass = GrammarUtil.containingAssignment(ele);
        int index = -2;
        if (ass != null && (feat = semanticObject.eClass().getEStructuralFeature(ass.getFeature())) != null) {
            index = feat.isMany() ? ((List)semanticObject.eGet(feat)).indexOf(value) : -1;
        }
        String token = node.getText().trim();
        if (ele instanceof Action) {
            if (((Action)ele).getFeature() != null) {
                if (this.sequenceAcceptor.enterAssignedAction((Action)ele, (EObject)value, (ICompositeNode)node)) {
                    this.createSequence(ele, (EObject)value);
                    this.sequenceAcceptor.leaveAssignedAction((Action)ele, (EObject)value);
                }
                return true;
            }
        } else if (GrammarUtil.containingCrossReference(ele) != null) {
            if (ele instanceof RuleCall) {
                RuleCall rc = (RuleCall)ele;
                if (rc.getRule() instanceof ParserRule) {
                    this.sequenceAcceptor.acceptAssignedCrossRefDatatype(rc, token, (EObject)value, index, (ICompositeNode)node);
                    return true;
                }
                if (rc.getRule() instanceof TerminalRule) {
                    this.sequenceAcceptor.acceptAssignedCrossRefTerminal(rc, token, (EObject)value, index, (ILeafNode)node);
                    return true;
                }
                if (rc.getRule() instanceof EnumRule) {
                    this.sequenceAcceptor.acceptAssignedCrossRefEnum(rc, token, (EObject)value, index, (ICompositeNode)node);
                    return true;
                }
            }
        } else if (ass != null) {
            if (ele instanceof RuleCall) {
                RuleCall rc = (RuleCall)ele;
                if (rc.getRule() instanceof ParserRule) {
                    if (rc.getRule().getType().getClassifier() instanceof EClass) {
                        if (this.sequenceAcceptor.enterAssignedParserRuleCall(rc, (EObject)value, (ICompositeNode)node)) {
                            this.createSequence(rc.getRule(), (EObject)value);
                            this.sequenceAcceptor.leaveAssignedParserRuleCall(rc, (EObject)value);
                        } else {
                            this.sequenceAcceptor.acceptAssignedDatatype(rc, token, value, index, (ICompositeNode)node);
                        }
                    }
                    return true;
                }
                if (rc.getRule() instanceof TerminalRule) {
                    this.sequenceAcceptor.acceptAssignedTerminal(rc, token, value, index, (ILeafNode)node);
                    return true;
                }
                if (rc.getRule() instanceof EnumRule) {
                    this.sequenceAcceptor.acceptAssignedEnum(rc, token, value, index, (ICompositeNode)node);
                    return true;
                }
            } else if (ele instanceof Keyword) {
                if (GrammarUtil.isBooleanAssignment(ass)) {
                    this.sequenceAcceptor.acceptAssignedKeyword((Keyword)ele, token, true, index, (ILeafNode)node);
                } else {
                    this.sequenceAcceptor.acceptAssignedKeyword((Keyword)ele, token, (String)value, index, (ILeafNode)node);
                }
                return true;
            }
        }
        return false;
    }

    private INode findContextNode(EObject semanticObject) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor(semanticObject);
        for (INode next : node.getAsTreeIterable()) {
            if (next.getGrammarElement() instanceof RuleCall) {
                return next;
            }
            if (!(next.getGrammarElement() instanceof ParserRule) || !(((ParserRule)next.getGrammarElement()).getType().getClassifier() instanceof EClass)) continue;
            return next;
        }
        throw new RuntimeException("no context found");
    }

    public Iterable<EObject> findContexts(EObject semanitcObject, boolean consultContainer, Iterable<EObject> contextCandidates) {
        EObject ctx = this.findContextNode(semanitcObject).getGrammarElement();
        if (ctx instanceof RuleCall) {
            return Collections.singletonList(((RuleCall)ctx).getRule());
        }
        return Collections.singletonList(ctx);
    }
}

