/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.resource.IFragmentProvider;

@Singleton
public class XtextFragmentProvider
implements IFragmentProvider {
    private static final String PREFIX = "XtextFragmentProvider::";

    public EObject getEObject(Resource resource, String fragment, IFragmentProvider.Fallback fallback) {
        if (!fragment.startsWith(PREFIX)) {
            return fallback.getEObject(fragment);
        }
        String fragmentWithoutPrefix = fragment.substring(PREFIX.length());
        String[] splitted = fragmentWithoutPrefix.split("/");
        if (splitted.length == 0) {
            return fallback.getEObject(fragment);
        }
        String firstPart = splitted[0];
        Grammar grammar = null;
        for (EObject content : resource.getContents()) {
            Grammar g;
            if (!(content instanceof Grammar) || !firstPart.equals((g = (Grammar)content).getName())) continue;
            grammar = g;
            if (splitted.length != 1) break;
            return grammar;
        }
        if (splitted.length == 2) {
            return GrammarUtil.findRuleForName(grammar, splitted[1]);
        }
        return fallback.getEObject(fragment);
    }

    public String getFragment(EObject obj, IFragmentProvider.Fallback fallback) {
        if (obj instanceof Grammar) {
            return this.caseGrammar((Grammar)obj);
        }
        if (obj instanceof AbstractRule) {
            return this.caseAbstractRule((AbstractRule)obj, fallback);
        }
        return fallback.getFragment(obj);
    }

    public String caseGrammar(Grammar obj) {
        return PREFIX + obj.getName();
    }

    public String caseAbstractRule(AbstractRule obj, IFragmentProvider.Fallback fallback) {
        return String.valueOf(this.getFragment(obj.eContainer(), fallback)) + "/" + obj.getName();
    }
}

