/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.util;

import java.net.URL;

import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/** A singleton image provider, which caches image descriptors */
public class ImageProvider {

	private ImageProvider() {
	}

	private static ImageProvider instance;

	public static ImageProvider getInstance() {
		if (instance == null) {
			instance = new ImageProvider();
		}
		return instance;
	}

	private Image linkIcon = null;
	private Image linkUniDirIcon = null;
	private Image aggregIcon = null;
	private Image aggregUniDirIcon = null;
	private Image invAggregIcon = null;

	private Image emptyLinksIcon = null;
	private Image sortInstancesIcon = null;
	private Image sortLinksIcon = null;
	private Image sortLinksByTypeIcon = null;
	private Image sortNumericallyIcon = null;
	private Image showDerivedLinksIcon = null;
	private Image showFullQualifiedNamesIcon = null;
	private Image showMultiplicityIcon = null;
	private Image showOppositeLinksIcon = null;

	private Image rangeIcon = null;
	private Image containerIcon = null;
	private Image emptyMetaclassesIcon = null;
	private Image packageIcon = null;
	private Image derivedInstancesIcon = null;
	private Image derivationTreeIcon = null;
	private Image attributeIcon = null;
	private Image emptyAttributeIcon = null;
	private Image orderingIcon = null;

	private ImageDescriptor increaseFontSizeIcon = null;
	private ImageDescriptor decreaseFontSizeIcon = null;
	private ImageDescriptor restoreFontSizeIcon = null;

	private Image hideEmptyColumnsIcon = null;
	private Image commonColumnsIcon = null;

	private static final String LINK_ICON_PATH = "/icons/full/ctool16/link.gif";
	private static final String LINK_UNIDIR_ICON_PATH = "/icons/full/ctool16/link_unidir.gif";
	private static final String AGGREG_ICON_PATH = "/icons/full/ctool16/aggreg.gif";
	private static final String AGGREG_UNIDIR_ICON_PATH = "/icons/full/ctool16/aggreg_unidir.gif";
	private static final String INV_AGGREG_ICON_PATH = "/icons/full/ctool16/inv_aggreg.gif";
	private static final String EMPTY_LINKS_ICON_PATH = "/icons/full/ctool16/empty_links.gif";
	private static final String SORT_INSTANCES_ICON_PATH = "/icons/full/ctool16/sort.gif";
	private static final String SORT_LINKS_ICON_PATH = "/icons/full/ctool16/sort_links.gif";
	private static final String SORT_LINKS_BY_TYPE_ICON_PATH = "/icons/full/ctool16/sort_links_by_type.gif";
	private static final String SORT_NUMERICALLY_ICON_PATH = "/icons/full/ctool16/sort_num.gif";
	private static final String SHOW_DERIVED_LINKS_ICON_PATH = "/icons/full/ctool16/derived.gif";
	private static final String SHOW_FULL_QUALIFIED_NAMES_ICON_PATH = "/icons/full/ctool16/full_name.gif";
	private static final String RANGE_ICON_PATH = "/icons/full/ctool16/range.gif";
	private static final String SHOW_MULTIPLICITY_ICON_PATH = "/icons/full/ctool16/multiplicity.gif";
	private static final String SHOW_OPPOSITE_LINKS_ICON_PATH = "/icons/full/ctool16/opposite_links.gif";
	private static final String CONTAINER_ICON_PATH = "/icons/full/ctool16/container.gif";
	private static final String EMPTY_METACLASSES_ICON_PATH = "/icons/full/ctool16/zero.gif";
	private static final String PACKAGE_ICON_PATH = "/icons/full/ctool16/package.gif";
	private static final String DERIVED_INSTANCES_ICON_PATH = "/icons/full/ctool16/derived_instances.gif";
	private static final String DERIVATION_TREE_ICON_PATH = "/icons/full/ctool16/derivation_tree.gif";
	private static final String ATTRIBUTE_ICON_PATH = "/icons/full/ctool16/attributes.gif";
	private static final String EMPTY_ATTRIBUTE_ICON_PATH = "/icons/full/ctool16/empty_attributes.gif";
	private static final String INCREASE_FONT_SIZE_ICON_PATH = "/icons/full/ctool16/increase_font_size.gif";
	private static final String DECREASE_FONT_SIZE_ICON_PATH = "/icons/full/ctool16/decrease_font_size.gif";
	private static final String RESTORE_FONT_SIZE_ICON_PATH = "/icons/full/ctool16/restore_font_size.gif";
	private static final String HIDE_EMPTY_COLUMNS_ICON_PATH = "/icons/full/ctool16/non-zero.gif";
	private static final String COMMON_COLUMNS_ICON_PATH = "/icons/full/ctool16/common_columns.gif";
	private static final String ORDERING_ICON_PATH = "/icons/full/ctool16/ordering.gif";

	/**
	 * Create an image descriptor from a resource
	 * 
	 * @param resourcePath
	 *            the path of the resource (in the bundle)
	 * @return the image descriptor
	 */
	private ImageDescriptor createImageDescriptor(String resourcePath) {
		URL url = MoDiscoEditorPlugin.getPlugin().getBundle().getResource(resourcePath);
		if (url == null) {
			MoDiscoEditorPlugin.INSTANCE.log("Resource not found: " + resourcePath);
			return ImageDescriptor.getMissingImageDescriptor();
		}
		return ImageDescriptor.createFromURL(url);
	}

	/** Return the icon representing a bidirectional link */
	public Image getLinkIcon() {
		if (this.linkIcon == null) {
			this.linkIcon = createImageDescriptor(LINK_ICON_PATH).createImage();
		}
		return this.linkIcon;
	}

	/** Return the icon representing an unidirectional link */
	public Image getUnidirectionalLinkIcon() {
		if (this.linkUniDirIcon == null) {
			this.linkUniDirIcon = createImageDescriptor(LINK_UNIDIR_ICON_PATH).createImage();
		}
		return this.linkUniDirIcon;
	}

	/** Return the icon representing a composition link */
	public Image getAggregIcon() {
		if (this.aggregIcon == null) {
			this.aggregIcon = createImageDescriptor(AGGREG_ICON_PATH).createImage();
		}
		return this.aggregIcon;
	}

	/** Return the icon representing an unidirectional composition link */
	public Image getUnidirectionalAggregIcon() {
		if (this.aggregUniDirIcon == null) {
			this.aggregUniDirIcon = createImageDescriptor(AGGREG_UNIDIR_ICON_PATH).createImage();
		}
		return this.aggregUniDirIcon;
	}

	/** Return the icon representing a reverse composition link */
	public Image getInvAggregIcon() {
		if (this.invAggregIcon == null) {
			this.invAggregIcon = createImageDescriptor(INV_AGGREG_ICON_PATH).createImage();
		}
		return this.invAggregIcon;
	}

	/** Return the icon representing empty links */
	public Image getEmptyLinksIcon() {
		if (this.emptyLinksIcon == null) {
			this.emptyLinksIcon = createImageDescriptor(EMPTY_LINKS_ICON_PATH).createImage();
		}
		return this.emptyLinksIcon;
	}

	/** Return the icon representing sorting of instances */
	public Image getSortInstancesIcon() {
		if (this.sortInstancesIcon == null) {
			this.sortInstancesIcon = createImageDescriptor(SORT_INSTANCES_ICON_PATH).createImage();
		}
		return this.sortInstancesIcon;
	}

	/** Return the icon representing sorting of links */
	public Image getSortLinksIcon() {
		if (this.sortLinksIcon == null) {
			this.sortLinksIcon = createImageDescriptor(SORT_LINKS_ICON_PATH).createImage();
		}
		return this.sortLinksIcon;
	}

	/** Return the icon representing sorting of links by type */
	public Image getSortLinksByTypeIcon() {
		if (this.sortLinksByTypeIcon == null) {
			this.sortLinksByTypeIcon = createImageDescriptor(SORT_LINKS_BY_TYPE_ICON_PATH)
					.createImage();
		}
		return this.sortLinksByTypeIcon;
	}

	/** Return the icon representing sorting numerically */
	public Image getSortNumericallyIcon() {
		if (this.sortNumericallyIcon == null) {
			this.sortNumericallyIcon = createImageDescriptor(SORT_NUMERICALLY_ICON_PATH)
					.createImage();
		}
		return this.sortNumericallyIcon;
	}

	/** Return the icon representing derived links */
	public Image getShowDerivedLinksIcon() {
		if (this.showDerivedLinksIcon == null) {
			this.showDerivedLinksIcon = createImageDescriptor(SHOW_DERIVED_LINKS_ICON_PATH)
					.createImage();
		}
		return this.showDerivedLinksIcon;
	}

	/** Return the icon representing full qualified names */
	public Image getShowFullQualifiedNamesIcon() {
		if (this.showFullQualifiedNamesIcon == null) {
			this.showFullQualifiedNamesIcon = createImageDescriptor(
					SHOW_FULL_QUALIFIED_NAMES_ICON_PATH).createImage();
		}
		return this.showFullQualifiedNamesIcon;
	}

	/** Return the icon representing a range */
	public Image getRangeIcon() {
		if (this.rangeIcon == null) {
			this.rangeIcon = createImageDescriptor(RANGE_ICON_PATH).createImage();
		}
		return this.rangeIcon;
	}

	/** Return the multiplicity icon */
	public Image getShowMultiplicityIcon() {
		if (this.showMultiplicityIcon == null) {
			this.showMultiplicityIcon = createImageDescriptor(SHOW_MULTIPLICITY_ICON_PATH)
					.createImage();
		}
		return this.showMultiplicityIcon;
	}

	/** Return the "opposite links" icon */
	public Image getShowOppositeLinksIcon() {
		if (this.showOppositeLinksIcon == null) {
			this.showOppositeLinksIcon = createImageDescriptor(SHOW_OPPOSITE_LINKS_ICON_PATH)
					.createImage();
		}
		return this.showOppositeLinksIcon;
	}

	/** Return the "container" icon */
	public Image getContainerIcon() {
		if (this.containerIcon == null) {
			this.containerIcon = createImageDescriptor(CONTAINER_ICON_PATH).createImage();
		}
		return this.containerIcon;
	}

	/** Return the "show empty metaclasses" icon */
	public Image getShowEmptyMetaclassesIcon() {
		if (this.emptyMetaclassesIcon == null) {
			this.emptyMetaclassesIcon = createImageDescriptor(EMPTY_METACLASSES_ICON_PATH)
					.createImage();
		}
		return this.emptyMetaclassesIcon;
	}

	/** Return the "package" icon */
	public Image getPackageIcon() {
		if (this.packageIcon == null) {
			this.packageIcon = createImageDescriptor(PACKAGE_ICON_PATH).createImage();
		}
		return this.packageIcon;
	}

	/** Return the "derived instances" icon */
	public Image getDerivedInstancesIcon() {
		if (this.derivedInstancesIcon == null) {
			this.derivedInstancesIcon = createImageDescriptor(DERIVED_INSTANCES_ICON_PATH)
					.createImage();
		}
		return this.derivedInstancesIcon;
	}

	/** Return the "derivation tree" icon */
	public Image getDerivationTreeIcon() {
		if (this.derivationTreeIcon == null) {
			this.derivationTreeIcon = createImageDescriptor(DERIVATION_TREE_ICON_PATH)
					.createImage();
		}
		return this.derivationTreeIcon;
	}

	/** Return the "attribute" icon */
	public Image getAttributeIcon() {
		if (this.attributeIcon == null) {
			this.attributeIcon = createImageDescriptor(ATTRIBUTE_ICON_PATH).createImage();
		}
		return this.attributeIcon;
	}

	/** Return the "empty attributes" icon */
	public Image getEmptyAttributeIcon() {
		if (this.emptyAttributeIcon == null) {
			this.emptyAttributeIcon = createImageDescriptor(EMPTY_ATTRIBUTE_ICON_PATH)
					.createImage();
		}
		return this.emptyAttributeIcon;
	}

	/** Return the "increase font size" icon */
	public ImageDescriptor getIncreaseFontSizeIcon() {
		if (this.increaseFontSizeIcon == null) {
			this.increaseFontSizeIcon = createImageDescriptor(INCREASE_FONT_SIZE_ICON_PATH);
		}
		return this.increaseFontSizeIcon;
	}

	/** Return the "decrease font size" icon */
	public ImageDescriptor getDecreaseFontSizeIcon() {
		if (this.decreaseFontSizeIcon == null) {
			this.decreaseFontSizeIcon = createImageDescriptor(DECREASE_FONT_SIZE_ICON_PATH);
		}
		return this.decreaseFontSizeIcon;
	}

	/** Return the "restore font size" icon */
	public ImageDescriptor getRestoreFontSizeIcon() {
		if (this.restoreFontSizeIcon == null) {
			this.restoreFontSizeIcon = createImageDescriptor(RESTORE_FONT_SIZE_ICON_PATH);
		}
		return this.restoreFontSizeIcon;
	}

	/** Return the "hide empty columns" icon */
	public Image getHideEmptyColumnsIcon() {
		if (this.hideEmptyColumnsIcon == null) {
			this.hideEmptyColumnsIcon = createImageDescriptor(HIDE_EMPTY_COLUMNS_ICON_PATH)
					.createImage();
		}
		return this.hideEmptyColumnsIcon;
	}

	/** Return the "common columns" icon */
	public Image getCommonColumnsIcon() {
		if (this.commonColumnsIcon == null) {
			this.commonColumnsIcon = createImageDescriptor(COMMON_COLUMNS_ICON_PATH).createImage();
		}
		return this.commonColumnsIcon;
	}

	/** Return the "ordering" icon */
	public Image getOrderingIcon() {
		if (this.orderingIcon == null) {
			this.orderingIcon = createImageDescriptor(ORDERING_ICON_PATH).createImage();
		}
		return this.orderingIcon;
	}
}
