/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.discoverer.ui;


import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.DiscovererLaunchConstants;
import org.eclipse.gmt.modisco.workflow.AbstractDriverCore;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;

public class LaunchDriverModiscoDiscoverer extends AbstractDriverCore implements DriverInterface {
	
	public LaunchDriverModiscoDiscoverer() {
		
	}

	public String getTypeLaunchConfig() {
		return "org.eclipse.gmt.modisco.discoverersmanager.launchConfigurationType";
	}

	public List<WorkParameter> getParameters(ILaunchConfiguration configuration) {
		List<WorkParameter> parameters = new ArrayList<WorkParameter>();
		try {
			WorkParameter param = createOneWorkParameter(DiscovererLaunchConstants.discovererKind,Direction.IN,"Discoverer kind",true,String.class);
			param.setValue(createStringValue(configuration.getAttribute(DiscovererLaunchConstants.discovererKind,(String)null)));
			parameters.add(param);
			
			WorkParameter param2 = createOneWorkParameter(DiscovererLaunchConstants.discovererSourcePath,Direction.IN,"Discoverer source path",true,String.class);
			param2.setValue(createStringValue(configuration.getAttribute(DiscovererLaunchConstants.discovererSourcePath,(String)null)));
			parameters.add(param2);

			WorkParameter param3 = createOneWorkParameter(DiscovererLaunchConstants.discovererTargetPath,Direction.OUT,"Discoverer target path",true,String.class);
			param3.setValue(createStringValue(configuration.getAttribute(DiscovererLaunchConstants.discovererTargetPath,(String)null)));
			parameters.add(param3);
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return parameters;
	}
}
