/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow;

import java.util.List;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;

/**
 * API to define the workflow core
 * @author Nicolas Payneau
 */
public interface WorkflowModelInterface{

	/**
	 * Add a component in the MoDiscoWorkwlow
	 * @param modiscowork Element which represents the component
	 */
	public void addComponentWorkflow(EObject modiscowork);
	
	/**
	 * Allows to retrieve a component at index specified
	 * @param index Component index
	 * @return Return an element
	 */
	public EObject getComponent(int index);
	
	/**
	 * Change a component of MoDiscoWorkflow
	 * @param index Component index
	 * @param element The new element
	 */
	public void setComponent(int index, EObject element);
	
	/**
	 * Allows to retrieve all components of the MoDiscoWorkflow
	 * @return an element list
	 */
	public List<EObject> getAllComponents();
	
	/**
	 * Allows to delete a component at index specified
	 * @param index Component index
	 */
	public void removeComponent(int index);

	/**
	 * Allows to initialize or load the workflow
	 * @param configuration Launch configuration associated
	 * @param path Workflow resource path
	 */
	public void initialization(ILaunchConfiguration configuration, String path);
	
	/**
	 * Allows to save the resource
	 * @param configuration Launch configuration associated
	 * @param onlyLaunch If we want to save only launch (for revert)
	 */
	public void save(ILaunchConfigurationWorkingCopy configuration, boolean onlyLaunch);
		
	/**
	 * Allows to move the resource
	 * @param path Workflow resource path
	 */
	public void moveResource(String path);

	/**
	 * Allows to remove the resource
	 * @param path Workflow resource path
	 */
	void removeResource(String resourcePath);

	/**
	 * Allows to export the workflow
	 * @param configuration The launch configuration associated
	 * @param outputPath The output path 
	 */
	public void exportWorkflow(ILaunchConfiguration configuration, String outputPath);
	
	/**
	 * To up a modiscoElement in the workflow
	 * @param indexSelected Index of item selected
	 */
	public void upMoDisoWork(int indexSelected);
	
	/**
	 * To down a modiscoElement in the workflow
	 * @param indexSelected Index of item selected
	 */
	public void downMoDiscoWork(int indexSelected);

	/**
	 * Allows to synchronize all resources contained in the workflow
	 * @param elements All elements contained in the MoDiscoWorkflow
	 */
	public void synchronization(List<Element> elements);
	
}
