/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.j2se5.popup.actions;

import java.util.logging.Logger;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.j2se5.J2SE5Discoverer;
import org.eclipse.gmt.modisco.j2se5.J2se5DiscovererInterface;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;


public class FromJavaProjectToJ2se5 implements IObjectActionDelegate {

	protected final Logger logger = Logger.getLogger(ATLLogger.LOGGER_ID);
	protected IJavaProject project = null;
	protected IPath path;
	private IWorkbenchPart workbench;
	/**
	 * Constructor for Action1.
	 */
	public FromJavaProjectToJ2se5() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.workbench = targetPart;
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		// calculate path of target model
		this.path = this.project.getProject().getLocation().addTrailingSeparator().append(
							this.project.getElementName()).addFileExtension("j2se5");
		
		// discovering
		Job job = new Job("Discovering j2se5 model") {
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				IStatus result = null;
				AtlLogHandler logHandler = new AtlLogHandler(FromJavaProjectToJ2se5.this.path.toString() + ".log");
				FromJavaProjectToJ2se5.this.logger.addHandler(logHandler);
				try {
					J2se5DiscovererInterface disco = new J2SE5Discoverer();
					Tools.saveModel(disco.getJ2SE5ModelFromJavaSource(FromJavaProjectToJ2se5.this.project), FromJavaProjectToJ2se5.this.path.toString());
					
					result = Status.OK_STATUS;
				}catch (Exception e) {
					result = Status.CANCEL_STATUS;
				} finally {
					FromJavaProjectToJ2se5.this.logger.removeHandler(logHandler);
					logHandler.close();
					try {
						FromJavaProjectToJ2se5.this.project.getCorrespondingResource().refreshLocal(1, monitor);
					} catch (Exception e1) {
						//give up
					}	
				}
				return result;
			}
		};
		//triggers opening of the j2se5 model as soon as it is saved
		job.addJobChangeListener(new JobChangeAdapter() {
			public void done(IJobChangeEvent event) {
				//access UI resources so that we can obtain the current eclipse workbench activePage
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						try {
							IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
							IFile ifile = root.getFileForLocation(FromJavaProjectToJ2se5.this.path);
							if (ifile.exists()) {
								IWorkbenchPage page = FromJavaProjectToJ2se5.this.workbench.getSite().getPage();
								//programmatically opens the j2se5 model using the default editor if one is present
								IDE.openEditor(page, ifile);
							}
						} catch (PartInitException e) {
							e.printStackTrace();
						}
					}
				});
			}
		});
		
		job.schedule();
	}

	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		// If a project is selected then set it as the project to use if action
		// is called
		this.project = (IJavaProject) ((IStructuredSelection) selection).getFirstElement();
	}

}
