package org.eclipse.gmt.modisco.common.editor.editors;

import java.util.ArrayList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.gmt.modisco.common.editor.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.common.editor.editors.table.TableEditor;
import org.eclipse.gmt.modisco.common.editor.editors.table.TableEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MetaclassViewerMenuManager extends MenuManager implements IMenuListener {

	private final EditorConfiguration editorConfiguration;
	private final MetaclassViewer metaclassViewer;

	public MetaclassViewerMenuManager(MetaclassViewer metaclassViewer,
			EditorConfiguration editorConfiguration) {
		this.metaclassViewer = metaclassViewer;
		this.editorConfiguration = editorConfiguration;
		addMenuActions();
		addMenuListener(this);
	}

	private void addMenuActions() {
		this.add(this.openTableEditorAction);
	}

	/** This action opens a table editor on the selected metaclass */
	protected IAction openTableEditorAction = new Action(MoDiscoEditorPlugin.INSTANCE
			.getString("_UI_OpenTableEditorOnSelection_menu_item")) {
		@Override
		public void run() {
			String[] selectedMetaclasses = MetaclassViewerMenuManager.this.metaclassViewer
					.getSelectedMetaclassesQualifiedNames();
			ArrayList<EObject> elements = new ArrayList<EObject>();

			for (String selectedMetaclass : selectedMetaclasses) {
				InstancesForMetaclass instancesForMetaclass = MetaclassViewerMenuManager.this.editorConfiguration
						.getInstancesForMetaclasses().getInstancesForMetaclass(selectedMetaclass);
				if (instancesForMetaclass != null) {
					elements.addAll(instancesForMetaclass.getElements());
					if (MetaclassViewerMenuManager.this.editorConfiguration
							.isDisplayInstancesOfSubclasses()) {
						elements.addAll(instancesForMetaclass.getDerivedElements());
					}
				}
			}

			TableEditorInput tableEditorInput = new TableEditorInput(
					MetaclassViewerMenuManager.this.editorConfiguration, elements,
					getDescriptionFor(selectedMetaclasses));

			IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow()
					.getActivePage();
			try {
				IDE.openEditor(activePage, tableEditorInput, TableEditor.EDITOR_ID, true);
			} catch (PartInitException e) {
				MoDiscoEditorPlugin.INSTANCE.log(e);
			}
		}

		private String getDescriptionFor(String[] selectedMetaclasses) {
			if (selectedMetaclasses.length < 1)
				throw new IllegalArgumentException();

			StringBuilder description = new StringBuilder();
			description.append("Instances of ");
			description.append(selectedMetaclasses[0]);
			for (int i = 1; i < selectedMetaclasses.length; i++) {
				description.append(", " + selectedMetaclasses[i]);
			}
			return description.toString();
		}
	};

	public void menuAboutToShow(IMenuManager manager) {
		EObject[] selectedMetaclasses = this.metaclassViewer.getSelectedMetaclasses();
		this.openTableEditorAction.setEnabled(selectedMetaclasses.length > 0);
	}

}
