/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.common.editor.extension.j2se5;

import java.net.URL;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class IconProvider implements
		org.eclipse.gmt.modisco.common.editor.extensions.icons.IconProvider {

	private Image classImage = createImage("icons/class.gif");
	private Image classInstanceCreationImage = createImage("icons/class_instantiation.gif");
	private Image interfaceImage = createImage("icons/interface.gif");
	private Image booleanLiteralImage = createImage("icons/boolean_literal.gif");
	private Image characterLiteralImage = createImage("icons/character_literal.gif");
	private Image nullLiteralImage = createImage("icons/null_literal.gif");
	private Image integerLiteralImage = createImage("icons/integer_literal.gif");
	private Image stringLiteralImage = createImage("icons/string_literal.gif");
	private Image blockImage = createImage("icons/block.gif");
	private Image blockCommentImage = createImage("icons/block_comment.gif");
	private Image commentImage = createImage("icons/comment.gif");
	private Image assignmentImage = createImage("icons/assignment.gif");
	private Image expressionImage = createImage("icons/expression.gif");
	private Image unresolvedItemImage = createImage("icons/unresolved.gif");
	private Image loopImage = createImage("icons/loop.gif");
	private Image packageImage = createImage("icons/package.gif");
	private Image modelImage = createImage("icons/model.gif");
	private Image wildcardTypeImage = createImage("icons/wildcard_type.gif");
	private Image fieldDeclarationImage = createImage("icons/field_declaration.gif");
	private Image fieldAccessImage = createImage("icons/field_access.gif");
	private Image methodDeclarationImage = createImage("icons/method.gif");
	private Image methodInvocationImage = createImage("icons/method_invocation.gif");
	private Image throwImage = createImage("icons/throw.gif");
	private Image catchImage = createImage("icons/catch_clause.gif");
	private Image castImage = createImage("icons/cast.gif");
	private Image parameterDeclarationImage = createImage("icons/parameter.gif");
	private Image parenthesizedExpressionImage = createImage("icons/parenthesized_expr.gif");
	private Image importImage = createImage("icons/import.gif");
	private Image namedElementRefImage = createImage("icons/ref.gif");
	private Image conditionalExprImage = createImage("icons/conditional_expr.gif");
	private Image prefixExprImage = createImage("icons/prefix.gif");
	private Image infixExprImage = createImage("icons/infix.gif");
	private Image postfixExprImage = createImage("icons/postfix.gif");

	public IconProvider() {
	}

	public Image getIcon(EObject eObject) {

		String className = eObject.eClass().getName();

		if ("ClassDeclaration".equals(className)) {
			return this.classImage;
		}
		
		if ("ClassInstanceCreation".equals(className)) {
			return this.classInstanceCreationImage;
		}

		if ("InterfaceDeclaration".equals(className)) {
			return this.interfaceImage;
		}

		if ("BooleanLiteral".equals(className)) {
			return this.booleanLiteralImage;
		}

		if ("CharacterLiteral".equals(className)) {
			return this.characterLiteralImage;
		}

		if ("NullLiteral".equals(className)) {
			return this.nullLiteralImage;
		}
		
		if ("NumberLiteral".equals(className)) {
			return this.integerLiteralImage;
		}
		
		if ("StringLiteral".equals(className)) {
			return this.stringLiteralImage;
		}
		
		if ("Block".equals(className)) {
			return this.blockImage;
		}
		
		if ("BlockComment".equals(className)) {
			return this.blockCommentImage;
		}
		
		if ("LineComment".equals(className)) {
			return this.commentImage;
		}
		
		if ("Assignment".equals(className)) {
			return this.assignmentImage;
		}
		
		if ("ExpressionStatement".equals(className)) {
			return this.expressionImage;
		}
		
		if ("UnresolvedItem".equals(className)) {
			return this.unresolvedItemImage;
		}
		
		if ("WhileStatement".equals(className)) {
			return this.loopImage;
		}
		
		if ("ForStatement".equals(className)) {
			return this.loopImage;
		}
		
		if ("PackageDeclaration".equals(className)) {
			return this.packageImage;
		}
		
		if ("Model".equals(className)) {
			return this.modelImage;
		}
		
		if ("WildCardType".equals(className)) {
			return this.wildcardTypeImage;
		}
		
		if ("MethodDeclaration".equals(className)) {
			return this.methodDeclarationImage;
		}
		
		if ("MethodInvocation".equals(className)) {
			return this.methodInvocationImage;
		}
		
		if ("FieldDeclaration".equals(className)) {
			return this.fieldDeclarationImage;
		}
		
		if ("ThrowStatement".equals(className)) {
			return this.throwImage;
		}
		
		if ("CatchClause".equals(className)) {
			return this.catchImage;
		}
		
		if ("FieldAccess".equals(className)) {
			return this.fieldAccessImage;
		}
		
		if ("CastExpression".equals(className)) {
			return this.castImage;
		}
		
		if ("ParameterDeclaration".equals(className)) {
			return this.parameterDeclarationImage;
		}
		
		if ("ParenthesizedExpression".equals(className)) {
			return this.parenthesizedExpressionImage;
		}
		
		if ("ImportDeclaration".equals(className)) {
			return this.importImage;
		}
		
		if ("NamedElementRef".equals(className)) {
			return this.namedElementRefImage;
		}
		
		if ("ConditionalExpression".equals(className)) {
			return this.conditionalExprImage;
		}
		
		if ("PrefixExpression".equals(className)) {
			return this.prefixExprImage;
		}
		
		if ("InfixExpression".equals(className)) {
			return this.infixExprImage;
		}
		
		if ("PostfixExpression".equals(className)) {
			return this.postfixExprImage;
		}
		
		return null;
	}

	/**
	 * Create an image from a resource in the bundle (plugin)
	 * 
	 * @param resourcePath
	 *            the path of the resource (in the bundle)
	 * @return the image
	 */
	private Image createImage(String resourcePath) {
		URL url = Activator.getDefault().getBundle().getResource(resourcePath);
		if (url == null) {
			logError("Resource not found: " + resourcePath);
			return ImageDescriptor.getMissingImageDescriptor().createImage();
		}
		return ImageDescriptor.createFromURL(url).createImage();
	}

	private void logError(String errorMessage) {
		IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, errorMessage);
		Activator.getDefault().getLog().log(status);
	}

}
