/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constant;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.gmt.modisco.workflow.modiscowork.impl.MoDiscoWorkImpl;
import org.eclipse.gmt.modisco.workflow.ui.common.AdditionalButtonsComposite;
import org.eclipse.gmt.modisco.workflow.ui.common.MoDiscoWorkParameter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

@SuppressWarnings("restriction")
public class WorkflowTransformationTab extends AbstractLaunchConfigurationTab{

	private ScrolledComposite scrollContainer;
	private Composite rootContainer;
	private Table transformationsTable;
	private Table paramTable;
	private Composite compositeParameter;
	private AdditionalButtonsComposite gpButtonTransformation;
	private ControllerWorkflowTransformation controller;
	private boolean isValid;
	private String resourcePath;
	private ExpandItem itemParam;
	private ExpandBar bar;
	private Label labNoParam;
	private enum state{expand,collapse,block};
	private state barState;
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		this.scrollContainer = new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
		this.scrollContainer.setExpandHorizontal(true);
		this.scrollContainer.setExpandVertical(true);
		
		this.rootContainer = new Composite(this.scrollContainer, SWT.NULL);
		GridLayout layout = new GridLayout();
		this.rootContainer.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		this.scrollContainer.setContent(this.rootContainer);
		
		Label labelWFTransfo = new Label(this.rootContainer, SWT.NULL);
		labelWFTransfo.setText("Build your MoDiscoWorkflow");
		GridData gdLabel = new GridData();
		gdLabel.horizontalSpan = 3;
		labelWFTransfo.setLayoutData(gdLabel);
		GridData gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		this.transformationsTable = new Table(this.rootContainer, SWT.BORDER | SWT.V_SCROLL);
		this.transformationsTable.setLayoutData(gridData);
		this.transformationsTable.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}
			
			public void widgetSelected(SelectionEvent e) {
				dialogChangedContainer();
				loadParameter();
				WorkflowTransformationTab.this.itemParam.setHeight(WorkflowTransformationTab.this.compositeParameter.getBounds().height);
				WorkflowTransformationTab.this.bar.pack();
				WorkflowTransformationTab.this.rootContainer.pack();
			}		
		});
		this.gpButtonTransformation = new AdditionalButtonsComposite(this.rootContainer, SWT.NONE,this.transformationsTable,this.controller);
		
		createParameterBar();	
		setControl(this.rootContainer);
		setControl(this.scrollContainer);
	}
	
	private void createParameterBar() {
		this.bar = new ExpandBar (this.rootContainer, SWT.V_SCROLL);
		GridData gridDataBar = new GridData();
		gridDataBar.horizontalSpan = 2;
		gridDataBar.grabExcessHorizontalSpace = true;
		gridDataBar.horizontalAlignment = GridData.FILL;		
		this.bar.setLayoutData(gridDataBar);
		this.bar.addExpandListener(new ExpandListener(){
			public void itemCollapsed(ExpandEvent e) {
				WorkflowTransformationTab.this.barState = state.collapse;
			}
			public void itemExpanded(ExpandEvent e) {				
				WorkflowTransformationTab.this.barState = state.expand;
			}
		});
		//To repaint the bar with good size
		this.bar.addPaintListener(new PaintListener(){
			public void paintControl(PaintEvent e) {
				if(!WorkflowTransformationTab.this.itemParam.getExpanded()){
					if(WorkflowTransformationTab.this.barState== state.collapse){
						WorkflowTransformationTab.this.barState = state.block;
						WorkflowTransformationTab.this.transformationsTable.notifyListeners(SWT.Selection, null);
					}
				}else{
					if(WorkflowTransformationTab.this.barState==state.expand){
						WorkflowTransformationTab.this.barState = state.block;
						WorkflowTransformationTab.this.transformationsTable.notifyListeners(SWT.Selection, null);
					}
				}
			}
		});
		this.compositeParameter = new Composite (this.bar, SWT.NONE);
		GridLayout layoutParameter = new GridLayout();
		layoutParameter.marginTop =layoutParameter.marginBottom = 10;
		layoutParameter.verticalSpacing = 10;
		GridData gdParam = new GridData();
		gdParam.grabExcessHorizontalSpace = true;
		gdParam.grabExcessVerticalSpace = true;
		this.compositeParameter.setLayoutData(gdParam);
		this.compositeParameter.setLayout(layoutParameter);
		createParameterTable(false);
		this.itemParam = new ExpandItem (this.bar, SWT.NONE, 0);
		this.itemParam.setText("Parameters description");
		this.itemParam.setControl(this.compositeParameter);
		this.itemParam.setHeight(this.compositeParameter.computeSize(SWT.DEFAULT, SWT.DEFAULT).y);
	}

	private void createParameterTable(boolean parameter){
		for(Control c : this.compositeParameter.getChildren()){
			c.dispose();
		}
		if(!parameter){
			this.labNoParam = new Label(this.compositeParameter,SWT.NONE);
			this.labNoParam.setText("No parameter description");
		}else{
			this.paramTable = new Table(this.compositeParameter,SWT.BORDER);
			this.paramTable.setLinesVisible(true);
			this.paramTable.setHeaderVisible(true);
			TableColumn columnDirection = new TableColumn(this.paramTable,SWT.NONE);
			columnDirection.setText("Direction");
			columnDirection.setWidth(70);
			TableColumn columnName = new TableColumn(this.paramTable,SWT.NONE);
			columnName.setText("Name");
			columnName.setWidth(100);
			TableColumn columnType = new TableColumn(this.paramTable,SWT.NONE);
			columnType.setText("Type");
			columnType.setWidth(70);
			TableColumn columnRequired = new TableColumn(this.paramTable,SWT.NONE);
			columnRequired.setText("Required");
			columnRequired.setWidth(70);
			TableColumn columnDesc = new TableColumn(this.paramTable,SWT.NONE);
			columnDesc.setText("Description");
			columnDesc.setWidth(300);
			this.paramTable.setEnabled(false);
		}
	}
	
	private void loadParameter() {
		List<MoDiscoWorkParameter> paramList = null;
		if(this.transformationsTable.getSelectionIndex()!=-1){
			paramList = this.controller.getAllParameterOfDriver(this.transformationsTable.getSelectionIndex());		
		}
		if(paramList!=null){
			createParameterTable(true);
			this.paramTable.removeAll();
			for(MoDiscoWorkParameter param : paramList){
				TableItem item = new TableItem(this.paramTable,SWT.NONE);
				item.setText(new String[]{param.getDirection().toString(),param.getName(),param.getType(),Boolean.toString(param.isRequired()),param.getDescription()});
			}
			this.paramTable.pack();
		}else{
			createParameterTable(false);
			this.labNoParam.pack();
		}
		this.compositeParameter.pack();
	}
	
	private void updateStatus(String message) {
		setMessage("Build your MoDiscoWorkflow");
		setErrorMessage(message);
		if(message == null){
			this.isValid = true;
		}else{
			this.isValid = false;
		}
		this.rootContainer.layout();
		this.scrollContainer.setMinSize(this.rootContainer.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		this.scrollContainer.layout();
		updateLaunchConfigurationDialog();
	}

	/**
	 * Update the status when the dialog changed container
	 */
	private void dialogChangedContainer() {
		String transformationName = this.controller.allComponentsHaveConfiguration();
		if(transformationName!=null){
			updateStatus("The transformation "+transformationName+" does not have configuration anymore. You have to delete it to execute the workflow");
			return;
		}
		updateStatus(null);	
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#getName()
	 */
	public String getName() {
		return Constant.wfTab;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.AbstractLaunchConfigurationTab#getImage()
	 */
	public Image getImage() {
		return Activator.getImageDescriptor(Constant.pathLittleImage).createImage();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.AbstractLaunchConfigurationTab#isValid(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	@Override
	public boolean isValid(ILaunchConfiguration launchConfig) {
		return this.isValid;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#initializeFrom(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	public void initializeFrom(ILaunchConfiguration configuration) {
		try {
			String id = configuration.getAttribute(Constant.idWorkflow,Constant.idMinimaliste);
			this.controller = new ControllerWorkflowTransformation(id);
			this.controller.setGroup(((LaunchConfigurationsDialog)getLaunchConfigurationDialog()).getLaunchGroup());
			this.gpButtonTransformation.setController(this.controller);
					
			if(id!=null){
				if(id.equals(Constant.idMinimaliste) == false){
					String configurationResourcePath = configuration.getAttribute(Constant.resourcePath,(String)null);
					//Case of dupplication launcher
					if(configurationResourcePath!=null&&!configurationResourcePath.equals(this.resourcePath)){
						File f1 = new File(configurationResourcePath);
						File f2 = new File(this.resourcePath);
						if(f1.exists()&& !f2.exists()){
							copyFile(configurationResourcePath,this.resourcePath);
						}
					}
				}
			}
			this.controller.initializationWorkflowResource(configuration,this.resourcePath);
		} catch (CoreException e) {
			e.printStackTrace();
		}
		this.controller.refresh(-1);
		dialogChangedContainer();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#performApply(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(Constant.idWorkflow,this.controller.getIdWorkflowExecution());
		if(this.controller.getIdWorkflowExecution().equals(Constant.idMinimaliste)){
			this.controller.saveWorkflowResource(configuration);
		}else{
			configuration.setAttribute(Constant.resourcePath,this.resourcePath);
			List<MoDiscoWorkImpl> moDiscoList = this.controller.getAllMoDiscoWork();
			configuration.setAttribute(Constant.moDiscoWorkNumber,moDiscoList.size());
			configuration.setAttribute(Constant.moDiscoListSerialize, listOrchestration(moDiscoList));
		}
	}
	
	private List<String> listOrchestration(List<MoDiscoWorkImpl> moDiscoWorkList){
		List<String> tmpList = new ArrayList<String>();
		for(MoDiscoWorkImpl modisco : moDiscoWorkList){
			tmpList.add(modisco.getName()+" "+modisco.getIndex());
		}
		return tmpList;
	}
	
	/**
	 * Allows to copy a file
	 * @param pathFile1 Source file
	 * @param pathFile2 Destination file
	 */
	private void copyFile(String pathFile1, String pathFile2){
		FileChannel in = null; // canal d'entre
		FileChannel out = null; // canal de sortie
		try {
		  in = new FileInputStream(pathFile1).getChannel();
		  out = new FileOutputStream(pathFile2).getChannel();
		  // Copie depuis le in vers le out
		  in.transferTo(0, in.size(), out);
		} catch (Exception e) {
		  e.printStackTrace(); // n'importe quelle exception
		} finally { // finalement on ferme
		  if(in != null) {
		  	try {
			  in.close();
			} catch (IOException e) {}
		  }
		  if(out != null) {
		  	try {
			  out.close();
			} catch (IOException e) {}
		  }
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#setDefaults(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
	 */
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {	
	}
	
	public ControllerWorkflowTransformation getController() {
		return this.controller;
	}
	
	public void setResourcePath(String resourcePath) {
		this.resourcePath = resourcePath;
	}
	
	
}
