/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow.defaultengine;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.workflow.Constant;
import org.eclipse.gmt.modisco.workflow.WorkflowModelInterface;
import org.eclipse.gmt.modisco.workflow.modiscowork.MoDiscoWork;
import org.eclipse.gmt.modisco.workflow.modiscowork.ModiscoworkFactory;
import org.eclipse.gmt.modisco.workflow.ui.common.MoDiscoWorkParameter;

@SuppressWarnings("unchecked")
public class WorkflowModelImpl implements WorkflowModelInterface {

	private List<MoDiscoWork> moDiscoWorkList;
	
	public void addComponentWorkflow(String name, EObject eModiscowork,
			List<MoDiscoWorkParameter> paramList) {
		MoDiscoWork moDiscoWork = (MoDiscoWork)eModiscowork;
		this.moDiscoWorkList.add(moDiscoWork);
	}


	public List<EObject> getAllComponents() {
		List<? extends EObject> listComponents = this.moDiscoWorkList;
		return (List<EObject>) listComponents;
	}

	public EObject getComponent(int index) {
		return this.moDiscoWorkList.get(index);
	}

	public void initialization(ILaunchConfiguration configuration, String path) {
		 try {
			this.moDiscoWorkList = listStringTolistMoDiscoWork(configuration.getAttribute(Constant.moDiscoListMinimalist,new ArrayList<String>()));
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	private List<MoDiscoWork> listStringTolistMoDiscoWork(List<String> stringList) {
		List<MoDiscoWork> moDiscoList = new ArrayList<MoDiscoWork>();
		for(int i=0; i<stringList.size(); i=i+3){
			MoDiscoWork modisco = ModiscoworkFactory.eINSTANCE.createMoDiscoWork();
			modisco.setName(stringList.get(i));
			modisco.setIndex(Integer.valueOf(stringList.get(i+1)));
			modisco.setType(stringList.get(i+2));
			moDiscoList.add(modisco);
		}
		return moDiscoList;
	}

	public void moveResource(String path) {}

	public void removeComponent(int index) {
		this.moDiscoWorkList.remove(index);		
	}

	public void removeResource(String resourcePath) {}

	public void save(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(Constant.moDiscoListMinimalist,listMoDiscoWorkToListString());
	}

	private List<String> listMoDiscoWorkToListString() {
		List<String> listString = new ArrayList<String>();
		for(MoDiscoWork modisco : this.moDiscoWorkList){
			listString.add(modisco.getName());
			listString.add(Integer.toString(modisco.getIndex()));
			listString.add(modisco.getType());
		}
		return listString;
	}

	public void setComponent(int index,
			EObject moDiscoWork) {
		MoDiscoWork modisco = (MoDiscoWork)moDiscoWork;
		this.moDiscoWorkList.set(index,modisco);
	}

}
