/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.adapters;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.gmt.modisco.common.editor.editors.EditorConfiguration;
import org.eclipse.gmt.modisco.common.editor.util.ImageProvider;

/** An item provider for links to the EMF container of elements ({@link EObject#eContainer()}) */
public class ContainmentLinkItemProvider extends TransientItemProvider implements
		IEditingDomainItemProvider, IStructuredItemContentProvider, ITreeItemContentProvider,
		IItemLabelProvider, IItemPropertySource, IItemFontProvider, IItemColorProvider {

	/** The model element that appears as the parent of the link in the tree */
	protected final EObject parent;
	/** The container model element to display under the link */
	protected final EObject container;
	/** The configuration of the editor in which the model is displayed */
	protected final EditorConfiguration editorConfiguration;

	/**
	 * Instantiate a new ContainmentLinkItemProvider.
	 * 
	 * @param adapterFactory
	 *            the adapter factory used to create adapters
	 * @param parent
	 *            the model element that appears as the parent of the link in the tree
	 * @param container
	 *            the container model element to display under the link (null means no container)
	 * @param editorConfiguration
	 *            the configuration of the editor in which the model is displayed
	 */
	public ContainmentLinkItemProvider(AdapterFactory adapterFactory, EObject parent,
			EObject container, EditorConfiguration editorConfiguration) {
		super(adapterFactory, parent);
		this.parent = parent;
		this.container = container;
		this.editorConfiguration = editorConfiguration;
	}

	@Override
	public String getText(Object object) {
		String oppositeLink = "";
		if (this.editorConfiguration.isShowOppositeLinks()) {
			EStructuralFeature containingFeature = this.parent.eContainingFeature();
			if (containingFeature != null) {
				oppositeLink = " <-> " + containingFeature.getName();
			}
		}

		return "/eContainer" + oppositeLink;
	}

	@Override
	public Object getImage(Object object) {
		return ImageProvider.getInstance().getContainerIcon();
	}

	@Override
	public Object getParent(Object object) {
		return this.parent;
	}

	@Override
	public Collection<?> getChildren(Object object) {
		if (this.container == null)
			return Collections.EMPTY_LIST;

		return Collections.singletonList(this.container);
	}

	@Override
	protected String getFeatureText(Object feature) {
		return "/eContainer";
	}

	@Override
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain,
			Object sibling) {
		return Collections.emptyList();
	}

	@Override
	public Object getFont(Object object) {
		return this.editorConfiguration.getCustomItalicFont();
	}

	@Override
	public Object getCreateChildImage(Object owner, Object feature, Object child,
			Collection<?> selection) {
		return null;
	}

	@Override
	public Object getForeground(Object object) {
		if (this.container == null)
			return IItemColorProvider.GRAYED_OUT_COLOR;
		return super.getForeground(object);
	}

}