/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.java.execution;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.gmt.modisco.workflow.AbstractDriverExecution;
import org.eclipse.gmt.modisco.workflow.DriverExecutionInterface;
import org.eclipse.gmt.modisco.workflow.driver.java.Constant;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Work;
import org.eclipse.jdt.launching.JavaLaunchDelegate;

public class TransformationExecute extends AbstractDriverExecution implements DriverExecutionInterface {

	public TransformationExecute() {
	}

	public void launch(ILaunchConfigurationWorkingCopy configuration,ILaunch launch) {
		try {
			JavaLaunchDelegate delegate = new JavaLaunchDelegate();
			delegate.launch(configuration,ILaunchManager.RUN_MODE, launch,new NullProgressMonitor());
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	public void launch(Work Work) {
		ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(Constant.typeLaunchConfiguration);
		ILaunchConfiguration launchConfiguration = null;
		try {
			launchConfiguration = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom("tmp"));
			ILaunchConfigurationWorkingCopy copy = launchConfiguration.getWorkingCopy();
			WorkToLaunchWorkingCopy(Work,copy);
			copy.launch(ILaunchManager.RUN_MODE, new NullProgressMonitor());
		} catch (CoreException e) {
			e.printStackTrace();
		}
	
	}
}
