/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow.driver.atl.ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.workflow.Direction;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.driver.atl.Constant;
import org.eclipse.gmt.modisco.workflow.ui.common.MoDiscoWorkParameter;

public class LaunchDriverATL implements DriverInterface {

	public String getTypeLaunchConfig() {
		return Constant.typeLaunchConfiguration;
	}

	public List<MoDiscoWorkParameter> getParameters(ILaunchConfiguration configuration) {
		List<MoDiscoWorkParameter> listParam = new ArrayList<MoDiscoWorkParameter>();
		MoDiscoWorkParameter param = new MoDiscoWorkParameter();
		param.setDirection(Direction.in);
		param.setName("Metamodele in");
		param.setType("Ecore");
		param.setRequired(true);
		param.setDescription("Meta-Modle in for the transformation");
		listParam.add(param);
		MoDiscoWorkParameter param2 = new MoDiscoWorkParameter();
		param2.setDirection(Direction.in);
		param2.setName("Metamodele out");
		param2.setType("Ecore");
		param2.setRequired(true);
		param2.setDescription("Meta-Modle out for the transformation");
		listParam.add(param2);
		MoDiscoWorkParameter param3 = new MoDiscoWorkParameter();
		param3.setDirection(Direction.in);
		param3.setName("Modele in");
		param3.setType("Undefined");
		param3.setRequired(true);
		param3.setDescription("Modle in for the transformation");
		listParam.add(param3);
		MoDiscoWorkParameter param4 = new MoDiscoWorkParameter();
		param4.setDirection(Direction.in);
		param4.setName("Modele out");
		param4.setType("Undefined");
		param4.setRequired(true);
		param4.setDescription("Modle out for the transformation");
		listParam.add(param4);
		return listParam;
	}
}
