/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.discoverersmanager.handlers;

import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.discoverersmanager.Discoverer;

/**
 * @author Gabriel Barbier
 *
 */
public class DiscovererHandler implements Discoverer {

	private final Discoverer delegate;
	
	private String name;
	private String[] paths;
	
	public DiscovererHandler(Discoverer delegateParemeter) {
		this.delegate = delegateParemeter;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.discoverersmanager.DiscovererInterface#applyTo(java.lang.Object)
	 */
	public boolean applyTo(Object source) {
		return this.delegate.applyTo(source);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.discoverersmanager.DiscovererInterface#discoverElement(java.lang.Object, org.eclipse.emf.common.util.URI)
	 */
	public Resource discoverElement(Object source, URI target) {
		Resource resource = null;
		this.delegate.discoverElement(source, target);
		return resource;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * @param paths the paths to set
	 */
	public void setPaths(String[] paths) {
		this.paths = paths;
	}

	/**
	 * @return the paths
	 */
	public String[] getPaths() {
		return this.paths;
	}

	public String toString() {
		String result = this.getName();
		if ((result == null) || (result.length() == 0)) {
			result = this.delegate.toString();
		}
		return result;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.discoverersmanager.DiscovererInterface#discoverElement(java.lang.Object, java.util.Map)
	 */
	public void discoverElement(final Object source, final Map<String, Object> parameters) {
		Job job = new Job("Discover resources ...") {

			@Override
			protected IStatus run(IProgressMonitor monitor) {
				DiscovererHandler.this.delegate.discoverElement(
						source,
						parameters);
				return Status.OK_STATUS;
			}
			
		};
		job.schedule();
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.discoverersmanager.DiscovererInterface#getParameterKeys()
	 */
	public Set<String> getParameterKeys() {
		// TODO Auto-generated method stub
		return null;
	}
}
