/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui;


import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.TableItem;

/**
 * This class defines a generic wizard. 
 * It contains different page according to the mode in which it is called
 * @author Nicolas Payneau
 */
public class DriversWizard extends Wizard{
	
	private DriverPage driver;
	private LoadLauncherPage loadLauncher;
	private ControllerDriverPage controllerDriverpage;
	private ControllerWorkflowTransformation controllerWorkflow;
	private Constants mode;
	
	/**
	 * Class constructor
	 * @param controllerWorkflow The controller managing the workflow
	 * @param controllerDriverpage The controller managing the display
	 * @param mode Opening mode of wizard (add or edit or load)
	 */
	public DriversWizard(ControllerWorkflowTransformation controllerWorkflow,
			ControllerDriverPage controllerDriverpage, Constants mode){
		this.controllerWorkflow = controllerWorkflow;
		this.mode = mode;
		this.controllerDriverpage = controllerDriverpage;
		if(mode.equals(Constants.addMode)){
			this.setWindowTitle("Add a MoDiscoWork");
		}else if(mode.equals(Constants.editMode)){
			this.setWindowTitle("Edit a MoDiscoWork");
		}else{
			this.setWindowTitle("Load a MoDiscoWork");
		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	@Override
	public final void addPages() {
		this.driver = new DriverPage("Driver selected",this.mode,this.controllerWorkflow.getGroup());
		this.driver.setController(this.controllerDriverpage);
		if(this.mode.equals(Constants.addMode)){
			this.addPage(new ListDriversPage("List of drivers",this.controllerDriverpage));
		}
		if(this.mode.equals(Constants.loadMode)){
			this.loadLauncher = new LoadLauncherPage("List of Launcher",this.controllerDriverpage);
			this.addPage(this.loadLauncher);
		}
		if(!this.mode.equals(Constants.loadMode)){
			this.addPage(this.driver);
		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	@Override
	public boolean performFinish() {
		if(this.mode.equals(Constants.addMode)){
			this.controllerDriverpage.launchPerformFinish();
			this.controllerWorkflow.addElement(this.controllerDriverpage.getCurrentDriver().getTypeLaunchConfig(),-1,this.driver.getTransformationName(),true);
		}else if (this.mode.equals(Constants.editMode)){
			this.controllerDriverpage.launchPerformFinish();
			this.controllerWorkflow.performFinishEditTransformation(this.driver.getTransformationName());
		}else if (this.mode.equals(Constants.loadMode)){
			try {
				for(TableItem item : this.loadLauncher.getItemsSelected()){	
					this.controllerWorkflow.addElement(this.loadLauncher.getLaunchConfigurationMap().get(item).getType().getIdentifier(),-1,item.getText(),true);
				}
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
		return true;
	}	
}
