/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;

/**
 * This class is one of subclass of CommonTab.
 * We redefine the launch file share method because we share too the workflow resource file.
 * @author Nicolas Payneau
 */
public class MoDiscoWorkflowCommonTab extends CommonTab{

	private String resourcePath;
	
	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		super.initializeFrom(configuration);
		try {
			updateConfigFromLocalShared(configuration.getWorkingCopy());
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}
	
	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		super.performApply(configuration);
		updateConfigFromLocalShared(configuration);
	}
	
	/**
	 * Updates the resource from the local shared resource
	 * @param config the local shared configuration working copy
	 */
	private void updateConfigFromLocalShared(ILaunchConfigurationWorkingCopy config) {
		if (config.isLocal() == false) {	
			IPath path = null;
			try{
				path = config.getFile().getLocation().removeLastSegments(1).append(config.getName()).addFileExtension(Constants.workflowExtension);
				this.resourcePath = path.toString();
			}catch(java.lang.IllegalArgumentException e){
				/*
				 * Allows to catch an exception when you click on the radio to share the configuration.
				 */
//				e.printStackTrace();
			}
		} else {
			this.resourcePath = Activator.getDefault().getStateLocation().append(config.getName()).addFileExtension(Constants.workflowExtension).toString();
		}
	}

	public String getResourcePath() {
		return this.resourcePath;
	}

}
