package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constant;
import org.eclipse.gmt.modisco.workflow.ui.common.WorkflowTypeDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MoDiscoExportTab extends AbstractLaunchConfigurationTab{

	private ScrolledComposite scrollContainer;
	private Composite rootContainer;
	private Label labelWorkflowUse;
	private String idWorkflow;
	private Button buttonCreate;

	public void createControl(Composite parent) {
		this.scrollContainer = new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
		this.scrollContainer.setExpandHorizontal(true);
		this.scrollContainer.setExpandVertical(true);
		
		this.rootContainer = new Composite(this.scrollContainer, SWT.NULL);
		GridLayout layoutRoot = new GridLayout();
		this.rootContainer.setLayout(layoutRoot);
		layoutRoot.numColumns = 1;
		layoutRoot.verticalSpacing = 9;
		this.scrollContainer.setContent(this.rootContainer);
		
	    Group groupWorkflow = new Group(this.rootContainer, SWT.NULL);
	    groupWorkflow.setText("Type of workflow used");
	    GridLayout layoutWorkflow = new GridLayout();
		groupWorkflow.setLayout(layoutWorkflow);
		layoutWorkflow.numColumns = 3;
		layoutRoot.verticalSpacing = 9;
		GridData gdHoriz = new GridData(GridData.FILL_HORIZONTAL);
		groupWorkflow.setLayoutData(gdHoriz);

	    Label labelWorkflow = new Label(groupWorkflow, SWT.NONE);
	    labelWorkflow.setText("Your workflow type: ");
	    labelWorkflow.pack();
	    
	    this.labelWorkflowUse = new Label(groupWorkflow, SWT.NONE);
	    this.labelWorkflowUse.setText("");
	    this.labelWorkflowUse.pack();
	    this.labelWorkflowUse.setLayoutData(gdHoriz);

	    Button buttonChangeWorkflow = new Button(groupWorkflow, SWT.PUSH);
	    buttonChangeWorkflow.setText("Change");
	    buttonChangeWorkflow.addSelectionListener(new SelectionAdapter() {	
			@Override
			public void widgetSelected(SelectionEvent e) {
				MoDiscoExportTab.this.changeWorkflowType();
			}
		});
	    buttonChangeWorkflow.pack();

	    Group groupExport = new Group(this.rootContainer, SWT.NULL);
	    groupExport.setText("Create a discoverer project");
	    groupExport.setLayout(layoutWorkflow);
	    groupExport.setLayoutData(gdHoriz);
	    
	    
	    this.buttonCreate = new Button(groupExport, SWT.CHECK);
	    this.buttonCreate.setText("Create a discoverer project from MoDiscoWorkflow");
	    this.buttonCreate.pack();
	    this.buttonCreate.setLayoutData(gdHoriz);
	    this.buttonCreate.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				updateLaunchConfigurationDialog();
			}
		});
	    
	    setControl(this.rootContainer);
		setControl(this.scrollContainer);
	}

	public String getName() {
		return "Workflow type and Export";
	}

	public void initializeFrom(ILaunchConfiguration configuration) {
		try {
			initializeLabelWorkflow(configuration.getAttribute(Constant.idWorkflow, Constant.idMinimaliste));
			this.buttonCreate.setSelection(configuration.getAttribute(Constant.workflowExport, false));
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(Constant.idWorkflow, this.idWorkflow);
		configuration.setAttribute(Constant.workflowExport, this.buttonCreate.getSelection());
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {}
	
	@Override
	public Image getImage() {
		return Activator.getImageDescriptor(Constant.pathExportImage).createImage();
	}

	private void initializeLabelWorkflow(String id){
		this.idWorkflow = id;
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint(Constant.nameExtensionPointWorkflow); //$NON-NLS-1$

		for (IExtension extension : point.getExtensions()) {
			for (IConfigurationElement element : extension.getConfigurationElements()) {
				if(extension.getUniqueIdentifier().equals(id)){
					if(element.getName().equals("workflow")){
						this.labelWorkflowUse.setText(element.getAttribute("name"));
					}
				}
			}
		}
	}
	
	private void changeWorkflowType(){
		WorkflowTypeDialog dialog = new WorkflowTypeDialog(new Shell(this.getShell()));
		dialog.open();		
		this.idWorkflow = dialog.getIdWorkflow();
		if(dialog.getNameWorkflow()!=null){
			this.labelWorkflowUse.setText(dialog.getNameWorkflow());
			updateLaunchConfigurationDialog();
		}
	}
	
}
