package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constant;

public class MoDiscoWorkflowCommonTab extends CommonTab{

	private String resourcePath;
	
	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		// TODO Auto-generated method stub
		super.initializeFrom(configuration);
		try {
			updateConfigFromLocalShared(configuration.getWorkingCopy());
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}
	
	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		super.performApply(configuration);
		updateConfigFromLocalShared(configuration);
	}
	
	/**
	 * Updates the resource form the local shared resource
	 * @param config the local shared config working copy
	 */
	private void updateConfigFromLocalShared(ILaunchConfigurationWorkingCopy config) {
		if (config.isLocal() == false) {	
			IPath path = null;
			try{
				path = config.getFile().getLocation().removeLastSegments(1).append(config.getName()).addFileExtension(Constant.extension);
				this.resourcePath = path.toString();
			}catch(java.lang.IllegalArgumentException e){
				/*
				 * TODO
				 */
//				e.printStackTrace();
			}
		} else {
			this.resourcePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata").append(".plugins").append(Activator.PLUGIN_ID).append(config.getName()).addFileExtension(Constant.extension).toString();
		}
	}

	public String getResourcePath() {
		return this.resourcePath;
	}

}
