/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.core.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

/**
 * @author Gabriel Barbier
 *
 */
public interface FolderUtils 
{
    public static final FolderUtils instance = new FolderUtilsImpl();


     void clearFolder(
        final File dirtyFolder);

     boolean compareFolders(
        final File folderSource,
        final File folderTarget);
     
     boolean compareFolders(
    	final File folderSource,
    	final File folderTarget,
    	final FilenameFilter filter);

     boolean compareFiles(
        final File source,
        final File target);

     String getFileContent(
        final File source);
     
    /**
      * Copies the directory source to the directory target.
      * The target is created if not exists.
      * @param srcDir
      * @param destDir
      * @throws IOException
      */
     void copyDirectory(File srcDir, File destDir) throws IOException;
 	/**
 	 * Copies the file source to the file target.
 	 * 
 	 * @return true is success
 	 */
     boolean copyFile(File source, File destination);
 	/**
 	 * Recursively delete a directory.
 	 * 
 	 * @param directory
 	 *            directory to delete
 	 * @throws IOException
 	 *             in case deletion is unsuccessful
 	 */
     void deleteDirectory(File directory) throws IOException;
}
