/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.execution;

import java.io.File;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.gmt.modisco.workflow.DriverExecutionInterface;
import org.eclipse.gmt.modisco.workflow.actions.MoDiscoWorkflowDelegate;
import org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.Constant;
import org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.MoDiscoWorkflowLauncher;

public class TransformationExecute implements DriverExecutionInterface, MoDiscoWorkflowLauncher {

	public void launch(ILaunchConfigurationWorkingCopy configuration, ILaunch launch) {
		try {
			MoDiscoWorkflowDelegate delegate = new MoDiscoWorkflowDelegate();
			delegate.launch(configuration,ILaunchManager.RUN_MODE, launch,new NullProgressMonitor());
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	public ILaunchConfiguration createConfiguration() {
		ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(Constant.typeLaunchConfiguration);
		ILaunchConfiguration launchConfiguration = null;
		try {
			launchConfiguration = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(null));
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return launchConfiguration;
	}

	public void launch(ILaunchConfiguration configuration) {
		try {
			configuration.launch(ILaunchManager.RUN_MODE,new NullProgressMonitor());
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	public ILaunchConfiguration createConfiguration(File file) {
		ILaunchConfiguration configuration = null;
		String configurationName = file.getName().substring(0, file.getName().lastIndexOf("."));
		try {
			for(ILaunchConfiguration config : DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations()){
				if(config.getName().equals(configurationName)){
					configuration = config;
					break;
				}
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return configuration;
	}
}
