/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.discoverersmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

/**
 * @author GBarbier
 *
 */
public class DiscovererImpl implements Discoverer {

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.discoverersmanager.Discoverer#discoverElement(java.lang.Object, org.eclipse.emf.common.util.URI)
	 */
	public Resource discoverElement(Object source, URI target) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.discoverersmanager.Discoverer#discoverElement(java.lang.Object, java.util.Map)
	 */
	public void discoverElement(Object source,
			Map<DiscoveryParameter, Object> parameters) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.discoverersmanager.Discoverer#getDiscovererParameters()
	 */
	public List<DiscoveryParameter> getDiscovererParameters() {
		List<DiscoveryParameter> parameters = new ArrayList<DiscoveryParameter>();
		DiscoveryParameter parameter = null;
		
		parameter = new DiscoveryParameterImpl("Boolean", DiscoveryParameterDirectionKind.in, Boolean.class, true);
		parameters.add(parameter);
		parameter = new DiscoveryParameterImpl("Integer", DiscoveryParameterDirectionKind.in, Integer.class, true);
		parameters.add(parameter);
		parameter = new DiscoveryParameterImpl("List", DiscoveryParameterDirectionKind.in, List.class, true);
		parameters.add(parameter);
		parameter = new DiscoveryParameterImpl("Set", DiscoveryParameterDirectionKind.in, Set.class, true);
		parameters.add(parameter);
		parameter = new DiscoveryParameterImpl("Map", DiscoveryParameterDirectionKind.in, Map.class, true);
		parameters.add(parameter);
		parameter = new DiscoveryParameterImpl("First", DiscoveryParameterDirectionKind.in, String.class, true);
		parameters.add(parameter);
		parameter = new DiscoveryParameterImpl("Second", DiscoveryParameterDirectionKind.in, String.class, false);
		parameters.add(parameter);
		for (int i = 0; i < 10; i++) {
			parameter = new DiscoveryParameterImpl("Param" + i, DiscoveryParameterDirectionKind.in, String.class, true);
			parameters.add(parameter);
		}
		parameter = new DiscoveryParameterImpl("First", DiscoveryParameterDirectionKind.inout, String.class, true);
		parameters.add(parameter);
		parameter = new DiscoveryParameterImpl("Second", DiscoveryParameterDirectionKind.inout, String.class, false);
		parameters.add(parameter);
		
		parameter = new DiscoveryParameterImpl("First", DiscoveryParameterDirectionKind.out, String.class, true);
		parameters.add(parameter);
		parameter = new DiscoveryParameterImpl("Second", DiscoveryParameterDirectionKind.out, String.class, false);
		parameters.add(parameter);
		
		return parameters;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.discoverersmanager.Discoverer#isApplicableTo(java.lang.Object)
	 */
	public boolean isApplicableTo(Object source) {
		// TODO Auto-generated method stub
		return true;
	}

}
