/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.discoverersmanager.ui.launch.utils;

import org.eclipse.jface.viewers.TextCellEditor;

/**
 * @author gbarbier
 *
 */
public class BooleanCellEditor extends TextCellEditor {

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.TextCellEditor#doGetValue()
	 */
	@Override
	protected Object doGetValue() {
		Boolean result = null;
		result = Boolean.valueOf(this.text.getText());
		return result;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.TextCellEditor#doSetValue(java.lang.Object)
	 */
	@Override
	protected void doSetValue(Object value) {
		super.doSetValue(String.valueOf(value));
	}
	
}
