/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.adapters;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

/** A singleton adapter factory which creates {@link ParentAdapter}s. */
public class ParentAdapterFactory extends AdapterFactoryImpl {

	private ParentAdapterFactory() {
	}

	private static ParentAdapterFactory instance;

	/** Get the singleton factory, which is used to create {@link ParentAdapter}s */
	public static ParentAdapterFactory getInstance() {
		if (instance == null) {
			instance = new ParentAdapterFactory();
		}
		return instance;
	}

	@Override
	public boolean isFactoryForType(Object type) {
		return type instanceof EObject || type == ParentAdapter.class;
	}

	@Override
	protected Adapter createAdapter(Notifier target) {
		return new ParentAdapter();
	}

}