/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *    Nicolas Bros (Mia-Software)
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.editor.ui;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.common.editor.MoDiscoEditorPlugin;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/**
 * A dialog which displays a list of URIs from the EMF package registry, and allows the user to open
 * one of them.
 * 
 * @author Gabriel Barbier
 */
public class DialogUriSelection extends ElementListSelectionDialog {

	private String uri = ""; //$NON-NLS-1$
	private static Image image = null;

	/**
	 * Constructor.
	 * 
	 * @param parent
	 *            the parent shell
	 */
	public DialogUriSelection(Shell parent) {
		super(parent, new LabelProvider());

		setTitle("Open Model From EMF Registry");
		setMessage("Registered EPackages:");

		Set<String> uris = new TreeSet<String>();
		for (Iterator<?> it = ((Map<?, ?>) EPackage.Registry.INSTANCE).keySet().iterator(); it
				.hasNext();) {
			uris.add((it.next()).toString());
		}

		setElements(uris.toArray());
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.ui.dialogs.SelectionStatusDialog#okPressed()
	 */
	@Override
	protected void okPressed() {
		super.okPressed();

		if (getResult().length > 0) {
			this.uri = getResult()[0].toString();
		}
	}

	public String getUriSelected() {
		return this.uri;
	}

	@Override
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		if (image == null) {
			image = MoDiscoEditorPlugin.getImageDescriptor("icons/logoMoDiscoMini.gif")
					.createImage();
		}
		shell.setImage(image);
	}
}