/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.workflow.ui.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.gmt.modisco.workflow.Constant;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;


public class AdditionalButtonsComposite extends Composite {
	private Button newButton = null;
	private Button editButton = null;
	private Button removeButton = null;
	private Button upButton = null;
	private Button downButton = null;
	private Button loadButton = null;
	private Table tableAssociee;
	private ControllerWorkflowTransformation controller;

	/**
	 * Class constructor
	 * @param parent The composite parent
	 * @param style The style of composite
	 * @param table The table of transformations
	 * @param controller The controller managing the display
	 */
	public AdditionalButtonsComposite(Composite parent, int style, Table table, ControllerWorkflowTransformation controller) {
		super(parent, style);
		this.tableAssociee = table;
		this.controller = controller;
		initialize();
	}

	/**
	 * Create the composite representing the additional buttons
	 */
	private void initialize() {
		GridData gridDataUp = new GridData();
		gridDataUp.horizontalAlignment = GridData.FILL;
		gridDataUp.verticalAlignment = GridData.CENTER;
		GridData gridDataDown = new GridData();
		gridDataDown.horizontalAlignment = GridData.FILL;
		gridDataDown.verticalAlignment = GridData.CENTER;
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.CENTER;
		this.newButton = new Button(this, SWT.NONE);
		this.newButton.setText("New ...");
		this.newButton.setLayoutData(gridData);
		this.newButton.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				AdditionalButtonsComposite.this.newAdditionalTransformation();
			}
		});
		this.editButton = new Button(this, SWT.NONE);
		this.editButton.setText("Edit ...");
		this.editButton.setLayoutData(gridData);
		this.editButton.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				AdditionalButtonsComposite.this.editAdditionalTransformation();				
			}
		});
		this.removeButton = new Button(this, SWT.NONE);
		this.removeButton.setText("Remove");
		this.removeButton.setLayoutData(gridData);
		this.removeButton.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				AdditionalButtonsComposite.this.removeAdditionalTransformation();
			}
		});
		this.loadButton = new Button(this, SWT.NONE);
		this.loadButton.setText("Load...");
		this.loadButton.setLayoutData(gridData);
		this.loadButton.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				AdditionalButtonsComposite.this.loadAdditionalTransformation();
			}
		});
		this.upButton = new Button(this, SWT.NONE);
		this.upButton.setText("Up");
		gridDataUp.verticalIndent = 30;
		this.upButton.setLayoutData(gridDataUp);
		this.upButton.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				AdditionalButtonsComposite.this.upAdditionalTransformation();
			}
		});
		this.downButton = new Button(this, SWT.NONE);
		this.downButton.setText("Down");
		this.downButton.setLayoutData(gridDataDown);
		this.downButton.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				AdditionalButtonsComposite.this.downAdditionalTransformation();
			}
		});
		
		this.tableAssociee.addMouseListener(new MouseAdapter() {		
			public void mouseDoubleClick(MouseEvent e) {
				AdditionalButtonsComposite.this.editAdditionalTransformation();			
			}
		});		
		GridData layoutData = new GridData();
		layoutData.verticalAlignment = org.eclipse.swt.layout.GridData.BEGINNING;
		this.setSize(new Point(63, 202));
		this.setLayout(new GridLayout());
		this.setLayoutData(layoutData);
	}

	/**
	 * Add a new MoDiscoWork in the MoDiscoWorkflow
	 */
	private final void newAdditionalTransformation() {
		this.controller.newMoDiscoWork();
	}
	
	/**
	 * Edit a present MoDiscoWork in the MoDiscoWorkflow
	 */
	private final void editAdditionalTransformation() {
		if(this.tableAssociee.getSelectionIndex()!=-1){
			if(!this.controller.editMoDiscoWork(this.tableAssociee.getSelectionIndex())){
				MessageDialog.openError(getShell(), "Configuration not found", "The configuration not found");
			}
			
		}
	}
	
	/**
	 * Remove a MoDiscoWork in the MoDiscoWorkflow
	 */
	private final void removeAdditionalTransformation() {
		if(this.tableAssociee.getSelectionIndex()!=-1){
			RemoveDialog dialog = new RemoveDialog(getShell(),this.tableAssociee.getItem(this.tableAssociee.getSelectionIndex()).getText());
			dialog.open();
			if(dialog.getMode().equals(Constant.deleteFromLauncher)){
				this.controller.removeFromLauncher(getAllIndexFromString(this.tableAssociee.getItem(this.tableAssociee.getSelectionIndex()).getText()));
			}else if(dialog.getMode().equals(Constant.deleteFromWorkflow)){
				this.controller.removeFromWorkflow(this.tableAssociee.getSelectionIndex());
			}
		}

	}
	
	/**
	 * Allows to retrieve all items which have the same name.
	 * @parameter name Name of item
	 * @return Return a list of index item corresponding to name specified
	 */
	private List<Integer> getAllIndexFromString(String name) {
		List<Integer> indexList = new ArrayList<Integer>();
		for(TableItem item : this.tableAssociee.getItems()){
			if(item.getText().equals(name)){
				indexList.add(this.tableAssociee.indexOf(item));
			}
		}
		Collections.sort(indexList);
		Collections.reverse(indexList);
		return indexList;
	}

	/**
	 * Up the MoDiscoWork selected in the MoDiscoWorkflow
	 */
	private final void upAdditionalTransformation() {
		if(this.tableAssociee.getSelectionIndex()>0&&this.tableAssociee.getSelectionIndex()!=-1){
			this.controller.upMoDiscoWork(this.tableAssociee.getSelectionIndex());
		}
	}	
	
	/**
	 * Down the MoDiscoWork selected in the MoDiscoWorkflow
	 */
	private final void downAdditionalTransformation() {
		//+1 because the numbering begining at 0
		if((this.tableAssociee.getSelectionIndex()+1<this.tableAssociee.getItemCount())
				&&this.tableAssociee.getSelectionIndex()!=-1)
			this.controller.downMoDiscoWork(this.tableAssociee.getSelectionIndex());
	}
	
	/**
	 * Load a MoDiscoWork in the MoDiscoWorkflow
	 */
	private void loadAdditionalTransformation() {
		this.controller.loadAdditionalTransformation();
	}
	
	public Table getTable(){
		return this.tableAssociee;
	}
	
	public void setController(ControllerWorkflowTransformation controller){
		controller.setAdditionnalButton(this);
		this.controller = controller;
	}
	
}
